/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.presentation.systems.cdma.CDMASystemsComboBoxModel;
import org.seamcat.presentation.systems.cdma.DetailedSystemPlot;
import org.seamcat.presentation.systems.cdma.SnapshotVectorsListModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMACellTableModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAInterfererTableModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMALinkInfoTableModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMASystemTableModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAUserInfoTableModel;
import org.seamcat.presentation.systems.cdma.tablemodels.ExternalInteferenceLinkTableModel;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.SimulationElement;

public class InspectSystemDetailsPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Logger LOG = Logger.getLogger(InspectSystemDetailsPanel.class);
    protected DetailedSystemPlot plot;
    protected CDMAPlotModel model;
    protected double clickRadius = 0.11;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected int selectedSector = 0;
    private final CDMAInterfererTableModel interfererTableModel = new CDMAInterfererTableModel();
    private final CDMALinkInfoTableModel linkTableModel = new CDMALinkInfoTableModel();
    private final CDMASystemTableModel systemTableModel = new CDMASystemTableModel();
    private final CDMACellTableModel cellTableModel = new CDMACellTableModel();
    private final CDMAUserInfoTableModel userTableModel = new CDMAUserInfoTableModel();
    private final ExternalInteferenceLinkTableModel externalInteferenceLinkTableModel = new ExternalInteferenceLinkTableModel();
    protected SnapshotVectorsListModel vectorModel;
    private boolean showVectorDetails = true;
    private int eventNumber;
    private JPanel xCollapsiblePane1;
    private JLabel totalUserTextLabel;
    private JLabel totalUsersLabel;
    private JLabel connectedUsersTextLabel;
    private JLabel connectedUsersLabel;
    private JLabel droppedUsersTextLabel;
    private JLabel droppedUsersLabel;
    private JLabel label3;
    private JComboBox systemSelector;
    private JLabel sectorLabel;
    private JRadioButton sector1;
    private JRadioButton sector2;
    private JRadioButton sector3;
    private JLabel selectedLabel;
    private JTabbedPane tabbedPane1;
    private JPanel DetailsTablePanel;
    private JScrollPane scrollPane2;
    private JTable detailsTable;
    private JPanel vectorListPanel;
    private JScrollPane scrollPane1;
    private JList vectorList;
    private JPanel plotSettingsPanel;
    private JLabel label5;
    private JSlider clickRadiusSlider;
    private JLabel zoomFactorLabel;
    private JSlider zoomFactorSlider;

    public InspectSystemDetailsPanel(int eventNumber) {
        this.eventNumber = eventNumber;
        this.initComponents();
    }

    public void addSystemSelectionListener(ActionListener act) {
        this.systemSelector.addActionListener(act);
    }

    public void reset() {
        this.updateSummaryLabels(0, 0, 0, 0);
        this.setDetailedSystemPlot(null);
    }

    public void updateSummaryLabels(int active, int dropped, int conn, int notConn) {
        this.totalUsersLabel.setText(Integer.toString(active));
        this.droppedUsersLabel.setText(Integer.toString(dropped));
        this.connectedUsersLabel.setText(conn + notConn + " [" + conn + " / " + notConn + "]");
    }

    public void setSystemSelectionModel(CDMASystemsComboBoxModel model) {
        this.systemSelector.setModel(model);
    }

    public void setDetailedSystemPlot(DetailedSystemPlot _plot) {
        this.plot = _plot;
        if (this.plot == null) {
            this.model = null;
            this.userTableModel.setUserTerminal(null);
            this.cellTableModel.setModel(null);
            this.cellTableModel.setSelectedCell(null);
            this.interfererTableModel.setSelectedInterferer(null);
        } else {
            this.model = this.plot.getModel();
            this.vectorList.setSelectedValue(null, false);
            this.vectorModel = new SnapshotVectorsListModel(this.model);
            if (this.vectorModel.getSize() > 0) {
                this.vectorList.setModel(this.vectorModel);
                this.showVectorDetails = true;
                this.vectorList.setToolTipText("Double click a vector to see the details");
            } else {
                this.showVectorDetails = false;
                this.vectorList.setToolTipText("Simulated system has no active connections");
            }
            HybridSystemPlugin.SectorSetup layout = this.model.getPlugin().getSectorSetup();
            if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                this.sector1.setText("1. (main beam: 0 deg)");
            } else if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                this.sector1.setText("1. (main beam: 60 deg)");
            }
            if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                this.sector2.setText("2. (main beam: 120 deg)");
            } else if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                this.sector2.setText("2. (main beam: 180 deg)");
            }
            if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                this.sector3.setText("3. (main beam: 240 deg)");
            } else if (layout == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                this.sector3.setText("3. (main beam: 300 deg)");
            }
            int active = this.model.getActiveUsers().size();
            int inActive = this.model.getInactiveUsers().size();
            int dropped = this.model.getDroppedUsers().size();
            this.updateSummaryLabels(active + inActive + dropped, dropped, active, inActive);
            this.systemTableModel.setDmaSystem(this.model);
            this.userTableModel.setUserTerminal(null);
            this.cellTableModel.setModel(this.model);
            this.cellTableModel.setSelectedCell(null);
            this.interfererTableModel.setSelectedInterferer(null);
            this.plot.setSelectedCell(null);
            this.plot.setSelectedUser(null);
            this.plot.setSelectedInterferer(null);
            this.plot.addMouseListener(this);
            this.plot.addMouseMotionListener(this);
            this.plot.addMouseWheelListener(this);
            boolean enable = this.model.getPlugin().getSectorSetup() != HybridSystemPlugin.SectorSetup.SingleSector;
            this.sector1.setEnabled(enable);
            this.sector2.setEnabled(enable);
            this.sector3.setEnabled(enable);
            this.sectorLabel.setEnabled(enable);
        }
    }

    private void zoomFactorSliderStateChanged(ChangeEvent e) {
        this.zoomFactorLabel.setText("Zoom Factor: " + this.zoomFactorSlider.getValue() + "%");
        this.plot.setZoomFactor((double)this.zoomFactorSlider.getValue() / 100.0);
        this.plot.repaint();
    }

    private void clickRadiusSliderStateChanged(ChangeEvent e) {
    }

    private void vectorListMouseClicked(MouseEvent e) {
        if (this.vectorList.getSelectedValue() != null && e.getClickCount() == 2 && e.getButton() == 1 && this.showVectorDetails) {
            String title = (String)this.vectorList.getSelectedValue();
            String unit = this.vectorModel.getUnit(title);
            String label = this.vectorModel.getLabel(title);
            double[] data = this.vectorModel.getVectorData(title);
            new VectorDialog(data, title, unit, label);
        }
    }

    private void sector1ActionPerformed() {
        if (this.sector1.isSelected()) {
            this.setSelectedSector(0);
        }
    }

    private void sector2ActionPerformed() {
        if (this.sector2.isSelected()) {
            this.setSelectedSector(1);
        }
    }

    private void sector3ActionPerformed() {
        if (this.sector3.isSelected()) {
            this.setSelectedSector(2);
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.seamcat.presentation.localization");
        this.xCollapsiblePane1 = new JPanel();
        this.totalUserTextLabel = new JLabel();
        this.totalUsersLabel = new JLabel();
        this.connectedUsersTextLabel = new JLabel();
        this.connectedUsersLabel = new JLabel();
        this.droppedUsersTextLabel = new JLabel();
        this.droppedUsersLabel = new JLabel();
        this.label3 = new JLabel();
        this.systemSelector = new JComboBox();
        this.sectorLabel = new JLabel();
        this.sector1 = new JRadioButton();
        this.sector2 = new JRadioButton();
        this.sector3 = new JRadioButton();
        this.selectedLabel = new JLabel();
        this.tabbedPane1 = new JTabbedPane();
        this.DetailsTablePanel = new JPanel();
        this.scrollPane2 = new JScrollPane();
        this.detailsTable = new JTable();
        this.vectorListPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.vectorList = new JList();
        this.plotSettingsPanel = new JPanel();
        this.label5 = new JLabel();
        this.clickRadiusSlider = new JSlider();
        this.zoomFactorLabel = new JLabel();
        this.zoomFactorSlider = new JSlider();
        CellConstraints cc = new CellConstraints();
        this.setLayout(new FormLayout("left:121dlu, $lcgap, 49dlu:grow", "top:144dlu, $lgap, top:14dlu, $lgap, top:default:grow"));
        this.xCollapsiblePane1.setLayout(new FormLayout("left:55dlu, $lcgap, left:57dlu, $lcgap, 54dlu:grow", "8*(default, $lgap), default"));
        this.totalUserTextLabel.setText(bundle.getString("CdmaDetailsPanel.totalUserTextLabel.text"));
        this.xCollapsiblePane1.add((Component)this.totalUserTextLabel, cc.xywh(1, 1, 3, 1));
        this.totalUsersLabel.setText(bundle.getString("CdmaDetailsPanel.totalUsersLabel.text"));
        this.xCollapsiblePane1.add((Component)this.totalUsersLabel, cc.xy(5, 1));
        this.connectedUsersTextLabel.setText(bundle.getString("CdmaDetailsPanel.connectedUsersTextLabel.text"));
        this.xCollapsiblePane1.add((Component)this.connectedUsersTextLabel, cc.xywh(1, 3, 4, 1));
        this.connectedUsersLabel.setText(bundle.getString("CdmaDetailsPanel.connectedUsersLabel.text"));
        this.xCollapsiblePane1.add((Component)this.connectedUsersLabel, cc.xy(5, 3));
        this.droppedUsersTextLabel.setText(bundle.getString("CdmaDetailsPanel.droppedUsersTextLabel.text"));
        this.xCollapsiblePane1.add((Component)this.droppedUsersTextLabel, cc.xywh(1, 5, 3, 1));
        this.droppedUsersLabel.setText(bundle.getString("CdmaDetailsPanel.droppedUsersLabel.text"));
        this.xCollapsiblePane1.add((Component)this.droppedUsersLabel, cc.xy(5, 5));
        this.label3.setText(bundle.getString("CdmaDetailsPanel.label3.text"));
        this.xCollapsiblePane1.add((Component)this.label3, cc.xywh(1, 7, 2, 1));
        this.xCollapsiblePane1.add((Component)this.systemSelector, cc.xywh(3, 7, 3, 1));
        this.sectorLabel.setText(bundle.getString("CdmaDetailsPanel.sectorLabel.text"));
        this.xCollapsiblePane1.add((Component)this.sectorLabel, cc.xy(1, 9));
        this.sector1.setText(bundle.getString("CdmaDetailsPanel.sector1.text"));
        this.sector1.setSelected(true);
        this.sector1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectSystemDetailsPanel.this.sector1ActionPerformed();
            }
        });
        this.xCollapsiblePane1.add((Component)this.sector1, cc.xywh(3, 9, 3, 1));
        this.sector2.setText(bundle.getString("CdmaDetailsPanel.sector2.text"));
        this.sector2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectSystemDetailsPanel.this.sector2ActionPerformed();
            }
        });
        this.xCollapsiblePane1.add((Component)this.sector2, cc.xywh(3, 11, 3, 1));
        this.sector3.setText(bundle.getString("CdmaDetailsPanel.sector3.text"));
        this.sector3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectSystemDetailsPanel.this.sector3ActionPerformed();
            }
        });
        this.xCollapsiblePane1.add((Component)this.sector3, cc.xywh(3, 13, 3, 1));
        this.add((Component)new ScrollingBorderPanel(this.xCollapsiblePane1, bundle.getString("CdmaDetailsPanel_SUMMARY") + " " + this.eventNumber), cc.xywh(1, 1, 3, 4));
        this.add((Component)this.selectedLabel, cc.xy(1, 3));
        this.DetailsTablePanel.setLayout(new FormLayout("default", "default"));
        this.scrollPane2.setViewportView(this.detailsTable);
        this.DetailsTablePanel.add((Component)this.scrollPane2, cc.xy(1, 1));
        this.tabbedPane1.addTab(bundle.getString("CdmaDetailsPanel.DetailsTablePanel.tab.title"), this.DetailsTablePanel);
        this.vectorListPanel.setLayout(new FormLayout("106dlu:grow", "fill:default:grow"));
        this.vectorList.setSelectionMode(0);
        this.vectorList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InspectSystemDetailsPanel.this.vectorListMouseClicked(e);
            }
        });
        this.scrollPane1.setViewportView(this.vectorList);
        this.vectorListPanel.add((Component)this.scrollPane1, cc.xy(1, 1));
        this.tabbedPane1.addTab(bundle.getString("CdmaDetailsPanel.vectorListPanel.tab.title"), this.vectorListPanel);
        this.plotSettingsPanel.setLayout(new FormLayout("default, $lcgap, default", "2*(default, $lgap), default"));
        this.label5.setText(bundle.getString("CdmaDetailsPanel.label5.text"));
        this.plotSettingsPanel.add((Component)this.label5, cc.xy(1, 1));
        this.clickRadiusSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InspectSystemDetailsPanel.this.clickRadiusSliderStateChanged(e);
            }
        });
        this.plotSettingsPanel.add((Component)this.clickRadiusSlider, cc.xy(3, 1));
        this.zoomFactorLabel.setText(bundle.getString("CdmaDetailsPanel.zoomFactorLabel.text"));
        this.plotSettingsPanel.add((Component)this.zoomFactorLabel, cc.xy(1, 3));
        this.zoomFactorSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InspectSystemDetailsPanel.this.zoomFactorSliderStateChanged(e);
            }
        });
        this.plotSettingsPanel.add((Component)this.zoomFactorSlider, cc.xy(3, 3));
        this.tabbedPane1.addTab(bundle.getString("CdmaDetailsPanel.plotSettingsPanel.tab.title"), this.plotSettingsPanel);
        this.add((Component)new BorderPanel(this.tabbedPane1, bundle.getString("CdmaDetailsPanel.tabbedPane1.border")), cc.xywh(1, 5, 3, 1));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.sector1);
        buttonGroup1.add(this.sector2);
        buttonGroup1.add(this.sector3);
    }

    private boolean isClickHit(double x, double y, SimulationElement u) {
        return this.isClickHit(x, y, u.getPosition().getX(), u.getPosition().getY());
    }

    private boolean isClickHit(double x1, double y1, double x2, double y2) {
        return Math.abs(x2 - x1) < this.clickRadius && Math.abs(y2 - y1) < this.clickRadius;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            if (e.getClickCount() == 2) {
                this.zoomFactorSlider.setValue(100);
                this.zoomFactorLabel.setText("Zoom Factor: 100%");
                this.plot.resetView();
            }
            return;
        }
        if (this.model == null) {
            return;
        }
        this.clickRadius = (double)this.clickRadiusSlider.getValue() / 1000.0;
        List<AbstractDmaMobile> users = this.model.getActiveUsers();
        double x = ((double)e.getX() - this.plot.getTranslateX() - (double)this.plot.getFocusShiftX()) / this.plot.getScaleFactor();
        double y = -(((double)e.getY() - this.plot.getTranslateY() - (double)this.plot.getFocusShiftY()) / this.plot.getScaleFactor());
        if (e.isControlDown()) {
            if (this.plot.getSelectedUser() != null) {
                Object victim;
                AbstractDmaMobile user = this.plot.getSelectedUser();
                if (this.plot.isPlotExternalInterferers() && (victim = user.getVictim()) != null) {
                    for (Interferer ext : this.model.eventResult.getExternalInterferers((Victim)victim)) {
                        Point2D position = ext.getLinkResult().txAntenna().getPosition();
                        if (!this.isClickHit(x, y, position.getX(), position.getY())) continue;
                        this.externalInteferenceLinkTableModel.setLink(ext);
                        this.detailsTable.setModel(this.externalInteferenceLinkTableModel);
                        this.selectedLabel.setText("External Interference Link");
                        this.plot.setSelectedInterferer(ext);
                        this.plot.setSelectedCell(null);
                        this.plot.setSelectedInterferer(null);
                        this.plot.repaint();
                        return;
                    }
                }
                for (AbstractDmaLink link : user.getActiveList()) {
                    if (!this.isClickHit(x, y, link.getBaseStation())) continue;
                    this.linkTableModel.setCDMALink(link);
                    this.detailsTable.setModel(this.linkTableModel);
                    this.selectedLabel.setText("Active Link");
                    this.plot.setSelectedLink(link);
                    this.plot.setSelectedUser(link.getUserTerminal());
                    this.plot.setSelectedCell(null);
                    this.plot.setSelectedInterferer(null);
                    this.plot.repaint();
                    return;
                }
                for (AbstractDmaLink link : user.getAllLinks()) {
                    if (user.getActiveList().contains(link) || !this.isClickHit(x, y, link.getBaseStation())) continue;
                    this.linkTableModel.setCDMALink(link);
                    this.detailsTable.setModel(this.linkTableModel);
                    this.selectedLabel.setText("Inactive Link");
                    this.plot.setSelectedLink(link);
                    this.plot.setSelectedUser(link.getUserTerminal());
                    this.plot.setSelectedCell(null);
                    this.plot.setSelectedInterferer(null);
                    this.plot.repaint();
                    return;
                }
            }
            if (this.plot.getSelectedCell() != null) {
                AbstractDmaBaseStation cell = this.plot.getSelectedCell();
                for (AbstractDmaLink link : cell.getOldTypeActiveConnections()) {
                    if (!this.isClickHit(x, y, link.getUserTerminal())) continue;
                    this.linkTableModel.setCDMALink(link);
                    this.detailsTable.setModel(this.linkTableModel);
                    this.selectedLabel.setText("Active Link");
                    this.plot.setSelectedLink(link);
                    this.plot.setSelectedUser(link.getUserTerminal());
                    this.plot.setSelectedInterferer(null);
                    this.plot.repaint();
                    return;
                }
                for (AbstractDmaLink link : cell.getDroppedUsers()) {
                    if (!this.isClickHit(x, y, link.getBaseStation())) continue;
                    this.linkTableModel.setCDMALink(link);
                    this.detailsTable.setModel(this.linkTableModel);
                    this.selectedLabel.setText("Link to dropped user");
                    this.plot.setSelectedLink(link);
                    this.plot.setSelectedUser(link.getUserTerminal());
                    this.plot.setSelectedInterferer(null);
                    this.plot.repaint();
                    return;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clicked button " + e.getButton() + ": (" + x + ", " + y + ")");
        }
        if (this.plot.isPlotUsers()) {
            int i;
            int stop = users.size();
            for (i = 0; i < stop; ++i) {
                AbstractDmaMobile u = users.get(i);
                if (!this.isClickHit(x, y, u)) continue;
                this.userTableModel.setUserTerminal(u);
                this.detailsTable.setModel(this.userTableModel);
                this.selectedLabel.setText("Connected - Voice Active User");
                this.plot.setSelectedUser(u);
                this.plot.setSelectedCell(null);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
            users = this.model.getInactiveUsers();
            stop = users.size();
            for (i = 0; i < stop; ++i) {
                AbstractDmaMobile u = users.get(i);
                if (!this.isClickHit(x, y, u)) continue;
                this.userTableModel.setUserTerminal(u);
                this.detailsTable.setModel(this.userTableModel);
                this.selectedLabel.setText("Connected - Inactive User");
                this.plot.setSelectedUser(u);
                this.plot.setSelectedCell(null);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
        }
        if (this.plot.isPlotDroppedUsers()) {
            for (AbstractDmaMobile u : this.model.getDroppedUsers()) {
                if (!this.isClickHit(x, y, u)) continue;
                this.userTableModel.setUserTerminal(u);
                this.detailsTable.setModel(this.userTableModel);
                this.selectedLabel.setText("Dropped User");
                this.plot.setSelectedUser(u);
                this.plot.setSelectedCell(null);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
        }
        if (this.plot.isPlotCellCenter()) {
            AbstractDmaBaseStation[][] cells = this.model.getBaseStations();
            int stop = cells.length;
            for (int i = 0; i < stop; ++i) {
                AbstractDmaBaseStation c = cells[i][this.selectedSector];
                if (!(Math.abs(c.getPosition().getX() - x) < this.clickRadius) || !(Math.abs(c.getPosition().getY() - y) < this.clickRadius)) continue;
                this.cellTableModel.setSelectedCell(c);
                this.detailsTable.setModel(this.cellTableModel);
                this.selectedLabel.setText("BaseStation #" + c.getCellid());
                this.plot.setSelectedCell(c);
                this.plot.setSelectedUser(null);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
        }
        if (this.plot.isPlotExternalInterferers()) {
            for (Interferer interferer : this.model.getExternalInterferers()) {
                Point2D position = interferer.getLinkResult().txAntenna().getPosition();
                if (!(Math.abs(position.getX() - x) < this.clickRadius) || !(Math.abs(position.getY() - y) < this.clickRadius)) continue;
                this.interfererTableModel.setSelectedInterferer(interferer);
                this.detailsTable.setModel(this.interfererTableModel);
                this.selectedLabel.setText("CDMA Interferer");
                this.plot.setSelectedCell(null);
                this.plot.setSelectedUser(null);
                this.plot.setSelectedInterferer(interferer);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
        }
        if (this.plot.getSelectedCell() != null) {
            List<AbstractDmaLink> cellUsers = this.plot.getSelectedCell().getOldTypeActiveConnections();
            for (AbstractDmaLink link : cellUsers) {
                AbstractDmaMobile u = link.getUserTerminal();
                if (!this.isClickHit(x, y, u)) continue;
                this.userTableModel.setUserTerminal(u);
                this.detailsTable.setModel(this.userTableModel);
                this.selectedLabel.setText("Connected - Voice Active User");
                this.plot.setSelectedUser(u);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
            cellUsers = this.plot.getSelectedCell().getDroppedUsers();
            for (AbstractDmaLink link : cellUsers) {
                AbstractDmaMobile u = link.getUserTerminal();
                if (!this.isClickHit(x, y, u)) continue;
                this.userTableModel.setUserTerminal(u);
                this.detailsTable.setModel(this.userTableModel);
                this.selectedLabel.setText("Dropped User");
                this.plot.setSelectedUser(u);
                this.plot.setSelectedInterferer(null);
                this.plot.setSelectedLink(null);
                this.plot.repaint();
                return;
            }
        }
        this.selectedLabel.setText("Click on system element to view details");
        this.plot.setSelectedCell(null);
        this.plot.setSelectedUser(null);
        this.plot.setSelectedInterferer(null);
        this.plot.setSelectedLink(null);
        this.detailsTable.setModel(this.systemTableModel);
        this.plot.repaint();
        if (this.detailsTable.getModel() == this.cellTableModel) {
            this.cellTableModel.setSelectedCell(null);
        } else if (this.detailsTable.getModel() == this.userTableModel) {
            this.userTableModel.setUserTerminal(null);
        } else if (this.detailsTable.getModel() == this.interfererTableModel) {
            this.interfererTableModel.setSelectedInterferer(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - this.offsetX;
        int y = e.getY() - this.offsetY;
        if (this.plot != null) {
            this.plot.adjustFocusShiftX(x);
            this.plot.adjustFocusShiftY(y);
            this.plot.repaint();
            this.offsetX = e.getX();
            this.offsetY = e.getY();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.offsetX = e.getX();
        this.offsetY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            this.plot.adjustZoom(e.getUnitsToScroll());
            this.zoomFactorSlider.setValue((int)(this.plot.getZoomFactor() * 100.0));
            this.zoomFactorLabel.setText("Zoom Factor: " + this.plot.getZoomFactor() * 100.0 + "%");
            this.plot.repaint();
        }
    }

    public void setSelectedSector(int selectedSector) {
        this.selectedSector = selectedSector;
        if (this.plot.getSelectedCell() != null) {
            AbstractDmaBaseStation c = this.model.getBaseStations()[this.cellTableModel.getSelectedCell().getCellLocationId()][selectedSector];
            this.cellTableModel.setSelectedCell(c);
            this.detailsTable.setModel(this.cellTableModel);
            this.selectedLabel.setText("BaseStation #" + c.getCellid());
            this.plot.setSelectedCell(c);
            this.plot.setSelectedUser(null);
            this.plot.setSelectedInterferer(null);
            this.plot.repaint();
        }
    }
}

