/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class DetailedSystemPlot
extends JComponent {
    private static String[][] fixedLocationsStrings;
    private static final Logger LOG;
    protected Animator animator;
    private int focusShiftX = 0;
    private int focusShiftY = 0;
    private Color patternColor = new Color(240, 193, 193);
    private boolean plotActivelistSize = false;
    private boolean plotAntennaPattern = false;
    private boolean plotCellBackground = false;
    private boolean plotCellCenter = true;
    private boolean plotCellid = false;
    private boolean plotConnectionLines = false;
    private boolean plotDroppedUsers = true;
    private boolean plotExternalInterferers = true;
    private boolean plotFixedLocations = false;
    private boolean plotHelp = true;
    private boolean plotLegend = true;
    private boolean plotScale = true;
    private boolean plotTxStats = false;
    private boolean plotUsers = false;
    protected PropertySetter prop = new PropertySetter((Object)this, "selectedItemZoomFactor", 0, 4);
    private double scaleFactor;
    private AbstractDmaBaseStation selectedCell;
    private Interferer selectedInterferer;
    private int selectedItemZoomFactor = 0;
    private AbstractDmaLink selectedLink;
    private AbstractDmaMobile selectedUser;
    private String tooltip;
    private Point tooltipDestination;
    private double translateX;
    private double translateY;
    private double transX;
    private double transY;
    private double zoomFactor = 1.0;
    private CDMAPlotModel model;

    public void adjustFocusShiftX(int _focusShiftX) {
        this.focusShiftX += _focusShiftX;
    }

    public void adjustFocusShiftY(int _focusShiftY) {
        this.focusShiftY += _focusShiftY;
    }

    public void adjustZoom(double adjustment) {
        double adjust = adjustment / 100.0;
        this.zoomFactor += adjust;
        if (this.zoomFactor < 0.0) {
            this.zoomFactor = 0.0;
        }
    }

    protected void drawAnimatedOval(Graphics2D gr, Object elementBeingDrawed, Object selectedElement, double x, double y, int diameter) {
        if (elementBeingDrawed == selectedElement) {
            gr.fillOval((int)x - (diameter / 2 + this.selectedItemZoomFactor), (int)y - (diameter / 2 + this.selectedItemZoomFactor), diameter + this.selectedItemZoomFactor * 2, diameter + this.selectedItemZoomFactor * 2);
        } else {
            gr.fillOval((int)x - diameter / 2, (int)y - diameter / 2, diameter, 6);
        }
    }

    public CDMAPlotModel getModel() {
        return this.model;
    }

    public int getFocusShiftX() {
        return this.focusShiftX;
    }

    public int getFocusShiftY() {
        return this.focusShiftY;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public AbstractDmaBaseStation getSelectedCell() {
        return this.selectedCell;
    }

    public int getSelectedItemZoomFactor() {
        return this.selectedItemZoomFactor;
    }

    public AbstractDmaLink getSelectedLink() {
        return this.selectedLink;
    }

    public AbstractDmaMobile getSelectedUser() {
        return this.selectedUser;
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void hideToolTip() {
        this.tooltip = null;
    }

    public boolean isPlotAntennaPattern() {
        return this.plotAntennaPattern;
    }

    public boolean isPlotCellBackground() {
        return this.plotCellBackground;
    }

    public boolean isPlotCellCenter() {
        return this.plotCellCenter;
    }

    public boolean isPlotCellid() {
        return this.plotCellid;
    }

    public boolean isPlotConnectionLines() {
        return this.plotConnectionLines;
    }

    public boolean isPlotDroppedUsers() {
        return this.plotDroppedUsers;
    }

    public boolean isPlotExternalInterferers() {
        return this.plotExternalInterferers;
    }

    public boolean isPlotFixedLocations() {
        return this.plotFixedLocations;
    }

    public boolean isPlotHelp() {
        return this.plotHelp;
    }

    public boolean isPlotLegend() {
        return this.plotLegend;
    }

    public boolean isPlotScale() {
        return this.plotScale;
    }

    public boolean isPlotSizeOfActiveList() {
        return this.plotActivelistSize;
    }

    public boolean isPlotTxStats() {
        return this.plotTxStats;
    }

    public boolean isPlotUsers() {
        return this.plotUsers;
    }

    public void moveToolTipToRelativeDestination(Point destination) {
        this.tooltipDestination = destination;
    }

    private Point2D position(Interferer interferer) {
        return interferer.getLinkResult().txAntenna().getPosition();
    }

    @Override
    public void paintComponent(Graphics _gr) {
        super.paintComponent(_gr);
        Graphics2D gr = (Graphics2D)_gr;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setBackground(Color.WHITE);
        Dimension dim = this.getSize();
        if (this.model != null) {
            int j;
            int[] yPoints;
            int[] xPoints;
            double cellY;
            double cellX;
            HybridSystemPlugin.TierSetup setup = this.model.getPlugin().getTierSetup();
            int tiers = setup == HybridSystemPlugin.TierSetup.SingleCell ? 0 : (setup == HybridSystemPlugin.TierSetup.OneTier ? 1 : 2);
            double intercellDistance = this.model.intercellDistance;
            double scaleFactorH = dim.getHeight() / ((double)(2 * tiers + 2) * intercellDistance);
            double scaleFactorW = dim.getWidth() / ((double)(2 * tiers + 2) * intercellDistance);
            this.scaleFactor = Math.min(scaleFactorH, scaleFactorW);
            this.scaleFactor *= this.zoomFactor;
            gr.clearRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
            if (this.plotScale) {
                gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20);
                gr.drawLine((int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 - 5, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 + 5);
                gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20 - 5, (int)dim.getWidth() / 20, (int)dim.getHeight() / 20 + 5);
                gr.drawString("D = " + Mathematics.round(intercellDistance) + " km", (int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0) + 20);
            }
            if (this.plotLegend) {
                int line = 1;
                gr.setColor(Color.RED);
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(line * gr.getFont().getSize()) * 1.5), 4, 4);
                gr.drawString(" = voice active user", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
                if (this.model.getPlugin() instanceof HybridCDMADownLinkPlugin || this.model.getPlugin() instanceof HybridCDMAUpLinkPlugin) {
                    gr.setColor(Color.ORANGE);
                    gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
                    gr.drawString(" = voice active user in softhandover", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
                }
                gr.setColor(Color.GRAY);
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
                gr.drawString(" = dropped user", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
                gr.setColor(Color.MAGENTA);
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
                gr.drawString(" = external interferer", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
            }
            if (this.plotHelp) {
                gr.setColor(Color.BLUE);
                boolean textOffset = false;
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)gr.getFont().getSize() * 1.5)), 4, 4);
                gr.drawString("Click on element to see details", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(5 * gr.getFont().getSize()) * 1.5)));
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(2 * gr.getFont().getSize()) * 1.5)), 4, 4);
                gr.drawString("Zoom using mousewheel or slider", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(4 * gr.getFont().getSize()) * 1.5)));
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(3 * gr.getFont().getSize()) * 1.5)), 4, 4);
                gr.drawString("Grab and drag to recenter", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(3 * gr.getFont().getSize()) * 1.5)));
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(4 * gr.getFont().getSize()) * 1.5)), 4, 4);
                gr.drawString("Double Right click to reset to 100% zoom", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(2 * gr.getFont().getSize()) * 1.5)));
                gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(5 * gr.getFont().getSize()) * 1.5)), 4, 4);
                gr.drawString("Select user and Ctrl-click any BS to see link data", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)gr.getFont().getSize() * 1.5)));
            }
            double radius = this.scaleFactor * this.model.getPlugin().getCellRadius();
            Point2D location = this.model.getLocation();
            double lx = location.getX();
            double ly = location.getY();
            this.transX = dim.getWidth() / 2.0 - lx * this.scaleFactor;
            this.transY = dim.getHeight() / 2.0 + ly * this.scaleFactor;
            this.translateX = this.transX;
            this.translateY = this.transY;
            gr.translate(this.translateX, this.translateY);
            AbstractDmaBaseStation[][] cells = this.model.getBaseStations();
            double angle = 60.0;
            List<AbstractDmaMobile> users = this.model.getActiveUsers();
            if (this.model.getPlugin().getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                cellX = this.model.getReferenceCell().getPosition().getX();
                cellY = -this.model.getReferenceCell().getPosition().getY();
                cellX *= this.scaleFactor;
                cellY *= this.scaleFactor;
                cellX += (double)this.focusShiftX;
                cellY += (double)this.focusShiftY;
                xPoints = new int[6];
                yPoints = new int[6];
                for (j = 0; j < 6; ++j) {
                    xPoints[j] = (int)(Mathematics.cosD((double)j * angle) * radius + cellX);
                    yPoints[j] = (int)(Mathematics.sinD((double)j * angle) * radius + cellY);
                }
                gr.setColor(Color.YELLOW);
                int k = this.model.getReferenceCell().getSectorId() - 1;
                int[] xP = new int[4];
                int[] yP = new int[4];
                xP[0] = (int)cellX;
                yP[0] = (int)cellY;
                switch (k) {
                    case 2: {
                        int zz;
                        for (zz = 0; zz < 3; ++zz) {
                            xP[zz + 1] = xPoints[zz];
                            yP[zz + 1] = yPoints[zz];
                        }
                        break;
                    }
                    case 1: {
                        int zz;
                        for (zz = 2; zz < 5; ++zz) {
                            xP[zz - 1] = xPoints[zz];
                            yP[zz - 1] = yPoints[zz];
                        }
                        break;
                    }
                    case 0: {
                        int zz;
                        for (zz = 4; zz < 6; ++zz) {
                            xP[zz - 3] = xPoints[zz];
                            yP[zz - 3] = yPoints[zz];
                        }
                        xP[3] = xPoints[0];
                        yP[3] = yPoints[0];
                    }
                }
                gr.fillPolygon(xP, yP, xP.length);
            } else if (this.model.getPlugin().getSectorSetup() == HybridSystemPlugin.SectorSetup.SingleSector) {
                cellX = this.model.getReferenceCell().getPosition().getX();
                cellY = -this.model.getReferenceCell().getPosition().getY();
                cellX *= this.scaleFactor;
                cellY *= this.scaleFactor;
                cellX += (double)this.focusShiftX;
                cellY += (double)this.focusShiftY;
                xPoints = new int[6];
                yPoints = new int[6];
                for (j = 0; j < 6; ++j) {
                    xPoints[j] = (int)(Mathematics.cosD((double)j * angle) * radius + cellX);
                    yPoints[j] = (int)(Mathematics.sinD((double)j * angle) * radius + cellY);
                }
                gr.setColor(Color.YELLOW);
                gr.fillPolygon(xPoints, yPoints, xPoints.length);
            } else {
                cellX = this.model.getReferenceCell().getPosition().getX();
                cellY = -this.model.getReferenceCell().getPosition().getY();
                cellX *= this.scaleFactor;
                cellY *= this.scaleFactor;
                cellX += (double)this.focusShiftX;
                cellY += (double)this.focusShiftY;
                xPoints = new int[6];
                yPoints = new int[6];
                int sector = this.model.getReferenceCell().getSectorId() - 1;
                double[] shiftX = new double[]{radius, -radius * Mathematics.cosD(60.0), -radius * Mathematics.cosD(60.0)};
                double[] shiftY = new double[]{0.0, -radius * Mathematics.sinD(60.0), radius * Mathematics.sinD(60.0)};
                for (int j2 = 0; j2 < 6; ++j2) {
                    xPoints[j2] = (int)(Mathematics.cosD((double)j2 * angle) * radius + cellX + shiftX[sector]);
                    yPoints[j2] = (int)(Mathematics.sinD((double)j2 * angle) * radius + cellY + shiftY[sector]);
                }
                gr.setColor(Color.YELLOW);
                gr.fillPolygon(xPoints, yPoints, xPoints.length);
            }
            if (this.selectedCell != null) {
                cellX = this.selectedCell.getPosition().getX();
                cellY = -this.selectedCell.getPosition().getY();
                cellX *= this.scaleFactor;
                cellY *= this.scaleFactor;
                cellX += (double)this.focusShiftX;
                cellY += (double)this.focusShiftY;
                if (this.plotAntennaPattern) {
                    this.drawConf(true, gr, this.selectedCell.getAntennaGain(), radius, cellX, cellY);
                }
            }
            if (this.plotExternalInterferers) {
                List<Interferer> ext = this.model.getExternalInterferers();
                gr.setColor(Color.MAGENTA);
                int stop = ext.size();
                for (int i = 0; i < stop; ++i) {
                    double cY;
                    double cX;
                    Interferer e = ext.get(i);
                    Point2D position = this.position(e);
                    double extX = position.getX();
                    double extY = -position.getY();
                    extX *= this.scaleFactor;
                    extY *= this.scaleFactor;
                    this.drawAnimatedOval(gr, e, this.selectedInterferer, extX += (double)this.focusShiftX, extY += (double)this.focusShiftY, 6);
                    if (e != this.selectedInterferer) continue;
                    if (this.plotAntennaPattern) {
                        this.drawConf(false, gr, e.getAntennaGain(), radius, extX, extY);
                    }
                    if (this.selectedUser != null && !this.model.isUplink) {
                        gr.setColor(Color.RED);
                        double userX = this.selectedUser.getPosition().getX();
                        double userY = -this.selectedUser.getPosition().getY();
                        userX *= this.scaleFactor;
                        userY *= this.scaleFactor;
                        cX = position.getX();
                        cY = -position.getY();
                        cX *= this.scaleFactor;
                        cY *= this.scaleFactor;
                        gr.drawLine((int)(userX += (double)this.focusShiftX), (int)(userY += (double)this.focusShiftY), (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
                        if (this.plotAntennaPattern) {
                            this.drawConf(false, gr, Factory.antennaGainFactory().getPeakGainAntenna(this.selectedUser.getAntennaGain()), radius, userX, userY);
                        }
                    } else if (this.model.isUplink && this.selectedCell != null) {
                        gr.setColor(Color.RED);
                        double cellX2 = this.selectedCell.getPosition().getX();
                        double cellY2 = -this.selectedCell.getPosition().getY();
                        cellX2 *= this.scaleFactor;
                        cellY2 *= this.scaleFactor;
                        cX = position.getX();
                        cY = -position.getY();
                        cX *= this.scaleFactor;
                        cY *= this.scaleFactor;
                        gr.drawLine((int)(cellX2 += (double)this.focusShiftX), (int)(cellY2 += (double)this.focusShiftY), (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
                    }
                    gr.setColor(Color.MAGENTA);
                }
            }
            for (int i = 0; i < users.size() && this.plotUsers; ++i) {
                AbstractDmaMobile user = users.get(i);
                if (user == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("User is null");
                    continue;
                }
                if (user.isInSoftHandover() && user.getSystem() instanceof CDMASystem) {
                    gr.setColor(Color.ORANGE);
                } else {
                    gr.setColor(Color.RED);
                }
                double userX = user.getPosition().getX();
                double userY = -user.getPosition().getY();
                userX *= this.scaleFactor;
                userY *= this.scaleFactor;
                gr.fillOval((int)(userX += (double)this.focusShiftX) - 2, (int)(userY += (double)this.focusShiftY) - 2, 4, 4);
                if (this.plotActivelistSize) {
                    gr.drawString(Integer.toString(user.getActiveList().size()), (int)userX + 6, (int)userY);
                }
                for (j = 0; j < user.getActiveList().size() && this.plotConnectionLines; ++j) {
                    gr.setColor(Color.LIGHT_GRAY);
                    if (user.isInSoftHandover() && this.model.isUplink && (user.getActiveList().get(j) == user.getServingLink() || user.isInSofterHandover())) {
                        gr.setColor(Color.DARK_GRAY);
                    }
                    double cellX3 = user.getActiveList().get(j).getBaseStation().getPosition().getX();
                    double cellY3 = -user.getActiveList().get(j).getBaseStation().getPosition().getY();
                    cellX3 *= this.scaleFactor;
                    cellY3 *= this.scaleFactor;
                    gr.drawLine((int)userX, (int)userY, (int)(cellX3 += (double)this.focusShiftX), (int)(cellY3 += (double)this.focusShiftY));
                }
            }
            if (this.selectedUser != null) {
                double userX = this.selectedUser.getPosition().getX();
                double userY = -this.selectedUser.getPosition().getY();
                userX *= this.scaleFactor;
                userY *= this.scaleFactor;
                userX += (double)this.focusShiftX;
                userY += (double)this.focusShiftY;
                if (this.plotAntennaPattern) {
                    this.drawConf(false, gr, Factory.antennaGainFactory().getPeakGainAntenna(this.selectedUser.getAntennaGain()), radius, userX, userY);
                }
                gr.setColor(Color.BLACK);
                gr.drawString("#" + this.selectedUser.getUserId() + " (" + this.selectedUser.getActiveList().size() + ")", (int)userX + 6, (int)userY);
                gr.setColor(Color.BLUE);
                this.drawAnimatedOval(gr, this.selectedUser, this.selectedUser, userX, userY, 4);
                gr.setColor(Color.LIGHT_GRAY);
                for (int j3 = 0; j3 < this.selectedUser.getActiveList().size(); ++j3) {
                    gr.setColor(Color.LIGHT_GRAY);
                    if (this.selectedUser.getActiveList().get(j3) == this.selectedUser.getServingLink()) {
                        gr.setColor(Color.DARK_GRAY);
                    }
                    double cellX4 = this.selectedUser.getActiveList().get(j3).getBaseStation().getPosition().getX();
                    double cellY4 = -this.selectedUser.getActiveList().get(j3).getBaseStation().getPosition().getY();
                    cellX4 *= this.scaleFactor;
                    cellY4 *= this.scaleFactor;
                    gr.drawLine((int)userX, (int)userY, (int)(cellX4 += (double)this.focusShiftX), (int)(cellY4 += (double)this.focusShiftY));
                }
                if (this.isPlotExternalInterferers() && this.selectedUser instanceof DownlinkOfdmaMobile) {
                    gr.setColor(Color.RED);
                    Victim victim = this.selectedUser.getVictim();
                    if (victim != null) {
                        for (Interferer ext : this.model.eventResult.getExternalInterferers(victim)) {
                            Point2D position = this.position(ext);
                            double cX = position.getX();
                            double cY = -position.getY();
                            cX *= this.scaleFactor;
                            cY *= this.scaleFactor;
                            gr.drawLine((int)userX, (int)userY, (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
                        }
                    }
                }
            }
            if (this.selectedCell != null) {
                List<AbstractDmaLink> connections = this.selectedCell.getOldTypeActiveConnections();
                double cellX5 = this.selectedCell.getPosition().getX();
                double cellY5 = -this.selectedCell.getPosition().getY();
                cellX5 *= this.scaleFactor;
                cellY5 *= this.scaleFactor;
                cellX5 += (double)this.focusShiftX;
                cellY5 += (double)this.focusShiftY;
                gr.setColor(Color.BLACK);
                for (int i = 0; i < connections.size(); ++i) {
                    AbstractDmaMobile user = connections.get(i).getUserTerminal();
                    if (user == null) continue;
                    if (user == this.selectedUser) {
                        gr.setColor(Color.BLUE);
                    } else {
                        gr.setColor(Color.RED);
                    }
                    double userX = user.getPosition().getX();
                    double userY = -user.getPosition().getY();
                    userX *= this.scaleFactor;
                    userY *= this.scaleFactor;
                    gr.fillOval((int)(userX += (double)this.focusShiftX) - 2, (int)(userY += (double)this.focusShiftY) - 2, 4, 4);
                    if (this.plotActivelistSize) {
                        gr.drawString(Integer.toString(user.getActiveList().size()), (int)userX + 6, (int)userY);
                    }
                    gr.setColor(Color.LIGHT_GRAY);
                    for (int j4 = 0; j4 < user.getActiveList().size(); ++j4) {
                        gr.setColor(Color.LIGHT_GRAY);
                        if (user.isInSoftHandover() && this.model.isUplink && (user.getActiveList().get(j4) == user.getServingLink() || user.isInSofterHandover())) {
                            gr.setColor(Color.DARK_GRAY);
                        }
                        double cX = user.getActiveList().get(j4).getBaseStation().getPosition().getX();
                        double cY = -user.getActiveList().get(j4).getBaseStation().getPosition().getY();
                        cX *= this.scaleFactor;
                        cY *= this.scaleFactor;
                        gr.drawLine((int)userX, (int)userY, (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
                    }
                    gr.drawLine((int)userX, (int)userY, (int)cellX5, (int)cellY5);
                }
                for (AbstractDmaLink user : this.selectedCell.getDroppedUsers()) {
                    gr.setColor(Color.GRAY);
                    double userX = user.getUserTerminal().getPosition().getX();
                    double userY = -user.getUserTerminal().getPosition().getY();
                    userX *= this.scaleFactor;
                    userY *= this.scaleFactor;
                    userX += (double)this.focusShiftX;
                    userY += (double)this.focusShiftY;
                    if (this.plotActivelistSize) {
                        gr.drawString(Integer.toString(user.getUserTerminal().getActiveList().size()), (int)userX + 6, (int)userY);
                    }
                    gr.fillOval((int)userX - 2, (int)userY - 2, 4, 4);
                }
            }
            for (int i = 0; i < cells.length && this.plotDroppedUsers; ++i) {
                for (int j5 = 0; j5 < cells[i].length; ++j5) {
                    for (AbstractDmaLink user : cells[i][j5].getDroppedUsers()) {
                        if (user.getUserTerminal().getDropReason() != null && user.getUserTerminal().getDropReason().equals("Inside Power Balance")) {
                            gr.setColor(Color.LIGHT_GRAY);
                        } else {
                            gr.setColor(Color.GRAY);
                        }
                        double userX = user.getUserTerminal().getPosition().getX();
                        double userY = -user.getUserTerminal().getPosition().getY();
                        userX *= this.scaleFactor;
                        userY *= this.scaleFactor;
                        userX += (double)this.focusShiftX;
                        userY += (double)this.focusShiftY;
                        if (this.plotActivelistSize) {
                            gr.drawString(Integer.toString(user.getUserTerminal().getActiveList().size()), (int)userX + 6, (int)userY);
                        }
                        int diameter = 4;
                        gr.fillOval((int)userX - diameter / 2, (int)userY - diameter / 2, diameter, diameter);
                    }
                }
            }
            if (this.selectedLink != null) {
                AbstractDmaMobile user = this.selectedLink.getUserTerminal();
                gr.setColor(Color.BLUE);
                double userX = user.getPosition().getX();
                double userY = -user.getPosition().getY();
                userX *= this.scaleFactor;
                userY *= this.scaleFactor;
                this.drawAnimatedOval(gr, user, user, userX += (double)this.focusShiftX, userY += (double)this.focusShiftY, 4);
                gr.setColor(Color.GREEN);
                double cX = this.selectedLink.getBaseStation().getPosition().getX();
                double cY = -this.selectedLink.getBaseStation().getPosition().getY();
                cX *= this.scaleFactor;
                cY *= this.scaleFactor;
                gr.drawLine((int)userX, (int)userY, (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
            }
            if (this.selectedLink != null) {
                AbstractDmaMobile user = this.selectedLink.getUserTerminal();
                gr.setColor(Color.BLUE);
                double userX = user.getPosition().getX();
                double userY = -user.getPosition().getY();
                userX *= this.scaleFactor;
                userY *= this.scaleFactor;
                this.drawAnimatedOval(gr, user, user, userX += (double)this.focusShiftX, userY += (double)this.focusShiftY, 4);
                gr.setColor(Color.GREEN);
                double cX = this.selectedLink.getBaseStation().getPosition().getX();
                double cY = -this.selectedLink.getBaseStation().getPosition().getY();
                cX *= this.scaleFactor;
                cY *= this.scaleFactor;
                gr.drawLine((int)userX, (int)userY, (int)(cX += (double)this.focusShiftX), (int)(cY += (double)this.focusShiftY));
            }
            double[] shiftX = new double[]{radius, -radius * Mathematics.cosD(60.0), -radius * Mathematics.cosD(60.0)};
            double[] shiftY = new double[]{0.0, -radius * Mathematics.sinD(60.0), radius * Mathematics.sinD(60.0)};
            for (int i = 0; i < cells.length; ++i) {
                int k = 0;
                double cellX6 = cells[i][k].getPosition().getX();
                double cellY6 = -cells[i][k].getPosition().getY();
                cellX6 *= this.scaleFactor;
                cellY6 *= this.scaleFactor;
                cellX6 += (double)this.focusShiftX;
                cellY6 += (double)this.focusShiftY;
                gr.setColor(Color.BLUE);
                int[] xPoints2 = new int[6];
                int[] yPoints2 = new int[6];
                for (int j6 = 0; j6 < 6; ++j6) {
                    int x = 0;
                    int y = 0;
                    if (this.model.getPlugin().getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                        xPoints2[j6] = (int)(Mathematics.cosD((double)j6 * angle) * radius + cellX6);
                        yPoints2[j6] = (int)(Mathematics.sinD((double)j6 * angle) * radius + cellY6);
                        x = (int)(Mathematics.cosD((double)(j6 + 1) * angle) * radius + cellX6);
                        y = (int)(Mathematics.sinD((double)(j6 + 1) * angle) * radius + cellY6);
                        gr.drawLine(xPoints2[j6], yPoints2[j6], x, y);
                        if (j6 % 2 != 0) continue;
                        gr.drawLine((int)(Mathematics.cosD((double)j6 * angle) * radius + cellX6), (int)(Mathematics.sinD((double)j6 * angle) * radius + cellY6), (int)cellX6, (int)cellY6);
                        continue;
                    }
                    if (this.model.getPlugin().getSectorSetup() == HybridSystemPlugin.SectorSetup.SingleSector) continue;
                    for (int sector = 0; sector < 3; ++sector) {
                        xPoints2[j6] = (int)(Mathematics.cosD((double)j6 * angle) * radius + cellX6 + shiftX[sector]);
                        yPoints2[j6] = (int)(Mathematics.sinD((double)j6 * angle) * radius + cellY6 + shiftY[sector]);
                        x = (int)(Mathematics.cosD((double)(j6 + 1) * angle) * radius + cellX6 + shiftX[sector]);
                        y = (int)(Mathematics.sinD((double)(j6 + 1) * angle) * radius + cellY6 + shiftY[sector]);
                        gr.drawLine(xPoints2[j6], yPoints2[j6], x, y);
                    }
                }
                gr.setColor(Color.GREEN);
                if (this.plotCellCenter) {
                    this.drawAnimatedOval(gr, cells[i][k], this.selectedCell, cellX6, cellY6, 6);
                }
                gr.setColor(Color.BLACK);
                if (this.plotCellid) {
                    if (this.model.getPlugin().getSectorSetup() != HybridSystemPlugin.SectorSetup.SingleSector) {
                        gr.drawString("BS #" + cells[i][0].getCellid() + ":", (int)(cellX6 + radius / 5.0), (int)(cellY6 - (double)gr.getFont().getSize() * 1.5));
                        gr.drawString("BS #" + cells[i][1].getCellid() + ":", (int)(cellX6 - 2.0 * radius / 3.0), (int)cellY6);
                        gr.drawString("BS #" + cells[i][2].getCellid() + ":", (int)(cellX6 + radius / 5.0), (int)(cellY6 + (double)gr.getFont().getSize() * 1.5));
                    } else {
                        gr.drawString("Cell #" + cells[i][0].getCellid() + ":", (int)(cellX6 - 2.0 * radius / 3.0), (int)(cellY6 - (double)gr.getFont().getSize() * 1.5));
                    }
                }
                if (this.plotTxStats) {
                    if (this.model.isUplink) {
                        gr.drawString("Itotal: " + Mathematics.round(cells[i][0].getTotalInterference()) + " dBm", (int)(cellX6 - 2.0 * radius / 3.0), (int)cellY6);
                        if (this.model.getPlugin() instanceof HybridCDMAUpLinkPlugin) {
                            gr.drawString("NoiseRise: " + Math.rint(cells[i][0].calculateNoiseRiseOverThermalNoise_dB() * 1000.0) / 1000.0 + " dB", (int)(cellX6 - 2.0 * radius / 3.0), (int)(cellY6 + (double)gr.getFont().getSize() * 1.5));
                        }
                    } else {
                        gr.drawString("TX: " + Math.rint(cells[i][0].getCurrentTransmitPower_dBm() * 1000.0) / 1000.0 + " dBm", (int)(cellX6 - 2.0 * radius / 3.0), (int)cellY6);
                    }
                    gr.drawString("Users: " + cells[i][0].countServedUsers(), (int)(cellX6 - 2.0 * radius / 3.0), (int)(cellY6 + (double)(gr.getFont().getSize() * 3)));
                }
                if (!this.plotFixedLocations) continue;
                gr.drawString("X: " + fixedLocationsStrings[i][0], (int)cellX6, (int)(cellY6 - 1.5 * (double)gr.getFont().getSize()));
                gr.drawString("Y: " + fixedLocationsStrings[i][1], (int)cellX6, (int)cellY6);
            }
            if (this.tooltip != null && this.tooltipDestination != null) {
                double toolX = this.tooltipDestination.getX();
                double toolY = -this.tooltipDestination.getY();
                toolX *= this.scaleFactor;
                toolY *= this.scaleFactor;
                gr.drawString(this.tooltip, (int)(toolX += (double)this.focusShiftX), (int)(toolY += (double)this.focusShiftY));
            }
        } else {
            gr.setFont(this.getFont().deriveFont(20.0f));
            String msg = "Run a simulation to display the cellular grid";
            gr.drawString(msg, (int)(dim.getWidth() / 2.0 - gr.getFontMetrics().getStringBounds(msg, gr).getWidth() / 2.0), (int)(dim.getHeight() / 2.0));
        }
    }

    private void drawConf(boolean main, Graphics2D gr, AntennaGain conf, double radius, double extX, double extY) {
        List<Point2D> points = this.gainPlot(conf);
        Collections.sort(points, Point2D.Y_COMPARATOR);
        double min = points.get(0).getY();
        double max = points.get(points.size() - 1).getY();
        Collections.sort(points, Point2D.X_COMPARATOR);
        double diff = Math.abs(max - min);
        double offset = min < 0.0 ? Math.abs(min) : 0.0;
        int[] xPatternPoints = new int[points.size()];
        int[] yPatternPoints = new int[points.size()];
        gr.setColor(Color.RED);
        for (int z = 0; z < points.size(); ++z) {
            Point2D po1 = points.get(z);
            double y = po1.getY() + offset;
            double x = po1.getX();
            double distFactor = diff == 0.0 ? 20.0 : radius - radius / diff * y;
            int p1 = (int)(-Mathematics.cosD(x) * distFactor + extX);
            int p2 = (int)(Mathematics.sinD(x) * distFactor + extY);
            xPatternPoints[z] = p1;
            yPatternPoints[z] = p2;
        }
        if (main) {
            gr.setPaint(new RadialGradientPaint(new Point2D.Double(extX, extY), new Float(radius).floatValue(), new float[]{0.0f, 1.0f}, new Color[]{Color.RED, this.patternColor.brighter()}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
            gr.fillPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
            gr.setColor(Color.RED);
            gr.drawPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
        } else {
            gr.setColor(this.patternColor);
            gr.fillPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
            gr.setColor(Color.RED);
            gr.drawPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
        }
    }

    private List<Point2D> gainPlot(AntennaGain configuration) {
        LinkResult result = Factory.results().linkResult();
        result.setFrequency(this.model.frequency);
        AntennaResult x = result.rxAntenna();
        ArrayList<Point2D> hor = new ArrayList<Point2D>();
        x.setElevation(0.0);
        for (double azi = 0.0; azi <= 360.0; azi += 1.0) {
            x.setAzimuth(azi);
            double value = configuration.evaluate(result, x);
            double v = Math.rint(azi * 10.0) / 10.0;
            hor.add(new Point2D(v, value));
        }
        return hor;
    }

    public void resetView() {
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftX", this.getFocusShiftX(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftY", this.getFocusShiftY(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "zoomFactor", this.getZoomFactor(), 1.0).start();
    }

    public void setModel(CDMAPlotModel model) {
        this.model = model;
    }

    public void setFocusShiftX(int focusShiftX) {
        this.focusShiftX = focusShiftX;
        this.repaint();
    }

    public void setFocusShiftY(int focusShiftY) {
        this.focusShiftY = focusShiftY;
        this.repaint();
    }

    public void setPlotAntennaPattern(boolean plotAntennaPattern) {
        this.plotAntennaPattern = plotAntennaPattern;
        this.repaint();
    }

    public void setPlotCellBackground(boolean plotCellBackground) {
        this.plotCellBackground = plotCellBackground;
        this.repaint();
    }

    public void setPlotCellCenter(boolean plotCellCenter) {
        this.plotCellCenter = plotCellCenter;
        this.repaint();
    }

    public void setPlotCellid(boolean plotCellid) {
        this.plotCellid = plotCellid;
        this.repaint();
    }

    public void setPlotConnectionLines(boolean plotConnectionLines) {
        this.plotConnectionLines = plotConnectionLines;
        this.repaint();
    }

    public void setPlotDroppedUsers(boolean plotDroppedUsers) {
        this.plotDroppedUsers = plotDroppedUsers;
        this.repaint();
    }

    public void setPlotExternalInterferers(boolean plotExternalInterferers) {
        this.plotExternalInterferers = plotExternalInterferers;
        this.repaint();
    }

    public void setPlotFixedLocations(boolean plotFixedLocations) {
        this.plotFixedLocations = plotFixedLocations;
        this.repaint();
    }

    public void setPlotHelp(boolean plotHelp) {
        this.plotHelp = plotHelp;
        this.repaint();
    }

    public void setPlotLegend(boolean plotLegend) {
        this.plotLegend = plotLegend;
        this.repaint();
    }

    public void setPlotScale(boolean plotScale) {
        this.plotScale = plotScale;
    }

    public void setPlotSizeOfActiveList(boolean plotUserID) {
        this.plotActivelistSize = plotUserID;
        this.repaint();
    }

    public void setPlotTxStats(boolean plotTxStats) {
        this.plotTxStats = plotTxStats;
        this.repaint();
    }

    public void setPlotUsers(boolean plotUsers) {
        this.plotUsers = plotUsers;
        this.repaint();
    }

    public void setSelectedCell(AbstractDmaBaseStation selectedCell) {
        this.selectedCell = selectedCell;
        if (this.selectedCell != null) {
            if (this.animator != null) {
                this.animator.cancel();
            } else {
                this.animator = new Animator(200, -1.0, Animator.RepeatBehavior.REVERSE, this.prop);
            }
            this.animator.start();
        }
    }

    public void setSelectedInterferer(Interferer inter) {
        this.selectedInterferer = inter;
        if (this.selectedInterferer != null) {
            if (this.animator != null) {
                this.animator.cancel();
            } else {
                this.animator = new Animator(200, -1.0, Animator.RepeatBehavior.REVERSE, this.prop);
            }
            this.animator.start();
        }
    }

    public void setSelectedItemZoomFactor(int selectedItemZoomFactor) {
        this.selectedItemZoomFactor = selectedItemZoomFactor;
        this.repaint();
    }

    public void setSelectedLink(AbstractDmaLink selectedLink) {
        this.selectedLink = selectedLink;
    }

    public void setSelectedUser(AbstractDmaMobile selectedUser) {
        this.selectedUser = selectedUser;
        if (this.selectedUser != null) {
            if (this.animator != null) {
                this.animator.cancel();
            } else {
                this.animator = new Animator(200, -1.0, Animator.RepeatBehavior.REVERSE, this.prop);
            }
            this.animator.start();
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.tooltip = text;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.repaint();
    }

    static {
        LOG = Logger.getLogger(DetailedSystemPlot.class);
        fixedLocationsStrings = new String[19][2];
        DetailedSystemPlot.fixedLocationsStrings[0][0] = "x";
        DetailedSystemPlot.fixedLocationsStrings[0][1] = "y";
        DetailedSystemPlot.fixedLocationsStrings[1][0] = "x + 1.5*D/Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[1][1] = "y + D / 2";
        DetailedSystemPlot.fixedLocationsStrings[2][0] = "x";
        DetailedSystemPlot.fixedLocationsStrings[2][1] = "y + D";
        DetailedSystemPlot.fixedLocationsStrings[3][0] = "x - 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[3][1] = "y + D / 2";
        DetailedSystemPlot.fixedLocationsStrings[4][0] = "x - 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[4][1] = "y - D / 2";
        DetailedSystemPlot.fixedLocationsStrings[5][0] = "x";
        DetailedSystemPlot.fixedLocationsStrings[5][1] = "y - D";
        DetailedSystemPlot.fixedLocationsStrings[6][0] = "x + 1.5*D/Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[6][1] = "y - d / 2";
        DetailedSystemPlot.fixedLocationsStrings[7][0] = "x + 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[7][1] = "y";
        DetailedSystemPlot.fixedLocationsStrings[8][0] = "x + 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[8][1] = "y + D";
        DetailedSystemPlot.fixedLocationsStrings[9][0] = "x + 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[9][1] = "y + 1.5*D";
        DetailedSystemPlot.fixedLocationsStrings[10][0] = "x";
        DetailedSystemPlot.fixedLocationsStrings[10][1] = "y + 2*D";
        DetailedSystemPlot.fixedLocationsStrings[11][0] = "x - 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[11][1] = "y + 1.5*D";
        DetailedSystemPlot.fixedLocationsStrings[12][0] = "x - 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[12][1] = "y + D";
        DetailedSystemPlot.fixedLocationsStrings[13][0] = "x - 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[13][1] = "y";
        DetailedSystemPlot.fixedLocationsStrings[14][0] = "x - 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[14][1] = "y - D";
        DetailedSystemPlot.fixedLocationsStrings[15][0] = "x - 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[15][1] = "y - 1.5*D";
        DetailedSystemPlot.fixedLocationsStrings[16][0] = "x";
        DetailedSystemPlot.fixedLocationsStrings[16][1] = "y - 2*D";
        DetailedSystemPlot.fixedLocationsStrings[17][0] = "x + 1.5*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[17][1] = "y - 1.5*D";
        DetailedSystemPlot.fixedLocationsStrings[18][0] = "x + 3*D / Math.sqrt(3)";
        DetailedSystemPlot.fixedLocationsStrings[18][1] = "y - D";
    }
}

