/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.CapacityEndingTest;
import org.seamcat.events.CapacityEndingTrial;
import org.seamcat.events.CapacityStartingCapacityFinding;
import org.seamcat.events.CapacityStartingTest;
import org.seamcat.presentation.simulationview.SimulationView;

public class CapacityFindingStatusPanel
extends JPanel {
    private DefaultValueDataset numberOfTrialsData;
    private ChartPanel numberOfTrialsPanel;
    private MeterPlot numberOfTrialsPlot;
    private JFreeChart overallStatusChart;
    private DefaultCategoryDataset overallStatusData;
    private ChartPanel overallStatusPanel;
    private DefaultValueDataset successRateData;
    private ChartPanel successRatePanel;
    private MeterPlot successRatePlot;
    private int testCounter = 0;
    private boolean uplink;
    private DefaultValueDataset usersPerCellData;
    private ChartPanel usersPerCellPanel;
    private MeterPlot usersPerCellPlot;
    private Object context;
    private SimulationView view;

    public CapacityFindingStatusPanel(Object context, SimulationView view) {
        this.context = context;
        this.view = view;
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        this.setLayout(formlayout1);
        this.numberOfTrialsData = new DefaultValueDataset(0.0);
        this.successRateData = new DefaultValueDataset(0.0);
        this.usersPerCellData = new DefaultValueDataset(0.0);
        this.overallStatusData = new DefaultCategoryDataset();
        this.numberOfTrialsPlot = new MeterPlot(this.numberOfTrialsData);
        this.numberOfTrialsPlot.setUnits("Trials completed");
        this.numberOfTrialsPlot.setBackgroundPaint(Color.WHITE);
        this.numberOfTrialsPlot.setNeedlePaint(Color.BLACK);
        this.numberOfTrialsPlot.setOutlinePaint(Color.BLACK);
        this.numberOfTrialsPlot.setValuePaint(Color.BLUE);
        this.numberOfTrialsPlot.setTickPaint(Color.BLUE);
        this.numberOfTrialsPlot.setRange(new Range(0.0, 20.0));
        this.numberOfTrialsPlot.setDialShape(DialShape.CIRCLE);
        this.numberOfTrialsPlot.setDialBackgroundPaint(this.getBackground());
        this.numberOfTrialsPlot.setTickSize(2.0);
        this.numberOfTrialsPanel = new ChartPanel(new JFreeChart(this.numberOfTrialsPlot));
        this.usersPerCellPlot = new MeterPlot(this.usersPerCellData);
        this.usersPerCellPlot.setUnits("Users per Cell");
        this.usersPerCellPlot.setBackgroundPaint(Color.WHITE);
        this.usersPerCellPlot.setNeedlePaint(Color.BLACK);
        this.usersPerCellPlot.setOutlinePaint(Color.BLACK);
        this.usersPerCellPlot.setValuePaint(Color.BLUE);
        this.usersPerCellPlot.setTickPaint(Color.BLUE);
        this.usersPerCellPlot.setRange(new Range(0.0, 120.0));
        this.usersPerCellPlot.setDialShape(DialShape.CIRCLE);
        this.usersPerCellPlot.setDialBackgroundPaint(this.getBackground());
        this.usersPerCellPlot.setTickSize(10.0);
        this.usersPerCellPanel = new ChartPanel(new JFreeChart(this.usersPerCellPlot));
        this.successRatePlot = new MeterPlot(this.successRateData);
        this.successRatePlot.setRange(new Range(0.0, 20.0));
        this.successRatePlot.setBackgroundPaint(Color.WHITE);
        this.successRatePlot.setDialBackgroundPaint(this.getBackground());
        this.successRatePlot.setUnits("Successful trials");
        this.successRatePlot.setDialShape(DialShape.CIRCLE);
        this.successRatePlot.setNeedlePaint(Color.BLACK);
        this.successRatePlot.setValuePaint(Color.BLUE);
        this.successRatePlot.setTickSize(2.0);
        this.successRatePlot.setTickPaint(Color.BLUE);
        this.successRatePanel = new ChartPanel(new JFreeChart(this.successRatePlot));
        this.successRatePanel.getChart().removeLegend();
        this.overallStatusChart = ChartFactory.createStackedBarChart("Non interfered capacity finding status", "Users per cell", "Successful Trials", this.overallStatusData, PlotOrientation.VERTICAL, false, true, false);
        CategoryAxis axis = this.overallStatusChart.getCategoryPlot().getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        this.overallStatusPanel = new ChartPanel(this.overallStatusChart);
        this.add((Component)this.numberOfTrialsPanel, cc.xy(2, 2));
        this.add((Component)this.usersPerCellPanel, cc.xy(3, 2));
        this.add((Component)this.successRatePanel, cc.xy(4, 2));
        this.add((Component)this.overallStatusPanel, cc.xywh(2, 3, 3, 1));
        this.addFillComponents(this, new int[]{1, 2, 3, 4}, new int[]{1, 2, 3, 4});
        this.setBorder(new TitledBorder("CDMA Non-Interfered Capacity status"));
        Subscriber.subscribe(this);
    }

    private void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    @UIEventHandler
    public void handleEndingTest(CapacityEndingTest event) {
        if (event.getContext() == this.context) {
            this.overallStatusData.setValue(event.getSuccessRate(), (Comparable)((Object)"Row"), (Comparable)((Object)(++this.testCounter + "#Users: " + event.getUsersPerCell())));
        }
    }

    @UIEventHandler
    public void handleEndingTrial(CapacityEndingTrial event) {
        if (event.getContext() == this.context) {
            if (this.uplink) {
                this.successRateData.setValue(event.getOutage());
            } else if (event.isSuccess()) {
                this.successRateData.setValue(this.successRateData.getValue().intValue() + 1);
            }
            this.numberOfTrialsData.setValue(event.getTrialid() + 1);
        }
    }

    @UIEventHandler
    public void handleStarting(CapacityStartingCapacityFinding event) {
        if (event.getContext() == this.context) {
            this.view.show(this);
            double allowableOutage = event.getAllowableOutage();
            int trials = event.getTrials();
            double target = event.getTarget();
            this.overallStatusChart.getCategoryPlot().clearRangeMarkers();
            this.successRatePlot.clearIntervals();
            this.uplink = event.isUplink();
            this.overallStatusChart.setBackgroundPaint(this.getBackground());
            CategoryPlot p = this.overallStatusChart.getCategoryPlot();
            p.setBackgroundPaint(Color.WHITE);
            p.setRangeGridlinePaint(this.getForeground());
            p.setDomainGridlinePaint(this.getForeground());
            p.getDomainAxis().setTickLabelFont(this.getFont());
            p.getDomainAxis().setTickLabelPaint(this.getForeground());
            p.getDomainAxis().setLabelFont(this.getFont());
            p.getDomainAxis().setLabelPaint(this.getForeground());
            p.getRangeAxis().setTickLabelFont(this.getFont());
            p.getRangeAxis().setTickLabelPaint(this.getForeground());
            p.getRangeAxis().setLabelFont(this.getFont());
            p.getRangeAxis().setLabelPaint(this.getForeground());
            if (this.uplink) {
                Marker marker;
                this.overallStatusChart.getCategoryPlot().getRangeAxis().setLabel("Average Noiserise (dB)");
                this.overallStatusChart.getCategoryPlot().getRangeAxis().setRange(0.0, 10.0);
                this.successRatePlot.setRange(new Range(0.0, 20.0));
                this.successRatePlot.setUnits("dB of Average Noise-rise");
                this.successRatePlot.setTickSize(2.0);
                if (allowableOutage != 0.0) {
                    double min = target - allowableOutage;
                    double max = target;
                    marker = new IntervalMarker(min, max);
                    this.successRatePlot.addInterval(new MeterInterval("Try with more users per cell", new Range(0.0, min), Color.BLACK, new BasicStroke(1.0f), new Color(255, 85, 85)));
                    this.successRatePlot.addInterval(new MeterInterval("Non-interfered capacity found", new Range(min, max), Color.BLACK, new BasicStroke(1.0f), new Color(85, 255, 85)));
                    this.successRatePlot.addInterval(new MeterInterval("Try with fewer users per cell", new Range(max, 20.0), Color.BLACK, new BasicStroke(1.0f), new Color(255, 255, 85)));
                } else {
                    marker = new ValueMarker(target);
                    this.successRatePlot.addInterval(new MeterInterval("Try with more users per cell", new Range(0.0, target), Color.BLACK, new BasicStroke(1.0f), new Color(255, 85, 85)));
                    this.successRatePlot.addInterval(new MeterInterval("Try with fewer users per cell", new Range(target, 20.0), Color.BLACK, new BasicStroke(1.0f), new Color(255, 255, 85)));
                }
                marker.setPaint(new Color(180, 255, 255));
                this.overallStatusChart.getCategoryPlot().addRangeMarker(marker);
            } else {
                this.overallStatusChart.getCategoryPlot().getRangeAxis().setRange(0.0, trials);
                this.overallStatusChart.getCategoryPlot().getRangeAxis().setLabel("Successful Trials");
                this.overallStatusChart.getCategoryPlot().addRangeMarker(new ValueMarker((double)trials * target));
                this.successRatePlot.setRange(new Range(0.0, trials));
                this.successRatePlot.setUnits("Successful trials");
                this.successRatePlot.setTickSize((double)trials / 10.0);
                this.successRatePlot.addInterval(new MeterInterval("Try with fewer users per cell", new Range(0.0, (int)((double)trials * 0.8 - 1.0)), Color.BLACK, new BasicStroke(1.0f), new Color(255, 85, 85)));
                this.successRatePlot.addInterval(new MeterInterval("Non-interfered capacity found", new Range((int)((double)trials * 0.8 - 1.0), (int)((double)trials * 0.8 + 1.0)), Color.BLACK, new BasicStroke(1.0f), new Color(85, 255, 85)));
                this.successRatePlot.addInterval(new MeterInterval("Try with more users per cell", new Range((int)((double)trials * 0.8 + 1.0), trials), Color.BLACK, new BasicStroke(1.0f), new Color(255, 255, 85)));
            }
            this.overallStatusData.clear();
            this.testCounter = 0;
        }
    }

    @UIEventHandler
    public void handleStartingTest(CapacityStartingTest event) {
        if (event.getContext() == this.context) {
            this.numberOfTrialsData.setValue(0);
            this.numberOfTrialsPlot.setRange(new Range(0.0, event.getTrials()));
            this.numberOfTrialsPlot.setTickSize((double)event.getTrials() / 10.0);
            this.numberOfTrialsPlot.setTickLabelsVisible(true);
            this.usersPerCellData.setValue(event.getUsersPrCell());
            this.successRateData.setValue(0);
        }
    }
}

