/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class CDMAPlotModel {
    public boolean victimSystem;
    public Collector collector;
    public RadioSystem cellularSystem;
    public HybridSystemPlugin plugin;
    public List<AbstractDmaMobile> activeUsers;
    public List<AbstractDmaMobile> inactiveUsers;
    public List<AbstractDmaMobile> droppedUsers;
    public AbstractDmaBaseStation[][] baseStations;
    public List<Interferer> externalInterferers;
    public AbstractDmaBaseStation referenceCell;
    public Point2D location;
    public String name;
    public boolean isUplink;
    public double processingGain;
    public int numberOfLLDFound;
    public double maxTrafficChannelPower;
    public double frequency;
    public double intercellDistance;
    public EventResult eventResult;
    public List<Victim> victims;

    public HybridSystemPlugin getPlugin() {
        return this.plugin;
    }

    public RadioSystem getCellularSystem() {
        return this.cellularSystem;
    }

    public List<AbstractDmaMobile> getActiveUsers() {
        return this.activeUsers;
    }

    public AbstractDmaBaseStation[][] getBaseStations() {
        return this.baseStations;
    }

    public List<Interferer> getExternalInterferers() {
        return this.externalInterferers;
    }

    public AbstractDmaBaseStation getReferenceCell() {
        return this.referenceCell;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public boolean isVictimSystem() {
        return this.victimSystem;
    }

    public List<AbstractDmaBaseStation> getAllBaseStations() {
        ArrayList<AbstractDmaBaseStation> list = new ArrayList<AbstractDmaBaseStation>();
        if (this.baseStations != null) {
            for (AbstractDmaBaseStation[] bases : this.baseStations) {
                list.addAll(Arrays.asList(bases));
            }
        }
        return list;
    }

    public List<AbstractDmaMobile> getDroppedUsers() {
        return this.droppedUsers;
    }

    public List<AbstractDmaMobile> getInactiveUsers() {
        return this.inactiveUsers;
    }

    public int getNumberOfBaseStations() {
        return (this.plugin.getSectorSetup() == HybridSystemPlugin.SectorSetup.SingleSector ? 1 : 3) * this.getNumberOfCellSitesInPowerControlCluster();
    }

    private int getNumberOfCellSitesInPowerControlCluster() {
        switch (this.plugin.getTierSetup()) {
            case SingleCell: {
                return 1;
            }
            case OneTier: {
                return 7;
            }
        }
        return 19;
    }

    public double getProcessingGain() {
        return this.processingGain;
    }

    public int getNumberOfLLDFound() {
        return this.numberOfLLDFound;
    }

    public double getMaxTrafficChannelPower() {
        return this.maxTrafficChannelPower;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }
}

