/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.cdma.CDMALinkLevelDataPoint;
import org.seamcat.presentation.SeamcatDoubleCellEditor;
import org.seamcat.presentation.components.SpringUtilities;
import org.seamcat.presentation.systems.cdma.CDMAEditModel;
import org.seamcat.presentation.systems.cdma.CDMALinkLevelDataEditBasicsDialog;
import org.seamcat.presentation.systems.cdma.LLDGraphPanel;

public class CDMALinkLevelDataEditorPanel
extends JPanel {
    private JFrame owner;
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final CenterPanel centerPanel = new CenterPanel();
    private CDMALinkLevelData data;
    private TitlePanel titlePanel = new TitlePanel();

    public CDMALinkLevelDataEditorPanel(JFrame owner) {
        super(new BorderLayout());
        this.owner = owner;
        this.add((Component)this.titlePanel, "North");
        this.add((Component)new SideButtonPanel(), "East");
        this.add((Component)this.centerPanel, "Center");
        this.add(Box.createHorizontalStrut(50), "West");
    }

    private int addTableRow() {
        return this.centerPanel.addTableRow();
    }

    private void removeTableRow() {
        this.centerPanel.removeTableRow();
    }

    private void selectCell(int row, int col) {
        this.centerPanel.pointTablePanel.table.changeSelection(row, col, true, false);
        this.centerPanel.pointTablePanel.table.editCellAt(row, col);
        this.centerPanel.pointTablePanel.table.grabFocus();
    }

    public void setModel(CDMALinkLevelData data) {
        this.data = data;
        this.centerPanel.setModels();
        if (data != null) {
            this.setSelectedPathModel(1);
        }
    }

    private void setSelectedPathModel(int path) {
        this.centerPanel.setSelectedPathModel(path);
        this.titlePanel.setPanelTitle(this.data.getPathDescription(path));
    }

    private static class TitlePanel
    extends JPanel {
        private final JLabel lbTitle = new JLabel("title undefined");

        TitlePanel() {
            super(new FlowLayout(1));
            this.lbTitle.setFont(this.getFont().deriveFont(1));
            this.add(this.lbTitle);
        }

        void setPanelTitle(String title) {
            this.lbTitle.setText(title);
        }
    }

    private class SideButtonPanel
    extends JPanel {
        private final CDMALinkLevelDataEditBasicsDialog basicsDialog;
        private final DataPointAddDeletePanel dataPointAddDeletePanel = new DataPointAddDeletePanel();
        private final PathSelectorPanel pathSelectorPanel = new PathSelectorPanel();

        SideButtonPanel() {
            this.basicsDialog = new CDMALinkLevelDataEditBasicsDialog(CDMALinkLevelDataEditorPanel.this.owner);
            JButton btnBasics = new JButton(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_LINKBASICS"));
            btnBasics.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SideButtonPanel.this.btnBasicsActionPerformed();
                }
            });
            JButton btnAdvanced = new JButton("Advanced");
            btnAdvanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double geo = 7.0;
                    CDMALinkLevelDataPoint point = new CDMALinkLevelDataPoint(CDMALinkLevelDataEditorPanel.this.data.getFrequency(), 1, geo, 0.0, 0.0);
                    CDMALinkLevelDataEditorPanel.this.data.getLinkLevelDataPoint(point);
                    CDMALinkLevelDataEditorPanel.this.setModel(CDMALinkLevelDataEditorPanel.this.data);
                }
            });
            JPanel btnBasicsPanel = new JPanel(new GridLayout());
            btnBasicsPanel.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_BTN_BORDER")));
            btnBasicsPanel.add(btnBasics);
            this.setLayout(new BoxLayout(this, 3));
            this.add(this.pathSelectorPanel);
            this.add(this.dataPointAddDeletePanel);
            this.add(btnBasicsPanel);
            this.add(Box.createVerticalStrut(1000));
        }

        void btnBasicsActionPerformed() {
            if (this.basicsDialog.showDialog(CDMALinkLevelDataEditorPanel.this.data)) {
                CDMALinkLevelDataEditorPanel.this.setModel(CDMALinkLevelDataEditorPanel.this.data);
            }
        }

        private class PathSelectorPanel
        extends JPanel {
            private final JRadioButton rb1Path;
            private final JRadioButton rb2Path;

            PathSelectorPanel() {
                super(new GridLayout(2, 1));
                this.rb1Path = new JRadioButton(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_1PATH"));
                this.rb2Path = new JRadioButton(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_2PATH"));
                ButtonGroup bgPath = new ButtonGroup();
                bgPath.add(this.rb1Path);
                bgPath.add(this.rb2Path);
                this.rb1Path.setSelected(true);
                this.rb1Path.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathSelectorPanel.this.selectPath(1);
                    }
                });
                this.rb2Path.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PathSelectorPanel.this.selectPath(2);
                    }
                });
                this.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_PATHS")));
                this.add(this.rb1Path);
                this.add(this.rb2Path);
            }

            void selectPath(int path) {
                CDMALinkLevelDataEditorPanel.this.setSelectedPathModel(path);
                CDMALinkLevelDataEditorPanel.this.data.setCurrentPath(path);
            }
        }

        private class DataPointAddDeletePanel
        extends JPanel {
            DataPointAddDeletePanel() {
                super(new GridLayout(2, 1));
                JButton btnAdd = new JButton(STRINGLIST.getString("BTN_CAPTION_ADD"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CDMALinkLevelDataEditorPanel.this.selectCell(CDMALinkLevelDataEditorPanel.this.addTableRow(), 0);
                    }
                });
                JButton btnDelete = new JButton(STRINGLIST.getString("BTN_CAPTION_DELETE"));
                btnDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CDMALinkLevelDataEditorPanel.this.removeTableRow();
                    }
                });
                this.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_DETAILS_DATAPOINTS")));
                this.add(btnAdd);
                this.add(btnDelete);
            }
        }
    }

    private static class LinkLevelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final Color ILLEGAL_BGCOLOR = new Color(255, 120, 120);

        public LinkLevelCellRenderer() {
            super("", 4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (table.getModel().getValueAt(row, 0) == null && !isSelected) {
                this.setBackground(ILLEGAL_BGCOLOR);
            }
            this.setEnabled(table.isEnabled());
            this.setFont(table.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class CenterPanel
    extends JPanel
    implements TableModelListener {
        private final LLDGraphPanel graphPanel;
        private final PointTablePanel pointTablePanel;

        CenterPanel() {
            super(new SpringLayout());
            this.graphPanel = new LLDGraphPanel();
            this.pointTablePanel = new PointTablePanel(this);
            this.add(this.pointTablePanel);
            this.add(Box.createVerticalGlue());
            this.add(this.graphPanel);
            SpringUtilities.makeCompactGrid(this, 3, 1, 0, 0, 0, 0);
        }

        int addTableRow() {
            return this.pointTablePanel.addTableRow();
        }

        CDMAEditModel getPathModel(int path) {
            return this.pointTablePanel.getPathModel(path);
        }

        void removeTableRow() {
            this.pointTablePanel.removeTableRow();
        }

        void setModels() {
            if (CDMALinkLevelDataEditorPanel.this.data == null) {
                return;
            }
            CDMAEditModel path1Model = (CDMAEditModel)CDMALinkLevelDataEditorPanel.this.data.getTableModel(1);
            CDMAEditModel path2Model = (CDMAEditModel)CDMALinkLevelDataEditorPanel.this.data.getTableModel(2);
            this.pointTablePanel.setModels(path1Model, path2Model);
            if (path1Model != null && path2Model != null) {
                this.pointTablePanel.setSelectedPathModel(1);
                if (CDMALinkLevelDataEditorPanel.this.data.getLinkType() == CDMALinkLevelData.LinkType.DOWNLINK) {
                    this.graphPanel.setRangeLabel(CDMALinkLevelDataEditorPanel.this.data.getTargetERpct(), CDMALinkLevelDataEditorPanel.this.data.getTargetERType().toString());
                }
            }
        }

        void setSelectedPathModel(int path) {
            this.pointTablePanel.setSelectedPathModel(path);
            this.graphPanel.setGraph(this.getPathModel(path));
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.graphPanel.updateGraph();
            if (e.getType() != -1 && e.getType() == 0) {
                ArrayList<CDMALinkLevelDataPoint> values = new ArrayList<CDMALinkLevelDataPoint>();
                CDMAEditModel model = (CDMAEditModel)e.getSource();
                for (int row = 0; row < model.getRowCount(); ++row) {
                    double geometry = 0.0;
                    for (int column = 0; column < model.getColumnCount(); ++column) {
                        Double value = (Double)model.getValueAt(row, column);
                        if (column == 0) {
                            geometry = value;
                            continue;
                        }
                        if (value == null) continue;
                        double speed = CDMALinkLevelData.SPEED_VALUES[column - 1];
                        values.add(new CDMALinkLevelDataPoint(CDMALinkLevelDataEditorPanel.this.data.getFrequency(), CDMALinkLevelDataEditorPanel.this.data.getCurrentPath(), geometry, speed, value));
                    }
                }
                CDMALinkLevelDataEditorPanel.this.data.updatePath(CDMALinkLevelDataEditorPanel.this.data.getCurrentPath(), values);
            }
        }

        private class PointTablePanel
        extends JPanel {
            private CDMAEditModel path1Model;
            private CDMAEditModel path2Model;
            private final JTable table;
            private final TableModelListener tableModelListener;

            PointTablePanel(TableModelListener tableModelListener) {
                super(new GridLayout());
                this.table = new JTable();
                this.tableModelListener = tableModelListener;
                this.table.setRowSelectionAllowed(false);
                this.table.setColumnSelectionAllowed(false);
                this.table.setCellSelectionEnabled(true);
                this.table.setDefaultRenderer(Double.class, new LinkLevelCellRenderer());
                this.table.setDefaultEditor(Double.class, new SeamcatDoubleCellEditor(-100000.0, 100000.0));
                this.add(new JScrollPane(this.table));
                this.setPreferredSize(new Dimension(500, 200));
            }

            int addTableRow() {
                CDMAEditModel model = (CDMAEditModel)this.table.getModel();
                model.addRow();
                this.table.tableChanged(new TableModelEvent(model));
                return model.getRowCount() - 1;
            }

            CDMAEditModel getPathModel(int path) {
                if (path == 1) {
                    return this.path1Model;
                }
                if (path == 2) {
                    return this.path2Model;
                }
                throw new IllegalArgumentException("Can only get path 1 or 2 (1-based)");
            }

            void removeTableRow() {
                int row = this.table.getSelectedRow();
                if (row >= 0) {
                    CDMAEditModel model = (CDMAEditModel)this.table.getModel();
                    model.deleteRow(row);
                    this.table.tableChanged(new TableModelEvent(model));
                }
            }

            void setModels(CDMAEditModel path1Model, CDMAEditModel path2Model) {
                if (this.path1Model != null && this.path2Model != null) {
                    this.path1Model.removeTableModelListener(this.tableModelListener);
                    this.path2Model.removeTableModelListener(this.tableModelListener);
                }
                if (path1Model != null && path2Model != null) {
                    path1Model.addTableModelListener(this.tableModelListener);
                    path2Model.addTableModelListener(this.tableModelListener);
                    this.path1Model = path1Model;
                    this.path2Model = path2Model;
                }
            }

            void setSelectedPathModel(int path) {
                if (path == 1) {
                    this.table.setModel(this.path1Model);
                } else if (path == 2) {
                    this.table.setModel(this.path2Model);
                } else {
                    throw new IllegalArgumentException("Can only set path to 1 or 2 (1-based)");
                }
            }
        }
    }
}

