/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.SeamcatTextFieldFormats;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.components.SpringUtilities;

public class CDMALinkLevelDataEditBasicsDialog
extends EscapeDialog {
    protected static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final IdentificationPanel idPanel = new IdentificationPanel();
    private final LinkTypePanel linkTypePanel = new LinkTypePanel();
    private final JFrame owner;
    private final PathCaptionPanel pathCaptionPanel = new PathCaptionPanel();

    public CDMALinkLevelDataEditBasicsDialog(JFrame owner) {
        super((Frame)owner, true);
        this.owner = owner;
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BoxLayout(dialogPanel, 3));
        dialogPanel.add(this.linkTypePanel);
        dialogPanel.add(this.idPanel);
        dialogPanel.add(this.pathCaptionPanel);
        this.getContentPane().add((Component)dialogPanel, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.setTitle(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_WINDOWTITLE"));
        this.pack();
        this.setResizable(false);
    }

    private void getFields(CDMALinkLevelData data) {
        this.linkTypePanel.getFields(data);
        this.idPanel.getFields(data);
        this.pathCaptionPanel.getFields(data);
    }

    private void setFields(CDMALinkLevelData data) {
        this.linkTypePanel.setFields(data);
        this.idPanel.setFields(data);
        this.pathCaptionPanel.setFields(data);
    }

    public boolean showDialog(CDMALinkLevelData data) {
        this.setLocationRelativeTo(this.owner);
        this.setAccept(false);
        this.setFields(data);
        this.setVisible(true);
        if (this.isAccept()) {
            this.getFields(data);
        }
        return this.isAccept();
    }

    private static class PathCaptionPanel
    extends JPanel {
        private final JTextField tf1Path = new JTextField(30);
        private final JTextField tf2Path = new JTextField(30);

        PathCaptionPanel() {
            super(new SpringLayout());
            this.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_1PATH")));
            this.add(this.tf1Path);
            this.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_2PATH")));
            this.add(this.tf2Path);
            this.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_PATHCAPTIONS")));
            SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 0, 0);
        }

        private void getFields(CDMALinkLevelData data) {
            data.setPathDescription(1, this.tf1Path.getText());
            data.setPathDescription(2, this.tf2Path.getText());
        }

        private void setFields(CDMALinkLevelData data) {
            String path1 = data.getPathDescription(1);
            String path2 = data.getPathDescription(2);
            this.tf1Path.setText(path1 != null ? path1 : "");
            this.tf2Path.setText(path2 != null ? path2 : "");
        }
    }

    private static class LinkTypePanel
    extends JPanel {
        private final JRadioButton jbDownlink = new JRadioButton(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_DOWNLOAD"));
        private final JRadioButton jbUplink = new JRadioButton(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_UPLINK"));

        LinkTypePanel() {
            super(new GridLayout(2, 1));
            ButtonGroup bgType = new ButtonGroup();
            bgType.add(this.jbUplink);
            bgType.add(this.jbDownlink);
            this.add(this.jbUplink);
            this.add(this.jbDownlink);
            this.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_LINKTYPE")));
        }

        private void getFields(CDMALinkLevelData data) {
            data.setLinkType(this.jbUplink.isSelected() ? CDMALinkLevelData.LinkType.UPLINK : CDMALinkLevelData.LinkType.DOWNLINK);
        }

        private void setFields(CDMALinkLevelData data) {
            switch (data.getLinkType()) {
                case UPLINK: {
                    this.jbUplink.doClick();
                    break;
                }
                case DOWNLINK: {
                    this.jbDownlink.doClick();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown link type");
                }
            }
        }
    }

    private class IdentificationPanel
    extends JPanel {
        private final JComboBox cbTargetType;
        private final JFormattedTextField tfFrequency;
        private final JTextField tfSource;
        private final JTextField tfSystem;
        private final JTextField tfTargetPct;

        IdentificationPanel() {
            super(new SpringLayout());
            this.cbTargetType = new JComboBox();
            this.tfFrequency = new CalculatorInputField();
            this.tfSource = new JTextField(30);
            this.tfSystem = new JTextField(30);
            this.tfTargetPct = new JTextField(5);
            this.tfSystem.addFocusListener(SeamcatTextFieldFormats.SELECTALL_FOCUSHANDLER);
            this.tfSource.addFocusListener(SeamcatTextFieldFormats.SELECTALL_FOCUSHANDLER);
            this.tfTargetPct.addFocusListener(SeamcatTextFieldFormats.SELECTALL_FOCUSHANDLER);
            for (CDMALinkLevelData.TargetERType t : CDMALinkLevelData.TargetERType.values()) {
                this.cbTargetType.addItem(t);
            }
            JPanel targetTypePanel = new JPanel(new FlowLayout(0));
            targetTypePanel.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_TARGETTYPE_1")));
            targetTypePanel.add(this.tfTargetPct);
            targetTypePanel.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_TARGETTYPE_2")));
            targetTypePanel.add(this.cbTargetType);
            this.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_SYSTEM")));
            this.add(this.tfSystem);
            this.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_SOURCE")));
            this.add(this.tfSource);
            this.add(new JLabel(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_FREQUENCY")));
            this.add(this.tfFrequency);
            this.add(targetTypePanel);
            this.setBorder(new TitledBorder(STRINGLIST.getString("LIBRARY_CDMA_LLD_BASICS_IDENTIFICATION")));
            SpringUtilities.makeCompactGrid(this, 7, 1, 0, 0, 0, 0);
        }

        private void getFields(CDMALinkLevelData data) {
            data.setSystem(this.tfSystem.getText());
            data.setSource(this.tfSource.getText());
            data.setFrequency(((Number)this.tfFrequency.getValue()).doubleValue());
            data.setTargetERpct(this.tfTargetPct.getText());
            data.setTargetERType((CDMALinkLevelData.TargetERType)((Object)this.cbTargetType.getSelectedItem()));
        }

        private void setFields(CDMALinkLevelData data) {
            this.tfSystem.setText(data.getSystem());
            this.tfSource.setText(data.getSource());
            this.tfFrequency.setValue(data.getFrequency());
            this.tfTargetPct.setText(data.getTargetERpct());
            this.cbTargetType.setSelectedItem((Object)data.getTargetERType());
        }
    }
}

