/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.model.systems.generic.TransmitterReceiverPathModel;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.JarFiles;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.components.GenericSelectionDialog;
import org.seamcat.presentation.components.SystemTree;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.library.LibraryDetailPanel;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.systems.SystemListItem;

public class SystemsPanel
extends JPanel {
    private JPanel detail = new JPanel(new BorderLayout());
    private LibraryDetailPanel<SystemListItem> detailPanel;
    private SystemTree systemTree;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JButton exportExport;
    private ChangeNotifier notifier;
    private WorkspaceView parent;
    private Workspace workspace;

    public SystemsPanel(final WorkspaceView parent, Workspace workspace) {
        this.parent = parent;
        this.workspace = workspace;
        this.notifier = new ChangeNotifier(){

            @Override
            public void changed() {
                SystemsPanel.this.updateModel();
                parent.updatePanels();
                SystemsPanel.this.systemTree.updateUI();
            }
        };
        this.systemTree = new SystemTree();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.systemTree);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.setupToolbar(), "North");
        leftPanel.add((Component)jScrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(leftPanel);
        splitPane.add(this.detail);
        splitPane.setDividerLocation(180);
        this.systemTree.setSelectionListener(new SystemTree.SelectionListener(){

            @Override
            public void selectionChanged(SystemListItem selected) {
                if (selected == null) {
                    SystemsPanel.this.detail.removeAll();
                    SystemsPanel.this.detail.add((Component)new JPanel(), "Center");
                } else {
                    SystemsPanel.this.updateModel();
                    SystemsPanel.this.showDetail();
                }
            }
        });
        this.systemTree.setContextMenuProvider(new SystemTree.ContextMenuProvider(){

            @Override
            public List<JMenuItem> contextMenuItems(SystemListItem system) {
                ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
                menuItems.addAll(SystemsPanel.this.systemTree.aggregateComponentMoveContextMenuItems(system));
                return menuItems;
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.refreshPluginsFromWorkspace();
        EventBusFactory.getEventBus().subscribe(this);
    }

    private void showDetail() {
        SystemListItem item = this.systemTree.getSelectedSystem();
        this.detailPanel = new LibraryDetailPanel<SystemListItem>(MainWindow.getInstance(), SystemListItem.class, new LibraryItemWrapper<SystemListItem>(item), this.notifier, false);
        this.handleEnablement();
        this.detail.removeAll();
        this.detail.add(this.detailPanel, "Center");
        this.detail.revalidate();
        this.detail.repaint();
    }

    private JToolBar setupToolbar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFocusable(false);
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        JButton button = ToolBar.button("SEAMCAT_ICON_IMPORT_LIBRARY", "TOOLBAR_SYSTEMS_PANEL_IMPORT");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemsPanel.this.handleImport();
            }
        });
        toolBar.add(button);
        this.exportExport = ToolBar.button("SEAMCAT_ICON_EXPORT_LIBRARY", "TOOLBAR_SYSTEMS_PANEL_EXPORT");
        this.exportExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemsPanel.this.handleExport();
            }
        });
        toolBar.add(this.exportExport);
        this.duplicateButton = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "TOOLBAR_LIBRARY_DUPLICATE_TOOLTIP");
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemsPanel.this.handleDuplicate();
            }
        });
        toolBar.add(this.duplicateButton);
        this.deleteButton = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_LIBRARY_DELETE_TOOLTIP");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemsPanel.this.handleDelete();
            }
        });
        toolBar.add(this.deleteButton);
        toolBar.addSeparator();
        toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand("http://confluence.seamcat.org/display/SH/2.4.1+Scenario+workspace")));
        return toolBar;
    }

    private void updateButton() {
        boolean someSelected = this.systemTree.getSelectedSystem() != null;
        this.duplicateButton.setEnabled(someSelected);
        this.deleteButton.setEnabled(someSelected);
        this.exportExport.setEnabled(someSelected);
    }

    private void refreshPluginsFromWorkspace() {
        this.detailPanel = null;
        ArrayList<SystemListItem> systemListItems = new ArrayList<SystemListItem>();
        for (SystemPlugin plugin : this.workspace.getSystemPlugins()) {
            Object ui = plugin.getUI();
            if (ui == null) {
                ui = ProxyHelper.newComposite(GenericTypeMarshaller.getPluginUIClass(plugin));
                plugin.setUI(ui);
            }
            systemListItems.add(new SystemListItem(plugin));
        }
        this.systemTree.setSystems(systemListItems);
        this.updateButton();
    }

    private void updatePluginsInWorkspace() {
        List<SystemPlugin> workspacePluginList = this.workspace.getSystemPlugins();
        workspacePluginList.clear();
        for (SystemListItem system : this.systemTree.getSystems()) {
            workspacePluginList.add(system.getSystemPlugin());
        }
    }

    private void handleImport() {
        SystemPluginConfiguration selected;
        SystemPlugin plugin;
        List<SystemPluginConfiguration> group = Model.getInstance().getLibrary().getGroup(SystemPluginConfiguration.class);
        ArrayList<SystemModel> models = new ArrayList<SystemModel>();
        for (SystemPluginConfiguration conf : group) {
            models.add(conf.configuration());
        }
        GenericSelectionDialog dialog = new GenericSelectionDialog(MainWindow.getInstance(), "Select library system", models, false);
        if (dialog.display() && (plugin = JarFiles.instance(selected = group.get(dialog.getSelectedIndex()))) != null) {
            this.updateModel();
            this.systemTree.addSystem(new SystemListItem(plugin));
            this.updatePluginsInWorkspace();
            this.parent.updatePanels();
        }
    }

    private void handleExport() {
        Object model = this.detailPanel.getModel().getSystemPlugin().getUI();
        String jarId = JarFiles.getJarId(this.detailPanel.getModel().getSystemPlugin());
        SystemPluginConfiguration prototype = Factory.prototype(SystemPluginConfiguration.class);
        Factory.when(prototype.configuration()).thenReturn((SystemModel)model);
        Factory.when(prototype.location()).thenReturn(jarId);
        Factory.when(prototype.classname()).thenReturn(this.detailPanel.getModel().getSystemPlugin().getClass().getName());
        SystemPluginConfiguration conf = Factory.build(prototype);
        if (!Model.getInstance().getLibrary().addSystem(conf)) {
            if (DialogHelper.overrideInLibrary(this.parent, model.description().name())) {
                Model.getInstance().getLibrary().replaceNamedSystem(conf);
                Model.getInstance().persist();
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in system library", model.description().name())));
            }
        } else {
            Model.getInstance().persist();
            EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to system library", model.description().name())));
        }
    }

    private void handleDuplicate() {
        this.updateModel();
        SystemListItem selectedSystem = this.systemTree.getSelectedSystem();
        if (selectedSystem != null) {
            this.systemTree.duplicateSystem(selectedSystem);
            this.updatePluginsInWorkspace();
            this.parent.updatePanels();
        }
    }

    private void handleDelete() {
        SystemListItem selectedSystem = this.systemTree.getSelectedSystem();
        if (SystemsPanel.isSystemOrComponentsReferencedFromWorkspace(selectedSystem, this.workspace)) {
            DialogHelper.cannotDeleteUsedSystem(selectedSystem.getSystemPlugin().getUI().description().name());
        } else {
            this.systemTree.deleteSystem(selectedSystem);
            this.updatePluginsInWorkspace();
            this.parent.updatePanels();
        }
    }

    private void handleAddComponentToAggregate(SystemListItem aggregateListItem) {
        SystemListItem systemToAdd;
        ArrayList<SystemListItem> systems = new ArrayList<SystemListItem>();
        for (SystemListItem system : this.systemTree.getSystems()) {
            if (system.getSystemPlugin() instanceof AggregateSystemPlugin) continue;
            systems.add(system);
        }
        GenericSelectionDialog dialog = new GenericSelectionDialog(MainWindow.getInstance(), "Select system to move to aggregate", systems, false);
        if (dialog.display() && (systemToAdd = (SystemListItem)dialog.getSelectedValue()) != null) {
            this.systemTree.deleteSystem(systemToAdd);
            this.systemTree.addComponentToAggregate(aggregateListItem, systemToAdd);
            this.updatePluginsInWorkspace();
            this.parent.updatePanels();
        }
    }

    private static boolean isSystemOrComponentsReferencedFromWorkspace(SystemListItem system, Workspace workspace) {
        SystemPlugin systemPlugin = system.getSystemPlugin();
        if (SystemsPanel.isSystemPluginReferencedFromWorkspace(systemPlugin, workspace)) {
            return true;
        }
        if (systemPlugin instanceof AggregateSystemPlugin) {
            for (SystemPlugin componentPlugin : ((AggregateSystemPlugin)systemPlugin).getComponents()) {
                if (!SystemsPanel.isSystemPluginReferencedFromWorkspace(componentPlugin, workspace)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSystemPluginReferencedFromWorkspace(SystemPlugin<?> system, Workspace workspace) {
        if (workspace.getVictimSystemId().equals(system.getUI().id())) {
            return true;
        }
        for (InterferenceLinkElement element : workspace.getInterferenceLinkUIs()) {
            if (!element.getInterferingSystemId().equals(system.getUI().id())) continue;
            return true;
        }
        return false;
    }

    public void updateModel() {
        if (this.detailPanel != null) {
            this.detailPanel.getModel();
        }
    }

    public void handleEnablement() {
        Object model = this.detailPanel.getModel().getSystemPlugin().getUI();
        if (model instanceof SystemModelGeneric) {
            TransmitterReceiverPathModel path = ((SystemModelGeneric)model).path();
            boolean corrEnabled = path.relativeLocation().useCorrelatedDistance();
            Component component = this.detailPanel.getComponent();
            if (component instanceof CompositeEditor) {
                ((CompositeEditor)component).enableWidget(CoverageRadius.class, !corrEnabled);
            }
        }
    }

    @UIEventHandler
    public void handle(TextWidgetValueUpdatedEvent event) {
        Object context = event.getContext();
        if (context instanceof Class && SystemModel.class.isAssignableFrom((Class)context)) {
            this.detailPanel.getModel();
        }
    }
}

