/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.CognitiveRadioSettingChangedEvent;
import org.seamcat.events.CorrelatedDistanceSettingChangedEvent;
import org.seamcat.events.SimulationCompleteEvent;
import org.seamcat.events.SimulationStartedEvent;
import org.seamcat.model.Workspace;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.DistributionItem;
import org.seamcat.presentation.genericgui.item.IntegerItem;
import org.seamcat.presentation.genericgui.item.ItemChanged;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.report.ReportDialog;
import org.seamcat.presentation.systems.InterferenceLinksPanel;
import org.seamcat.presentation.systems.SystemListItem;
import org.seamcat.presentation.systems.SystemsPanel;

public class ScenarioPanel
extends JPanel {
    private final JComboBox<SystemListItem> victimSelector;
    private final DefaultComboBoxModel<SystemListItem> model;
    private final JButton run;
    private final JButton reportWorkspace;
    private final JButton checkConsistency;
    private DistributionItem frequency;
    private IntegerItem events;
    private BooleanItem debug;
    private InterferenceLinksPanel interferenceLinksPanel;
    private SystemsPanel systems;
    private Workspace workspace;
    private JPanel victimPanel;
    private ActionListener victimListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScenarioPanel.this.systems.updateModel();
            SystemListItem item = (SystemListItem)ScenarioPanel.this.model.getSelectedItem();
            if (item != null) {
                ScenarioPanel.this.workspace.setVictimSystemId(item.getSystemPlugin().getUI().id());
                SystemPlugin victimSystem = ScenarioPanel.this.workspace.getVictimSystem();
                Object ui = victimSystem.getUI();
                ScenarioPanel.this.workspace.setVictimFrequency(ui.general().frequency());
                ScenarioPanel.this.selectVictimSystem(ui);
            }
            ScenarioPanel.this.interferenceLinksPanel.refreshFromModel();
        }
    };

    public ScenarioPanel(SystemsPanel systems, Workspace workspace, final WorkspaceView view) {
        super(new BorderLayout());
        this.systems = systems;
        this.workspace = workspace;
        JSplitPane topContainer = new JSplitPane(1);
        topContainer.setDividerLocation(900);
        JPanel controlPanel = new JPanel(new FlowLayout(0));
        this.victimPanel = new JPanel(new FlowLayout(0));
        this.victimSelector = new JComboBox();
        this.model = new DefaultComboBoxModel();
        this.setSelectionModel();
        this.victimSelector.setModel(this.model);
        this.victimPanel.add(this.victimSelector);
        String[] distributionEnabled = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"};
        this.frequency = new DistributionItem(MainWindow.getInstance(), distributionEnabled).label("Frequency").unit("MHz");
        this.frequency.information("Frequency used in the simulation for the victim system");
        GenericPanel fPanel = new GenericPanel();
        fPanel.addItem(this.frequency);
        fPanel.initializeWidgets();
        this.victimPanel.add(fPanel);
        this.events = new IntegerItem().label("Number of events");
        GenericPanel ePanel = new GenericPanel();
        ePanel.addItem(this.events);
        ePanel.initializeWidgets();
        controlPanel.add(ePanel);
        this.debug = new BooleanItem().label("Run in debug mode");
        GenericPanel dPanel = new GenericPanel();
        dPanel.addItem(this.debug);
        dPanel.initializeWidgets();
        controlPanel.add(dPanel);
        this.run = ToolBar.button("SEAMCAT_ICON_SIMULATION_START", "MENU_ITEM_TEXT_RUN_EGE");
        this.run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (view.okToSimulate()) {
                        MainWindow.getInstance().run(view);
                    }
                }
                catch (RuntimeException ee) {
                    DialogHelper.simulationAborted(ee.getMessage());
                    ee.printStackTrace();
                }
            }
        });
        controlPanel.add(this.run);
        this.reportWorkspace = ToolBar.button("SEAMCAT_ICON_GENERATE_REPORT", "MENU_ITEM_TEXT_REPORT");
        this.reportWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog dialog = new ReportDialog();
                view.updateModel();
                dialog.setReportSource(view.getWorkspace());
                dialog.setVisible(true);
            }
        });
        controlPanel.add(this.reportWorkspace);
        this.checkConsistency = ToolBar.button("SEAMCAT_ICON_CHECK_CONSISTENCY", "MENU_ITEM_TEXT_CHECK_CONSISTENCY");
        this.checkConsistency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.consistencyCheck();
            }
        });
        controlPanel.add(this.checkConsistency);
        topContainer.add(new BorderPanel(new JScrollPane(this.victimPanel), "Victim System"));
        topContainer.add(new BorderPanel(new JScrollPane(controlPanel), "Simulation Control"));
        this.add((Component)topContainer, "North");
        this.interferenceLinksPanel = new InterferenceLinksPanel(workspace, systems);
        this.add((Component)new BorderPanel(this.interferenceLinksPanel, "Interfering System Links"), "Center");
        this.setSimulationControl(workspace.getSimulationControl());
        this.refreshFromModel();
    }

    public void register() {
        this.interferenceLinksPanel.register();
        this.victimSelector.addActionListener(this.victimListener);
        this.frequency.addItemChangedHandler(new ItemChanged<AbstractDistribution>(){

            @Override
            public void itemChanged(AbstractDistribution value) {
                ScenarioPanel.this.workspace.setVictimFrequency(value);
            }
        });
        this.debug.getValueWidget().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ScenarioPanel.this.debug.getValue().booleanValue()) {
                    ScenarioPanel.this.events.setValue(5);
                } else {
                    ScenarioPanel.this.events.setValue(20000);
                }
            }
        });
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handle(SimulationCompleteEvent event) {
        this.run.setEnabled(true);
        this.reportWorkspace.setEnabled(true);
        this.checkConsistency.setEnabled(true);
    }

    @UIEventHandler
    public void handle(SimulationStartedEvent event) {
        this.run.setEnabled(false);
        this.reportWorkspace.setEnabled(false);
        this.checkConsistency.setEnabled(false);
    }

    @UIEventHandler
    public void handle(CorrelatedDistanceSettingChangedEvent changed) {
        this.systems.updateModel();
        this.systems.handleEnablement();
    }

    @UIEventHandler
    public void handle(CognitiveRadioSettingChangedEvent changed) {
        this.systems.updateModel();
        this.interferenceLinksPanel.handleEnablement();
    }

    private void setSelectionModel() {
        this.model.removeAllElements();
        String id = this.workspace.getVictimSystemId();
        SystemListItem victim = null;
        for (SystemPlugin system : this.workspace.getSystemPluginsRecursive()) {
            if (system instanceof AggregateSystemPlugin) continue;
            String systemPathName = this.workspace.getSystemPluginPathName(system);
            SystemListItem item = new SystemListItem(system, systemPathName);
            if (system.getUI().id().equals(id)) {
                victim = item;
            }
            this.model.addElement(item);
        }
        if (victim != null) {
            this.model.setSelectedItem(victim);
        }
    }

    private void selectVictimSystem(SystemModel victim) {
        this.frequency.setValue((AbstractDistribution)victim.general().frequency());
    }

    private void setSimulationControl(SimulationControl control) {
        this.events.setValue(control.numberOfEvents());
        this.debug.setValue(control.debugMode());
    }

    public SimulationControl getSimulationControl() {
        SimulationControl prototype = Factory.prototype(SimulationControl.class);
        Factory.when(prototype.numberOfEvents()).thenReturn(this.events.getValue());
        Factory.when(prototype.debugMode()).thenReturn(this.debug.getValue());
        return Factory.build(prototype);
    }

    public void updateModel() {
        this.workspace.setSimulationControl(this.getSimulationControl());
        SystemListItem selectedItem = (SystemListItem)this.victimSelector.getSelectedItem();
        this.interferenceLinksPanel.updateModel();
        this.workspace.setVictimSystemId(selectedItem.getSystemPlugin().getUI().id());
    }

    public void refreshFromModel() {
        this.setSelectionModel();
        this.frequency.setValue((AbstractDistribution)this.workspace.getVictimFrequency());
        this.interferenceLinksPanel.refreshFromModel();
    }
}

