/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.CorrelationModelChanged;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.Distributions;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.model.workspace.InterferenceLinkPathUI;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.GenericSelectionDialog;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.DistributionItem;
import org.seamcat.presentation.genericgui.item.Item;
import org.seamcat.presentation.genericgui.item.ItemChanged;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.multiple.GenerateMultipleInterferersDialog;
import org.seamcat.presentation.systems.SystemListItem;
import org.seamcat.presentation.systems.SystemsPanel;
import org.seamcat.presentation.systems.correlation.CorrelationModePanel;

public class InterferenceLinksPanel
extends JPanel {
    private Workspace workspace;
    private List<InterferenceLinkElement> model;
    private SystemsPanel systemsPanel;
    public int indexDeleted;
    private JPanel detail = new JPanel(new BorderLayout());
    private DefaultListModel listModel;
    private JList list;
    private JToolBar toolBar;
    private JButton delete;
    private JPanel frequencySelector = new JPanel(new GridLayout(1, 2));
    private JComponent detailPanel;
    private Integer panelIndex;
    private ListSelectionListener listListener;
    private KeyListener keyListener;
    private CorrelationModePanel correlationUI;
    private PluginConfigurationPanel pluginUI;
    private DistributionItem frequency;

    public InterferenceLinksPanel(Workspace workspace, SystemsPanel systemsPanel) {
        this.workspace = workspace;
        this.model = workspace.getInterferenceLinkUIs();
        this.systemsPanel = systemsPanel;
        this.toolBar = new JToolBar();
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.setupToolbar();
        this.list = new JList();
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.list);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)jScrollPane, "Center");
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(leftPanel);
        splitPane.add(this.detail);
        splitPane.setDividerLocation(200);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.frequency = new DistributionItem(MainWindow.getInstance(), Distributions.ALL).label("Frequency").unit("MHz");
        this.frequency.information("Frequency used in the simulation for the selected interfering system");
        this.frequency.initialize();
        this.refreshFromModel();
    }

    public void register() {
        this.frequency.addItemChangedHandler(new ItemChanged<AbstractDistribution>(){

            @Override
            public void itemChanged(AbstractDistribution value) {
                int index = InterferenceLinksPanel.this.list.getSelectedIndex();
                InterferenceLinksPanel.this.workspace.getInterferingLinkFrequency().set(index, value);
            }
        });
        this.listListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!InterferenceLinksPanel.this.listModel.isEmpty()) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (InterferenceLinksPanel.this.list.getSelectedIndex() != -1) {
                        InterferenceLinksPanel.this.updateModel();
                        InterferenceLinksPanel.this.detail((InterferenceLinkElement)InterferenceLinksPanel.this.model.get(InterferenceLinksPanel.this.list.getSelectedIndex()), InterferenceLinksPanel.this.list.getSelectedIndex());
                    }
                }
            }
        };
        this.list.addListSelectionListener(this.listListener);
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    InterferenceLinksPanel.this.deleteCurrentlySelectedInterferenceLink();
                }
            }
        };
        this.list.addKeyListener(this.keyListener);
        Subscriber.subscribe(this);
    }

    public void dispose() {
        this.list.removeListSelectionListener(this.listListener);
        this.list.removeKeyListener(this.keyListener);
        this.toolBar.removeAll();
        EventBusFactory.getEventBus().unsubscribe(this);
    }

    private void setupToolbar() {
        JButton button = ToolBar.button("SEAMCAT_ICON_ADD", "TOOLBAR_INTERFERING_LINKS_ADD_TOOLTIP");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterferenceLinksPanel.this.handleAddInterferenceLink();
            }
        });
        this.toolBar.add(button);
        button = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "TOOLBAR_INTERFERING_LINKS_DUPLICATE_TOOLTIP");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterferenceLinksPanel.this.handleDupInterferenceLink();
            }
        });
        this.toolBar.add(button);
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_INTERFERING_LINKS_DELETE_TOOLTIP");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterferenceLinksPanel.this.deleteCurrentlySelectedInterferenceLink();
            }
        });
        this.toolBar.add(this.delete);
        JButton multiple = ToolBar.button("SEAMCAT_ICON_GENERATE_MULTIPLE", "TOOLBAR_INTERFERING_LINKS_MULTIPLE_TOOLTIP");
        multiple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterferenceLinksPanel.this.updateModel();
                GenerateMultipleInterferersDialog dialog = new GenerateMultipleInterferersDialog(MainWindow.getInstance());
                dialog.setModel(InterferenceLinksPanel.this.workspace);
                List<InterferenceLinkElement> added = dialog.getAdded();
                if (added != null) {
                    InterferenceLinksPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (InterferenceLinkElement elm : added) {
                        elm.setName(InterferenceLinksPanel.getILName(InterferenceLinksPanel.this.workspace.getInterferenceLinkUIs().size(), InterferenceLinksPanel.this.workspace.getSystemPlugin(elm.getInterferingSystemId()), InterferenceLinksPanel.this.workspace));
                        InterferenceLinksPanel.this.workspace.addInterferenceLink(elm, InterferenceLinksPanel.this.workspace.getInterferingLinkFrequency().get(dialog.getSelectedIndex()));
                    }
                    InterferenceLinksPanel.this.refreshFromModel();
                    InterferenceLinksPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.toolBar.add(multiple);
        JButton setSystem = ToolBar.button("SEAMCAT_ICON_IMPORT_LIBRARY", "TOOLBAR_INTERFERING_LINKS_IMPORT");
        setSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InterferenceLinksPanel.this.handleImport();
            }
        });
        this.toolBar.add(setSystem);
        this.toolBar.addSeparator();
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand("http://confluence.seamcat.org/display/SH/10.2.1+Generation+of+multiple+interferer+links+with+different+systems")));
    }

    private void detail(InterferenceLinkElement link, int index) {
        if (this.detailPanel != null) {
            Subscriber.unSubscribeDeep(this.detailPanel);
        }
        this.detail.removeAll();
        JTabbedPane pane = new JTabbedPane();
        JSplitPane split = new JSplitPane(1);
        pane.addTab("Interfering Link Transmitter to Victim Link Receiver Path", null, split, CompositeEditor.replaceIMG("<html>Interference Link<br>{$IMG=v5_interfering_link.png}</html>"));
        this.correlationUI = new CorrelationModePanel(this.workspace, link);
        split.add(this.correlationUI);
        this.pluginUI = new PluginConfigurationPanel(MainWindow.getInstance(), link.getSettings().path().propagationModel(), false, PropagationModelConfiguration.class);
        split.add(new ScrollingBorderPanel(this.pluginUI, "Propagation Model"));
        this.detailPanel = pane;
        this.handleEnablement();
        this.panelIndex = index;
        JPanel interferer = new JPanel(new FlowLayout(0));
        interferer.add(Box.createHorizontalStrut(5));
        interferer.add(this.single(this.frequency));
        this.frequency.setValue((AbstractDistribution)this.workspace.getInterferingLinkFrequency().get(index));
        this.frequencySelector.removeAll();
        this.frequencySelector.add(interferer);
        this.detail.add((Component)this.frequencySelector, "North");
        this.detail.add((Component)this.detailPanel, "Center");
        this.detail.revalidate();
        this.detail.repaint();
    }

    @UIEventHandler
    public void handle(CorrelationModelChanged changed) {
        this.handleEnablement();
    }

    public void handleEnablement() {
        Object victim = this.workspace.getVictimSystem().getUI();
        int index = this.list.getSelectedIndex();
        Object interferer = this.workspace.getSystemPlugin(this.workspace.getInterferenceLinkUIs().get(index).getInterferingSystemId()).getUI();
        boolean crMode = this.cr((SystemModel)victim, (SystemModel)interferer);
        this.frequency.setRelevant(!crMode);
    }

    private boolean cr(SystemModel victim, SystemModel interferer) {
        return victim instanceof SystemModelGeneric && interferer instanceof SystemModelGeneric && ((SystemModelGeneric)interferer).transmitter().emissionCharacteristics().cognitiveRadio();
    }

    private GenericPanel single(Item item) {
        GenericPanel gp = new GenericPanel();
        gp.addItem(item);
        gp.initializeWidgets();
        return gp;
    }

    public void refreshFromModel() {
        this.listModel.clear();
        for (int i = 0; i < this.model.size(); ++i) {
            InterferenceLinkElement link = this.model.get(i);
            link.setName(InterferenceLinksPanel.getILName(i + 1, this.workspace.getSystemPlugin(link.getInterferingSystemId()), this.workspace));
            this.listModel.addElement(link.getName());
        }
        this.updateButton();
        int index = 0;
        if (this.panelIndex != null) {
            index = this.panelIndex;
        }
        this.list.setSelectedIndex(index);
        String[] distributionEnabled = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"};
        this.frequency.setDistributionEnabled(distributionEnabled);
        this.frequency.setValue((AbstractDistribution)this.workspace.getInterferingLinkFrequency().get(index));
        this.detail(this.model.get(this.list.getSelectedIndex()), this.list.getSelectedIndex());
        this.handleEnablement();
    }

    private void updateButton() {
        this.delete.setEnabled(this.listModel.size() > 1);
    }

    public void updateModel() {
        if (this.panelIndex != null) {
            int index = this.panelIndex;
            InterferenceLinkElement link = this.model.get(index);
            this.model.set(index, new InterferenceLinkElement(link.getId(), link.getInterferingSystemId(), link.getName(), this.getModel()));
        }
    }

    private void handleImport() {
        List<SystemPlugin> systemModels = this.workspace.getSystemPluginsRecursive();
        ArrayList<SystemListItem> items = new ArrayList<SystemListItem>();
        for (SystemPlugin model : systemModels) {
            if (model instanceof AggregateSystemPlugin) continue;
            items.add(new SystemListItem(model, this.workspace.getSystemPluginPathName(model)));
        }
        GenericSelectionDialog dialog = new GenericSelectionDialog(MainWindow.getInstance(), "Select interfering system TEST2", items, false);
        if (dialog.display()) {
            SystemListItem selectedValue = (SystemListItem)dialog.getSelectedValue();
            int index = dialog.getSelectedIndex();
            String name = InterferenceLinksPanel.getILName(index + 1, selectedValue.getSystemPlugin(), this.workspace);
            int selectedIndex = this.list.getSelectedIndex();
            this.panelIndex = selectedIndex;
            this.model.set(selectedIndex, new InterferenceLinkElement(selectedValue.getSystemPlugin().getUI().id(), name, this.getModel()));
            Object system = selectedValue.getSystemPlugin().getUI();
            this.workspace.getInterferingLinkFrequency().set(selectedIndex, system.general().frequency());
            this.refreshFromModel();
        }
    }

    private void handleAddInterferenceLink() {
        this.systemsPanel.updateModel();
        this.updateModel();
        List<SystemPlugin> systemModels = this.workspace.getSystemPluginsRecursive();
        int size = this.model.size();
        if (systemModels.size() == 1) {
            SystemPlugin selected = systemModels.get(0);
            String name = InterferenceLinksPanel.getILName(size + 1, selected, this.workspace);
            InterferenceLinkElement element = new InterferenceLinkElement(this.model.get(0).getInterferingSystemId(), name, ProxyHelper.newComposite(InterferenceLinkUI.class));
            this.workspace.addInterferenceLink(element, selected.getUI().general().frequency());
            this.model = this.workspace.getInterferenceLinkUIs();
            this.listModel.addElement(name);
            this.list.setSelectedIndex(this.listModel.getSize() - 1);
        } else {
            ArrayList<SystemListItem> items = new ArrayList<SystemListItem>();
            for (SystemPlugin model : systemModels) {
                if (model instanceof AggregateSystemPlugin) continue;
                items.add(new SystemListItem(model, this.workspace.getSystemPluginPathName(model)));
            }
            GenericSelectionDialog dialog = new GenericSelectionDialog(MainWindow.getInstance(), "Select interfering system", items, false);
            if (dialog.display()) {
                SystemListItem selectedValue = (SystemListItem)dialog.getSelectedValue();
                SystemPlugin selected = selectedValue.getSystemPlugin();
                String name = InterferenceLinksPanel.getILName(size + 1, selectedValue.getSystemPlugin(), this.workspace);
                InterferenceLinkElement element = new InterferenceLinkElement(selectedValue.getSystemPlugin().getUI().id(), name, ProxyHelper.newComposite(InterferenceLinkUI.class));
                this.workspace.addInterferenceLink(element, selected.getUI().general().frequency());
                this.model = this.workspace.getInterferenceLinkUIs();
                this.listModel.addElement(name);
                this.list.setSelectedIndex(this.listModel.getSize() - 1);
            }
        }
        this.updateButton();
    }

    private InterferenceLinkUI getModel() {
        CorrelationSettingsUI model = this.correlationUI.getModel();
        PropagationModel pm = (PropagationModel)this.pluginUI.getModel();
        InterferenceLinkUI ui = Factory.prototype(InterferenceLinkUI.class);
        InterferenceLinkPathUI path = Factory.prototype(InterferenceLinkPathUI.class);
        Factory.when(path.correlationSettings()).thenReturn(model);
        Factory.when(path.propagationModel()).thenReturn(pm);
        Factory.when(ui.path()).thenReturn(Factory.build(path));
        return Factory.build(ui);
    }

    public static String getILName(int number, SystemPlugin interferer, Workspace workspace) {
        String pathName = workspace.getSystemPluginPathName(interferer);
        return "Link " + number + " (" + pathName + ")";
    }

    public void handleDupInterferenceLink() {
        InterferenceLinkElement link = this.model.get(this.list.getSelectedIndex());
        SystemPlugin system = this.workspace.getSystemPlugin(link.getInterferingSystemId());
        String name = InterferenceLinksPanel.getILName(this.model.size() + 1, system, this.workspace);
        InterferenceLinkElement dup = new InterferenceLinkElement(link.getInterferingSystemId(), name, this.getModel());
        this.workspace.addInterferenceLink(dup, this.frequency.getValue());
        this.model = this.workspace.getInterferenceLinkUIs();
        this.listModel.addElement(name);
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
        this.updateButton();
    }

    private void deleteCurrentlySelectedInterferenceLink() {
        this.detailPanel = null;
        this.panelIndex = null;
        this.indexDeleted = this.list.getSelectedIndex();
        if (this.listModel.size() <= 1) {
            return;
        }
        this.listModel.removeElementAt(this.indexDeleted);
        this.model.remove(this.indexDeleted);
        this.workspace.getInterferingLinkFrequency().remove(this.indexDeleted);
        this.updateButton();
        if (this.list.getModel().getSize() == this.indexDeleted) {
            this.list.setSelectedIndex(this.indexDeleted - 1);
        } else {
            this.list.setSelectedIndex(this.indexDeleted);
        }
        this.refreshFromModel();
    }
}

