/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.model.factory.Factory;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.presentation.systems.CellularPositionHolder;
import org.seamcat.presentation.systems.CellularPositionPanel;
import org.seamcat.presentation.systems.ReferenceCellSelector;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class DMAPositioningSystemPanel
extends JPanel {
    private static DecimalFormat numberFormat = new DecimalFormat("0.0##");
    private JLabel baseStationCountValueLabel;
    private JLabel bs2bsDistanceValueLabel;
    private JRadioButton omniDirectionalCellsRadioButton;
    private JRadioButton triSectorCells_3GGP_RadioButton;
    private JRadioButton triSectorCells_3GGP2_RadioButton;
    private JRadioButton twoTiersRadioButton;
    private JRadioButton oneTierRadioButton;
    private JRadioButton singleCellRadioButton;
    private CalculatorInputField cellRadiusInputField;
    private JPanel innerPanel;
    private CellularPositionPanel.Refresher refresher;
    private CellularPositionHolder cellularPositionHolder;

    public void setModel(CellularPositionHolder cellularPositionHolder) {
        this.cellularPositionHolder = cellularPositionHolder;
        this.refreshFromModel();
    }

    public CellularPositionHolder getModel() {
        return this.cellularPositionHolder;
    }

    public DMAPositioningSystemPanel(CellularPositionPanel.Refresher refresher) {
        this.refresher = refresher;
        this.init();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.innerPanel);
    }

    public void init() {
        this.innerPanel = new JPanel();
        JLabel baseStationCountLabel = new JLabel("Number of base stations in the system ");
        this.baseStationCountValueLabel = new JLabel();
        this.baseStationCountValueLabel.setHorizontalTextPosition(4);
        this.baseStationCountValueLabel.setHorizontalAlignment(4);
        JLabel labelCellLayout = new JLabel("Cell layout");
        JLabel cellRadiusLabel = new JLabel("Cell radius");
        this.cellRadiusInputField = new CalculatorInputField();
        JLabel cellRadiusUnitLabel = new JLabel("km");
        JLabel bs2bsDistanceLabel = new JLabel("BS to BS distance ");
        this.bs2bsDistanceValueLabel = new JLabel();
        this.bs2bsDistanceValueLabel.setHorizontalTextPosition(4);
        this.bs2bsDistanceValueLabel.setHorizontalAlignment(4);
        JLabel bs2bsDistanceUnitLabel = new JLabel("km");
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.add((Component)baseStationCountLabel, this.makeGridConstraint(0, 0, 2, 1));
        this.innerPanel.add((Component)this.baseStationCountValueLabel, this.makeGridConstraint(2, 0));
        this.innerPanel.add(Box.createVerticalStrut(4), this.makeGridConstraint(0, 1));
        this.innerPanel.add((Component)labelCellLayout, this.makeGridConstraint(0, 2));
        GridBagConstraints radioButtonPanelLayout = this.makeGridConstraint(1, 2, 2, 1);
        radioButtonPanelLayout.anchor = 768;
        this.innerPanel.add(this.makeRadioButtonPanel(), radioButtonPanelLayout);
        this.innerPanel.add(Box.createVerticalStrut(4), this.makeGridConstraint(0, 3));
        this.innerPanel.add((Component)cellRadiusLabel, this.makeGridConstraint(0, 4));
        GridBagConstraints cellRadiusInputFieldLayout = this.makeGridConstraint(1, 4);
        cellRadiusInputFieldLayout.anchor = 768;
        this.innerPanel.add((Component)this.cellRadiusInputField, cellRadiusInputFieldLayout);
        this.innerPanel.add((Component)cellRadiusUnitLabel, this.makeGridConstraint(2, 4));
        this.innerPanel.add((Component)bs2bsDistanceLabel, this.makeGridConstraint(0, 5));
        this.innerPanel.add((Component)this.bs2bsDistanceValueLabel, this.makeGridConstraint(1, 5));
        this.innerPanel.add((Component)bs2bsDistanceUnitLabel, this.makeGridConstraint(2, 5));
        this.innerPanel.add(Box.createVerticalGlue(), this.makeExpandingVSpaceGridConstraint(0, 6));
        this.cellRadiusInputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DMAPositioningSystemPanel.this.updateModel();
            }
        });
        ActionListener cellLayoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMAPositioningSystemPanel.this.updateModel();
            }
        };
        this.omniDirectionalCellsRadioButton.addActionListener(cellLayoutListener);
        this.triSectorCells_3GGP_RadioButton.addActionListener(cellLayoutListener);
        this.triSectorCells_3GGP2_RadioButton.addActionListener(cellLayoutListener);
        this.twoTiersRadioButton.addActionListener(cellLayoutListener);
        this.oneTierRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DMAPositioningSystemPanel.this.oneTierRadioButton.isSelected()) {
                    DMAPositioningSystemPanel.this.localUpdate();
                    DMAPositioningSystemPanel.this.updateModel();
                }
            }
        });
        this.singleCellRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DMAPositioningSystemPanel.this.singleCellRadioButton.isSelected()) {
                    DMAPositioningSystemPanel.this.localUpdate();
                    DMAPositioningSystemPanel.this.updateModel();
                }
            }
        });
    }

    private Component makeRadioButtonPanel() {
        this.omniDirectionalCellsRadioButton = new JRadioButton("Single-Sector");
        this.triSectorCells_3GGP_RadioButton = new JRadioButton("Tri-Sector (3GPP)");
        this.triSectorCells_3GGP2_RadioButton = new JRadioButton("Tri-Sector (3GPP2)");
        this.twoTiersRadioButton = new JRadioButton("2-tiers");
        this.oneTierRadioButton = new JRadioButton("1-tier");
        this.singleCellRadioButton = new JRadioButton("Single cell");
        ButtonGroup cellLayoutButtonGroup = new ButtonGroup();
        cellLayoutButtonGroup.add(this.omniDirectionalCellsRadioButton);
        cellLayoutButtonGroup.add(this.triSectorCells_3GGP_RadioButton);
        cellLayoutButtonGroup.add(this.triSectorCells_3GGP2_RadioButton);
        ButtonGroup tierButtonGroup = new ButtonGroup();
        tierButtonGroup.add(this.twoTiersRadioButton);
        tierButtonGroup.add(this.oneTierRadioButton);
        tierButtonGroup.add(this.singleCellRadioButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.twoTiersRadioButton, this.makeGridConstraint(0, 0));
        panel.add((Component)this.oneTierRadioButton, this.makeGridConstraint(0, 1));
        panel.add((Component)this.singleCellRadioButton, this.makeGridConstraint(0, 2));
        panel.add((Component)this.omniDirectionalCellsRadioButton, this.makeGridConstraint(1, 0));
        panel.add((Component)this.triSectorCells_3GGP_RadioButton, this.makeGridConstraint(1, 1));
        panel.add((Component)this.triSectorCells_3GGP2_RadioButton, this.makeGridConstraint(1, 2));
        return panel;
    }

    protected GridBagConstraints makeGridConstraint(int col, int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = col;
        constraints.gridy = row;
        constraints.anchor = 512;
        if (col == 1) {
            constraints.weightx = 1.0;
        }
        return constraints;
    }

    protected GridBagConstraints makeGridConstraint(int col, int row, int colspan, int rowspan) {
        GridBagConstraints constraints = this.makeGridConstraint(col, row);
        constraints.gridwidth = colspan;
        constraints.gridheight = rowspan;
        return constraints;
    }

    protected Object makeExpandingVSpaceGridConstraint(int col, int row) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = col;
        constraints.gridy = row;
        if (col == 0) {
            constraints.weighty = 1.0;
        }
        return constraints;
    }

    public void refreshFromModel() {
        CellularPosition model = this.getModel().getCellularPosition();
        this.cellRadiusInputField.setValue(model.cellRadius());
        this.omniDirectionalCellsRadioButton.setSelected(model.sectorType().equals((Object)HybridSystemPlugin.SectorSetup.SingleSector));
        this.triSectorCells_3GGP_RadioButton.setSelected(model.sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP));
        this.triSectorCells_3GGP2_RadioButton.setSelected(model.sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP2));
        int baseStations = model.sectorType().equals((Object)HybridSystemPlugin.SectorSetup.SingleSector) ? 1 : 3;
        switch (model.tiers()) {
            case 0: {
                this.singleCellRadioButton.setSelected(true);
                break;
            }
            case 1: {
                baseStations *= 7;
                this.oneTierRadioButton.setSelected(true);
                break;
            }
            default: {
                baseStations *= 19;
                this.twoTiersRadioButton.setSelected(true);
            }
        }
        this.baseStationCountValueLabel.setText("" + baseStations);
        String text = "     " + numberFormat.format(ReferenceCellSelector.getInterCellDistance(model));
        this.bs2bsDistanceValueLabel.setText(text);
    }

    private void localUpdate() {
        CellularPositionHolder model = this.getModel();
        CellularPosition prototype = Factory.prototype(CellularPosition.class, model.getCellularPosition());
        if (this.oneTierRadioButton.isSelected()) {
            if (model.getCellularPosition().referenceCellId() > 6) {
                Factory.when(prototype.referenceCellId()).thenReturn(0);
            }
        } else if (this.singleCellRadioButton.isSelected() && model.getCellularPosition().referenceCellId() > 0) {
            Factory.when(prototype.referenceCellId()).thenReturn(0);
        }
        model.setCellularPosition(Factory.build(prototype));
    }

    public void updateModel() {
        CellularPositionHolder model = this.getModel();
        int baseStations = this.omniDirectionalCellsRadioButton.isSelected() ? 1 : 3;
        CellularPosition prototype = Factory.prototype(CellularPosition.class, model.getCellularPosition());
        Factory.when(prototype.cellRadius()).thenReturn(this.cellRadiusInputField.getValueAsDouble());
        if (this.twoTiersRadioButton.isSelected()) {
            baseStations *= 19;
            Factory.when(prototype.tiers()).thenReturn(2);
        } else if (this.oneTierRadioButton.isSelected()) {
            baseStations *= 7;
            Factory.when(prototype.tiers()).thenReturn(1);
            Factory.when(prototype.generateWrapAround()).thenReturn(false);
        } else {
            Factory.when(prototype.tiers()).thenReturn(0);
            Factory.when(prototype.generateWrapAround()).thenReturn(false);
        }
        this.baseStationCountValueLabel.setText("" + baseStations);
        if (this.omniDirectionalCellsRadioButton.isSelected()) {
            Factory.when(prototype.referenceSector()).thenReturn(0);
            Factory.when(prototype.sectorType()).thenReturn(HybridSystemPlugin.SectorSetup.SingleSector);
        } else if (this.triSectorCells_3GGP2_RadioButton.isSelected()) {
            Factory.when(prototype.sectorType()).thenReturn(HybridSystemPlugin.SectorSetup.TriSector3GPP2);
        } else if (this.triSectorCells_3GGP_RadioButton.isSelected()) {
            Factory.when(prototype.sectorType()).thenReturn(HybridSystemPlugin.SectorSetup.TriSector3GPP);
        }
        model.setCellularPosition(Factory.build(prototype));
        this.refresher.refresh();
    }
}

