/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.ReplayAction;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.eventprocessing.ReadOnlyPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.IntegerItem;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.report.ReportDialog;
import org.seamcat.simulation.result.SimulationResultImpl;

public class WorkspaceReadOnlyView
extends JScrollPane {
    public WorkspaceReadOnlyView(final Workspace workspace, ActionListener exportListener, final ReplayAction replayListener) {
        JPanel panel = new JPanel(new BorderLayout());
        final IntegerItem eventNumber = new IntegerItem();
        JButton export = new JButton("Export workspace");
        export.addActionListener(exportListener);
        JButton reportWorkspace = ToolBar.button("SEAMCAT_ICON_GENERATE_REPORT", "MENU_ITEM_TEXT_REPORT");
        reportWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog dialog = new ReportDialog();
                dialog.setReportSource(workspace);
                dialog.setVisible(true);
            }
        });
        JButton replay = ToolBar.button("SCENARIO_REPLAY", "SCENARIO_REPLAY_TOOLTIP");
        JPanel controlPanel = new JPanel(new LabeledPairLayout());
        SimulationControl control = workspace.getSimulationControl();
        ReadOnlyPanel.readOnly(controlPanel, SimulationControl.class, control);
        JPanel top = new JPanel(new BorderLayout());
        JPanel exportPanel = new JPanel(new FlowLayout(0));
        exportPanel.add(export);
        exportPanel.add(reportWorkspace);
        GenericPanel eventPanel = new GenericPanel();
        eventPanel.addItem(eventNumber);
        eventPanel.initializeWidgets();
        eventNumber.setValue(0);
        replay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationResultImpl results = workspace.getSimulationResults();
                if (results != null) {
                    long seed = WorkspaceReadOnlyView.this.getSeed(results);
                    replayListener.replay(seed, eventNumber.getValue());
                }
            }
        });
        exportPanel.add(replay);
        exportPanel.add(eventPanel);
        JLabel helpButton = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_HELP", 0));
        exportPanel.add(helpButton);
        helpButton.setToolTipText("See SEAMCAT manual");
        helpButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SeamcatHelpResolver.showHelp("http://confluence.seamcat.org/pages/viewpage.action?pageId=1409204");
            }
        });
        top.add((Component)exportPanel, "North");
        top.add((Component)new BorderPanel(controlPanel, "Simulation Control"), "Center");
        panel.add((Component)top, "North");
        JPanel sysPanels = new JPanel();
        sysPanels.setLayout(new BoxLayout(sysPanels, 1));
        sysPanels.add(this.createSystem(workspace.getVictimSystem(), workspace.getVictimFrequency()));
        List<InterferenceLinkElement> interferenceLinkUIs = workspace.getInterferenceLinkUIs();
        for (int i = 0; i < interferenceLinkUIs.size(); ++i) {
            InterferenceLinkElement element = interferenceLinkUIs.get(i);
            Distribution frequency = workspace.getInterferingLinkFrequency().get(i);
            InterferenceLinkUI il = element.getSettings();
            JPanel ilPanel = new JPanel(new LabeledPairLayout());
            ilPanel.add((Component)new JLabel("Frequency"), "label");
            ilPanel.add((Component)new JLabel(frequency.toString()), "field");
            ReadOnlyPanel.compositeReadOnly(ilPanel, InterferenceLinkUI.class, il);
            sysPanels.add(new BorderPanel(ilPanel, element.getName()));
        }
        int count = 0;
        for (InterferenceLink link : workspace.getInterferenceLinks()) {
            sysPanels.add(this.createSystem(link.getInterferer().getSystemPlugin(), link.getFrequency()));
            ++count;
        }
        List<EventProcessingConfiguration> epps = workspace.getEventProcessingList();
        if (epps != null && !epps.isEmpty()) {
            JPanel eppsPanel = new JPanel();
            eppsPanel.setLayout(new BoxLayout(eppsPanel, 1));
            for (EventProcessingConfiguration epp : epps) {
                JPanel eppPanel = new JPanel(new LabeledPairLayout());
                ReadOnlyPanel.addReadOnly(eppPanel, epp);
                sysPanels.add(new BorderPanel(eppPanel, epp.toString()));
            }
        }
        panel.add((Component)sysPanels, "Center");
        this.getViewport().add(panel);
    }

    private BorderPanel createSystem(SystemPlugin system, Distribution frequency) {
        JPanel sysPanel = new JPanel(new LabeledPairLayout());
        sysPanel.add((Component)new JLabel("Frequency"), "label");
        sysPanel.add((Component)new JLabel(frequency.toString()), "field");
        ReadOnlyPanel.compositeReadOnly(sysPanel, GenericTypeMarshaller.getPluginUIClass(system), system.getUI());
        return new BorderPanel(sysPanel, "Victim System (" + system.getUI().description().name() + ")");
    }

    private long getSeed(SimulationResult result) {
        Results statistics = result.getSimulationStatistics();
        return statistics.findLongValue(InterferenceSimulationEngine.SIMULATION_SEED);
    }
}

