/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.DefaultTableModel;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SamplesResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.display.BarChartGroupResultType;
import org.seamcat.presentation.display.NamedVectorResult;
import org.seamcat.presentation.display.ScatterGroupResultType;
import org.seamcat.presentation.display.SingleValueGroupResultType;
import org.seamcat.presentation.display.VectorGroupResultType;

public class SimulationResultGroupTableModel
extends DefaultTableModel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private Results result;
    private List<Object> values = new ArrayList<Object>();
    private int size = 0;
    private String helpContents;
    private final String[] COLS = new String[]{"Name", "Value", "Unit"};

    public SimulationResultGroupTableModel(Results result) {
        this.result = result;
        String key = "SimulationResult." + result.getName().replaceAll(" ", "_");
        if (STRINGLIST.containsKey(key)) {
            this.helpContents = STRINGLIST.getString(key);
        }
        this.update();
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int i) {
        return this.COLS[i];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int i, int i2) {
        return false;
    }

    public void update() {
        Object group;
        List<Object> types;
        this.values.clear();
        this.values.addAll(this.result.nonGroupedSingleValues());
        for (Map.Entry<String, List<SingleValueTypes>> entry : this.result.allSingleValueGroups().entrySet()) {
            types = entry.getValue();
            group = new SingleValueGroupResultType(entry.getKey());
            for (Object type : types) {
                ((SingleValueGroupResultType)group).addValue((SingleValueTypes<?>)type);
            }
            this.values.add(group);
        }
        this.values.addAll(this.result.nonGrouped());
        for (Map.Entry<String, List<Object>> entry : this.result.allGroups().entrySet()) {
            types = entry.getValue();
            group = new VectorGroupResultType(entry.getKey(), ((VectorResultType)types.get(0)).getUnit());
            for (Object type : types) {
                ((VectorGroupResultType)group).addVector(new NamedVectorResult(((VectorResultType)type).getName(), ((VectorResultType)type).getValue()));
            }
            this.values.add(group);
        }
        this.values.addAll(this.result.nonGroupedScatter());
        for (Map.Entry<String, List<Object>> entry : this.result.allGroupedScatter().entrySet()) {
            types = entry.getValue();
            group = new ScatterGroupResultType(entry.getKey());
            for (Object type : types) {
                ((ScatterGroupResultType)group).addValue((ScatterDiagramResultType)type);
            }
            this.values.add(group);
        }
        this.values.addAll(this.result.nonGroupedBarChart());
        for (Map.Entry<String, List<Object>> entry : this.result.allGroupedBarChart().entrySet()) {
            types = entry.getValue();
            group = new BarChartGroupResultType(entry.getKey());
            for (Object type : types) {
                ((BarChartGroupResultType)group).addValue((BarChartResultType)type);
            }
            this.values.add(group);
        }
        this.values.addAll(this.result.getFunctionResultTypes());
        this.values.addAll(this.result.getSamplesResultTypes());
        this.size = this.values.size();
        this.fireTableStructureChanged();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.values.size()) {
            return null;
        }
        Object value = this.values.get(row);
        if (value instanceof SingleValueTypes) {
            return this.getValue((SingleValueTypes)value, col);
        }
        if (value instanceof SingleValueGroupResultType) {
            return this.getValue((SingleValueGroupResultType)value, col);
        }
        if (value instanceof VectorGroupResultType) {
            return this.getValue((VectorGroupResultType)value, col);
        }
        if (value instanceof VectorResultType) {
            return this.getValue((VectorResultType)value, col);
        }
        if (value instanceof ScatterDiagramResultType) {
            return this.getValue((ScatterDiagramResultType)value, col);
        }
        if (value instanceof BarChartResultType) {
            return this.getValue((BarChartResultType)value, col);
        }
        if (value instanceof FunctionResultType) {
            return this.getValue((FunctionResultType)value, col);
        }
        if (value instanceof SamplesResultType) {
            return this.getValue((SamplesResultType)value, col);
        }
        if (value instanceof ScatterGroupResultType) {
            return this.getValue((ScatterGroupResultType)value, col);
        }
        if (value instanceof BarChartGroupResultType) {
            return this.getValue((BarChartGroupResultType)value, col);
        }
        throw new RuntimeException("unknown type: " + value);
    }

    public String toString() {
        return this.result.getName();
    }

    private Object getValue(SingleValueTypes<?> single, int col) {
        if (col == 0) {
            return single.def().name();
        }
        if (col == 1) {
            return single.value();
        }
        return single.def().unit();
    }

    private Object getValue(SingleValueGroupResultType singleGroup, int col) {
        if (col == 0) {
            return singleGroup;
        }
        if (col == 1) {
            return "Values[" + singleGroup.getValues().size() + "]";
        }
        return "";
    }

    private Object getValue(VectorGroupResultType vg, int col) {
        if (col == 0) {
            return vg;
        }
        if (col == 1) {
            return vg.description();
        }
        return vg.getUnit();
    }

    private Object getValue(VectorResultType v, int col) {
        if (col == 0) {
            return v;
        }
        if (col == 1) {
            return v.description();
        }
        return v.getUnit();
    }

    private Object getValue(ScatterDiagramResultType s, int col) {
        if (col == 0) {
            return s;
        }
        if (col == 1) {
            return s.description();
        }
        return "N/A";
    }

    private Object getValue(ScatterGroupResultType g, int col) {
        if (col == 0) {
            return g;
        }
        if (col == 1) {
            return g.description();
        }
        return "N/A";
    }

    private Object getValue(BarChartResultType bar, int col) {
        if (col == 0) {
            return bar;
        }
        if (col == 1) {
            return bar.description();
        }
        return bar.def().yUnit();
    }

    private Object getValue(BarChartGroupResultType bar, int col) {
        if (col == 0) {
            return bar;
        }
        if (col == 1) {
            return bar.description();
        }
        return "N/A";
    }

    private Object getValue(FunctionResultType function, int col) {
        if (col == 0) {
            return function;
        }
        if (col == 1) {
            return function.description();
        }
        return function.def().unit() + " -> " + function.def().yUnit();
    }

    private Object getValue(SamplesResultType sample, int col) {
        if (col == 0) {
            return sample;
        }
        if (col == 1) {
            return "Samples[" + sample.getSamples().length + "]";
        }
        return sample.getUnit();
    }

    public String getHelpContents() {
        return this.helpContents;
    }
}

