/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.simulationview.results.ResultTableUtil;
import org.seamcat.simulation.result.CollectorImpl;

public class ScenarioResultPanel
extends JPanel {
    public ScenarioResultPanel(Scenario scenario, EventResult result) {
        super(new BorderLayout());
        VictimResultCollector victimResult = result.getVictimResult();
        JTabbedPane tabs = new JTabbedPane(1);
        String name = "Victim System (" + scenario.getVictim().getName() + ")";
        tabs.add(name, this.createGroup(name, (CollectorImpl)((Object)victimResult)));
        int i = 1;
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            name = "Link " + i + " (" + link.getInterferer().getName() + ")";
            tabs.add(name, this.createGroup(name, (CollectorImpl)((Object)result.getInterferingSystemResult(link))));
            ++i;
        }
        this.add((Component)tabs, "Center");
    }

    private JComponent createGroup(String name, CollectorImpl collector) {
        ArrayList<Object> values = new ArrayList<Object>();
        this.addCollector(values, collector);
        return ResultTableUtil.table(name, values);
    }

    private void addCollector(List<Object> values, CollectorImpl collector) {
        for (Map.Entry<VectorDef, Double> entry : collector.values().entrySet()) {
            values.add(new DoubleResultType(Factory.results().single(entry.getKey().name(), entry.getKey().unit()), entry.getValue()));
        }
        for (Map.Entry<VectorDef, Object> entry : collector.samples().entrySet()) {
            values.add(new VectorResultType(entry.getKey(), (List)entry.getValue()));
        }
    }
}

