/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.Color;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.SystemLink;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.types.InterferenceLink;

public class LinkResultPlot {
    private SystemLink systemLink;
    private int idx;
    private InterferenceLink link;
    private final Color rxColor;
    private final Color txColor;
    private boolean rxSelected;
    private boolean txSelected;
    private String victimName;

    public LinkResultPlot(String victimName, Victim victim, Color rxColor, Color txColor) {
        this.victimName = victimName;
        this.idx = 0;
        this.systemLink = victim;
        this.rxColor = rxColor;
        this.txColor = txColor;
    }

    public LinkResultPlot(int idx, Interferer interferer, InterferenceLink link, Color rxColor, Color txColor) {
        this.idx = idx;
        this.systemLink = interferer;
        this.link = link;
        this.rxColor = rxColor;
        this.txColor = txColor;
    }

    public String getName(boolean rx, boolean withPosition) {
        AntennaResult a;
        LinkResult link = this.systemLink.getLinkResult();
        String name = (this.link == null ? this.victimName : this.link.toString()) + " [" + this.genericName(rx) + "]: ";
        if (rx) {
            a = link.rxAntenna();
            name = name + this.systemLink.getRxName();
        } else {
            a = link.txAntenna();
            name = name + this.systemLink.getTxName();
        }
        if (withPosition) {
            return name + " " + a.getPosition();
        }
        return name;
    }

    private String genericName(boolean rx) {
        if (rx) {
            if (this.link == null) {
                return "VLR";
            }
            return "ILR";
        }
        if (this.link == null) {
            return "VLT";
        }
        return "ILT";
    }

    public SystemLink getSystemLink() {
        return this.systemLink;
    }

    public AntennaResult getAntennaResult() {
        LinkResult link = this.getLinkResult();
        if (this.isRxSelected()) {
            return link.rxAntenna();
        }
        return link.txAntenna();
    }

    public void rxSelected() {
        this.rxSelected = true;
    }

    public void txSelected() {
        this.txSelected = true;
    }

    public boolean isRxSelected() {
        return this.rxSelected;
    }

    public boolean isTxSelected() {
        return this.txSelected;
    }

    public void deSelect() {
        this.rxSelected = false;
        this.txSelected = false;
    }

    public LinkResult getLinkResult() {
        return this.systemLink.getLinkResult();
    }

    public Color getRxColor() {
        return this.rxColor;
    }

    public Color getTxColor() {
        return this.txColor;
    }

    public String toString() {
        return this.getName(this.rxSelected, true);
    }

    public int getIdx() {
        return this.idx;
    }

    boolean isSameRx(LinkResultPlot other) {
        if (this == other) {
            return false;
        }
        return this.systemLink.isSameRx(other.getSystemLink());
    }

    boolean isSameTx(LinkResultPlot other) {
        if (this == other) {
            return false;
        }
        return this.systemLink.isSameTx(other.getSystemLink());
    }
}

