/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.display.VectorGroupResultType;

public class DoubleValuesTableModel
extends DefaultTableModel {
    private String name;
    private List<SingleValueTypes> values = new ArrayList<SingleValueTypes>();
    private int size = 0;
    private final String[] COLS = new String[]{"Name", "Value", "Unit"};

    public DoubleValuesTableModel(String name, List<SingleValueTypes> values) {
        this.name = name;
        this.values = values;
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int i) {
        return this.COLS[i];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int i, int i2) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.values.size()) {
            return null;
        }
        SingleValueTypes value = this.values.get(row);
        if (value instanceof SingleValueTypes) {
            return this.getValue(value, col);
        }
        if (value instanceof VectorGroupResultType) {
            return this.getValue((VectorGroupResultType)((Object)value), col);
        }
        if (value instanceof VectorResultType) {
            return this.getValue((VectorResultType)((Object)value), col);
        }
        if (value instanceof ScatterDiagramResultType) {
            return this.getValue((ScatterDiagramResultType)((Object)value), col);
        }
        if (value instanceof BarChartResultType) {
            return this.getValue((BarChartResultType)((Object)value), col);
        }
        if (value instanceof FunctionResultType) {
            return this.getValue((FunctionResultType)((Object)value), col);
        }
        throw new RuntimeException("unknown type: " + value);
    }

    public String toString() {
        return this.name;
    }

    private Object getValue(SingleValueTypes<?> single, int col) {
        if (col == 0) {
            return single.def().name();
        }
        if (col == 1) {
            return single.value();
        }
        return single.def().unit();
    }

    private Object getValue(VectorGroupResultType vg, int col) {
        if (col == 0) {
            return vg;
        }
        if (col == 1) {
            return vg.description();
        }
        return vg.getUnit();
    }

    private Object getValue(VectorResultType v, int col) {
        if (col == 0) {
            return v;
        }
        if (col == 1) {
            return v.description();
        }
        return v.getUnit();
    }

    private Object getValue(ScatterDiagramResultType s, int col) {
        if (col == 0) {
            return s;
        }
        if (col == 1) {
            return s.description();
        }
        return "N/A";
    }

    private Object getValue(BarChartResultType bar, int col) {
        if (col == 0) {
            return bar;
        }
        if (col == 1) {
            return bar.description();
        }
        return bar.def().yUnit();
    }

    private Object getValue(FunctionResultType function, int col) {
        if (col == 0) {
            return function;
        }
        if (col == 1) {
            return function.description();
        }
        return function.def().unit() + " -> " + function.def().yUnit();
    }
}

