/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.SystemLink;
import org.seamcat.presentation.simulationview.results.EventResultPlotData;
import org.seamcat.presentation.simulationview.results.LinkResultElement;
import org.seamcat.presentation.simulationview.results.LinkResultPlot;
import org.seamcat.presentation.simulationview.results.ResultTableUtil;
import org.seamcat.presentation.simulationview.results.ScenarioEventResultPlot;
import org.seamcat.presentation.simulationview.results.SecondPointSelection;

public class DetailPanel
extends JPanel {
    private ScenarioEventResultPlot plot;
    private final EventResultPlotData data;
    private JPanel detailPanel;
    private JList allPoints;
    private JList secondaryPoints;
    DefaultListModel secondaryModel = new DefaultListModel();
    private boolean mute = false;

    public DetailPanel(final ScenarioEventResultPlot plot, EventResultPlotData data) {
        JSplitPane container = new JSplitPane(1);
        container.setDividerLocation(200);
        this.plot = plot;
        this.data = data;
        this.detailPanel = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.allPoints = new JList();
        JPanel listPanel = this.setup(this.allPoints, "Available Points", new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LinkResultElement element;
                if (DetailPanel.this.mute) {
                    return;
                }
                if (!e.getValueIsAdjusting() && (element = (LinkResultElement)DetailPanel.this.allPoints.getSelectedValue()) != null) {
                    LinkResultPlot linkResult = element.getLinkResult();
                    DetailPanel.this.showConnectingPoints(linkResult, false);
                    plot.multiConnect();
                    plot.select(linkResult);
                }
            }
        });
        DefaultListModel<LinkResultElement> model = new DefaultListModel<LinkResultElement>();
        this.allPoints.setModel(model);
        for (List<LinkResultPlot> plots : data.getLinkResultMap().values()) {
            HashSet<SystemLink> uniqueTx = new HashSet<SystemLink>();
            for (LinkResultPlot pl : plots) {
                LinkResult linkResult = pl.getLinkResult();
                if (this.contains(false, uniqueTx, pl.getSystemLink()) || linkResult.hasValue(InterferenceSimulationEngine.TX_NOT_SIMULATED)) continue;
                model.addElement(new LinkResultElement(false, pl));
                uniqueTx.add(pl.getSystemLink());
            }
            HashSet<SystemLink> uniqueRx = new HashSet<SystemLink>();
            for (LinkResultPlot pl : plots) {
                LinkResult linkResult = pl.getLinkResult();
                if (this.contains(true, uniqueRx, pl.getSystemLink()) || linkResult.hasValue(InterferenceSimulationEngine.RX_NOT_SIMULATED)) continue;
                model.addElement(new LinkResultElement(true, pl));
                uniqueRx.add(pl.getSystemLink());
            }
        }
        Button clear = new Button("Clear Selection");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailPanel.this.clearSelection();
            }
        });
        listPanel.add((Component)clear, "South");
        container.add(listPanel);
        this.secondaryPoints = new JList();
        this.secondaryPoints.setModel(this.secondaryModel);
        JPanel secondList = this.setup(this.secondaryPoints, "Connecting Points", new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SecondPointSelection element;
                if (!e.getValueIsAdjusting() && (element = (SecondPointSelection)DetailPanel.this.secondaryPoints.getSelectedValue()) != null) {
                    DetailPanel.this.setSelectedLink(element);
                    plot.singleSelect(element);
                }
            }
        });
        JSplitPane center = new JSplitPane(1);
        center.setDividerLocation(200);
        center.add(secondList);
        center.add(this.detailPanel);
        container.add(center);
        this.add((Component)new JScrollPane(container), "Center");
    }

    private boolean contains(boolean rx, Set<SystemLink> unique, SystemLink candidate) {
        for (SystemLink systemLink : unique) {
            if (!(rx ? systemLink.isSameRx(candidate) : systemLink.isSameTx(candidate))) continue;
            return true;
        }
        return false;
    }

    private JPanel setup(JList list, String title, ListSelectionListener listener) {
        list.setSelectionMode(0);
        list.addListSelectionListener(listener);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JLabel(title), "North");
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(list);
        listPanel.add((Component)pane, "Center");
        return listPanel;
    }

    private void setSelectedLink(SecondPointSelection selected) {
        this.detailPanel.removeAll();
        ArrayList<Object> values = new ArrayList<Object>();
        selected.writeValues(values);
        this.detailPanel.add((Component)ResultTableUtil.table("", values), "Center");
        this.revalidate();
        this.repaint();
    }

    private void emptySecondaryList() {
        this.detailPanel.removeAll();
        this.secondaryPoints.clearSelection();
        this.secondaryModel.removeAllElements();
        this.revalidate();
        this.repaint();
    }

    private void clearSelection() {
        this.allPoints.clearSelection();
        this.emptySecondaryList();
        this.plot.select(null);
    }

    public void showConnectingPoints(LinkResultPlot selected, boolean selectInList) {
        this.emptySecondaryList();
        if (selectInList) {
            if (selected == null) {
                this.allPoints.clearSelection();
            } else {
                LinkResultElement elm = this.find(selected);
                if (elm != null) {
                    this.mute = true;
                    this.allPoints.setSelectedValue(elm, true);
                    this.mute = false;
                }
            }
        }
        if (selected == null) {
            return;
        }
        List<LinkResultPlot> adjacentLinks = this.data.getAdjacentLinks(selected);
        adjacentLinks.add(selected);
        List<InterferenceLinkResult> links = this.data.getRelevantInterferenceLinks(selected);
        boolean rx = selected.isRxSelected();
        for (LinkResultPlot linkResultPlot : adjacentLinks) {
            Point2D txP;
            Point2D rxP;
            LinkResult linkResult = linkResultPlot.getLinkResult();
            if (linkResult.getValue(InterferenceSimulationEngine.RX_NOT_SIMULATED) != null || linkResult.getValue(InterferenceSimulationEngine.TX_NOT_SIMULATED) != null) continue;
            if (rx) {
                rxP = selected.getSystemLink().getLinkResult().rxAntenna().getPosition();
                txP = linkResultPlot.getSystemLink().getLinkResult().txAntenna().getPosition();
            } else {
                rxP = linkResultPlot.getSystemLink().getLinkResult().rxAntenna().getPosition();
                txP = selected.getSystemLink().getLinkResult().txAntenna().getPosition();
            }
            this.secondaryModel.addElement(new SecondPointSelection(linkResultPlot.getName(!rx, false), linkResult, txP, rxP));
        }
        for (InterferenceLinkResult interferenceLinkResult : links) {
            Point2D txP;
            Point2D rxP;
            String pointName;
            if (rx) {
                pointName = new LinkResultPlot(0, interferenceLinkResult.getInterferer(), interferenceLinkResult.getInterferenceLink(), null, null).getName(false, false);
                rxP = selected.getSystemLink().getLinkResult().rxAntenna().getPosition();
                txP = interferenceLinkResult.getInterferingSystemLink().txAntenna().getPosition();
            } else {
                pointName = new LinkResultPlot(interferenceLinkResult.getInterferenceLink().getVictim().getSystemPlugin().getUI().description().name(), interferenceLinkResult.getVictim(), null, null).getName(true, false);
                rxP = interferenceLinkResult.getVictimSystemLink().rxAntenna().getPosition();
                txP = selected.getSystemLink().getLinkResult().txAntenna().getPosition();
            }
            this.secondaryModel.addElement(new SecondPointSelection(pointName, interferenceLinkResult, txP, rxP));
        }
    }

    private LinkResultElement find(LinkResultPlot selected) {
        ListModel model = this.allPoints.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LinkResultElement elm = (LinkResultElement)model.getElementAt(i);
            if (elm.linkResult != selected || !(elm.rx ? selected.isRxSelected() : selected.isTxSelected())) continue;
            return elm;
        }
        return null;
    }
}

