/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.seamcat.model.Scenario;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.presentation.simulationview.outline.VectorPanel;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class VectorOutlinePanel
extends JPanel {
    private VectorPanel dRssPanel;
    private VectorPanel iRssUnwanted;
    private VectorPanel iRssBlocking;

    public VectorOutlinePanel(Scenario scenario, String unw, String blo) {
        int numberOfEvents = scenario.numberOfEvents();
        SystemPlugin victim = scenario.getVictim().getSystemPlugin();
        if (victim instanceof GenericSystemPlugin) {
            this.setLayout(new GridLayout(3, 1));
            this.dRssPanel = new VectorPanel("", "", numberOfEvents);
            this.dRssPanel.setBorder(new TitledBorder("dRss"));
            this.dRssPanel.show("", "dBm");
            this.add(this.dRssPanel);
        } else {
            this.setLayout(new GridLayout(2, 1));
        }
        this.iRssUnwanted = new VectorPanel("", "", numberOfEvents);
        this.iRssUnwanted.setBorder(new TitledBorder(unw));
        this.iRssUnwanted.show("", "dBm");
        this.add(this.iRssUnwanted);
        this.iRssBlocking = new VectorPanel("", "", numberOfEvents);
        this.iRssBlocking.setBorder(new TitledBorder(blo));
        this.iRssBlocking.show("", "dBm");
        this.add(this.iRssBlocking);
    }

    public VectorPanel getPanel(int idx) {
        if (idx == 0) {
            return this.dRssPanel;
        }
        if (idx == 1) {
            return this.iRssUnwanted;
        }
        return this.iRssBlocking;
    }

    public void reset() {
        if (this.dRssPanel != null) {
            this.dRssPanel.reset();
        }
        this.iRssUnwanted.reset();
        this.iRssBlocking.reset();
    }
}

