/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.NoFeasibleShapesException;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyDescription;
import org.seamcat.presentation.simulationview.outline.SystemLayoutExplaination;

public class SystemLayoutPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private double width;
    private double height;
    private int focusShiftX = 0;
    private int focusShiftY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private Color rxBase = Color.ORANGE;
    private Color txBase = Color.BLUE;
    private double scaleFactor;
    private int selectedItemZoomFactor = 0;
    private double zoomFactor = 1.0;
    protected PropertySetter prop;
    private SystemPlugin plugin;
    private SystemLayoutExplaination explaination;
    private SystemSpaces systemSpaces;
    private NoFeasibleShapesException exception;

    public SystemLayoutPanel(SystemPlugin plugin, SystemLayoutExplaination explaination) {
        this.plugin = plugin;
        this.explaination = explaination;
        this.prop = new PropertySetter((Object)this, "selectedItemZoomFactor", 0, 4);
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
        super.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModelSizes(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                SystemLayoutPanel.this.setModelSizes(true);
            }
        });
        this.generateSpaces();
    }

    private void setModelSizes(boolean panelInitialized) {
        if (this.systemSpaces == null) {
            return;
        }
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (Point2D point : PolygonUtil.allPoints(this.systemSpaces)) {
            minX = Math.min(minX, point.getX());
            maxX = Math.max(maxX, point.getX());
            minY = Math.min(minY, point.getY());
            maxY = Math.max(maxY, point.getY());
        }
        Bounds x = new Bounds(minX, maxX, true);
        Bounds y = new Bounds(minY, maxY, true);
        double rangeX = Math.abs(x.getMax() - x.getMin());
        double rangeY = Math.abs(y.getMax() - y.getMin());
        this.width = rangeX * 1.2;
        this.height = rangeY * 1.2;
        if (panelInitialized) {
            this.setScaleFactor();
            this.focusShiftX = (int)(-this.scaleFactor * (x.getMax() + x.getMin()) / 2.0);
            this.focusShiftY = (int)(this.scaleFactor * (y.getMax() + y.getMin()) / 2.0);
        }
    }

    public void tabSelected() {
        this.generateSpaces();
        this.setModelSizes(true);
        this.repaint();
    }

    private void generateSpaces() {
        this.systemSpaces = null;
        this.exception = null;
        RandomAccessor.fixSeed(42L);
        try {
            this.systemSpaces = this.plugin.generateSystemSpaces(null);
        }
        catch (NoFeasibleShapesException e) {
            this.exception = e;
        }
    }

    private void setScaleFactor() {
        Dimension dim = this.getSize();
        double scaleFactorH = dim.getHeight() / this.height;
        double scaleFactorW = dim.getWidth() / this.width;
        this.scaleFactor = Math.min(scaleFactorH, scaleFactorW);
        this.scaleFactor *= this.zoomFactor;
    }

    public void setSelectedItemZoomFactor(int selectedItemZoomFactor) {
        this.selectedItemZoomFactor = selectedItemZoomFactor;
        this.repaint();
    }

    public int getSelectedItemZoomFactor() {
        return this.selectedItemZoomFactor;
    }

    public void adjustFocusShiftX(int _focusShiftX) {
        this.focusShiftX += _focusShiftX;
    }

    public void adjustFocusShiftY(int _focusShiftY) {
        this.focusShiftY += _focusShiftY;
    }

    public void adjustZoom(double adjustment) {
        double adjust = adjustment / 100.0;
        this.zoomFactor += adjust;
        if (this.zoomFactor < 0.0) {
            this.zoomFactor = 0.0;
        }
    }

    public int getFocusShiftX() {
        return this.focusShiftX;
    }

    public int getFocusShiftY() {
        return this.focusShiftY;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void paintComponent(Graphics _gr) {
        super.paintComponent(_gr);
        Graphics2D gr = (Graphics2D)_gr;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setBackground(Color.WHITE);
        this.setScaleFactor();
        double intercellDistance = 1.0;
        Dimension dim = this.getSize();
        gr.clearRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20);
        gr.drawLine((int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 - 5, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 + 5);
        gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20 - 5, (int)dim.getWidth() / 20, (int)dim.getHeight() / 20 + 5);
        gr.drawString("D = " + Mathematics.round(intercellDistance) + " km", (int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0) + 20);
        gr.translate((int)(dim.getWidth() / 2.0), (int)(dim.getHeight() / 2.0));
        if (this.exception != null) {
            Point2D convert = this.convert(Point2D.ORIGIN);
            gr.drawString(this.exception.getMessage(), (int)convert.getX(), (int)convert.getY());
        }
        this.drawSystemOutline(gr, Point2D.ORIGIN);
    }

    private void drawSystemOutline(Graphics2D gr, Point2D center) {
        if (this.systemSpaces == null) {
            return;
        }
        LinkedHashSet<SectorPropertyDescription> rxGroups = new LinkedHashSet<SectorPropertyDescription>();
        LinkedHashSet<SectorPropertyDescription> txGroups = new LinkedHashSet<SectorPropertyDescription>();
        for (Space space : this.systemSpaces.getAllSpaces()) {
            if (space.isRx()) {
                rxGroups.add(space.getDescription());
                continue;
            }
            txGroups.add(space.getDescription());
        }
        ArrayList<SectorPropertyDescription> descPrioRx = new ArrayList<SectorPropertyDescription>(rxGroups);
        ArrayList<SectorPropertyDescription> descPrioTx = new ArrayList<SectorPropertyDescription>(txGroups);
        LinkedHashMap<SectorPropertyDescription, Color> colorMap = new LinkedHashMap<SectorPropertyDescription, Color>();
        ArrayList<Space> points = new ArrayList<Space>();
        for (Space space : this.systemSpaces.getAllSpaces()) {
            Polygon2D polygon = space.getSpace();
            Color color = this.getColor(space, descPrioRx, descPrioTx);
            if (!colorMap.containsKey(space.getDescription())) {
                colorMap.put(space.getDescription(), color);
            }
            if (polygon.getVertices().size() == 1) {
                points.add(space);
                continue;
            }
            this.drawPolygon(gr, polygon, center, color);
        }
        this.explaination.setDescriptions(colorMap);
        for (Space point : points) {
            Color color = this.getColor(point, descPrioRx, descPrioTx);
            this.drawPoint(gr, this.convert(point.getSpace().getVertices().get(0)), color);
        }
    }

    private Color getColor(Space space, List<SectorPropertyDescription> rx, List<SectorPropertyDescription> tx) {
        SectorPropertyDescription description = space.getDescription();
        if (space.isRx()) {
            return this.darken(this.rxBase, rx.indexOf(description));
        }
        return this.darken(this.txBase, tx.indexOf(description));
    }

    private Color darken(Color base, int count) {
        for (int i = 0; i < count; ++i) {
            base = base.darker();
        }
        return base;
    }

    private void drawPolygon(Graphics2D gr, Polygon2D polygon, Point2D offset, Color color) {
        List<Point2D> vertices = polygon.getVertices();
        int[] x = new int[vertices.size()];
        int[] y = new int[vertices.size()];
        for (int i = 0; i < vertices.size(); ++i) {
            Point2D vertex = vertices.get(i);
            Point2D e = this.convert(offset.add(vertex));
            x[i] = (int)e.getX();
            y[i] = (int)e.getY();
        }
        gr.setColor(color);
        gr.fillPolygon(x, y, x.length);
        gr.setColor(Color.BLACK);
        gr.drawPolygon(x, y, x.length);
    }

    private void drawPoint(Graphics2D gr, Point2D draw, Color color) {
        gr.setColor(color);
        gr.fillOval((int)draw.getX() - 3, (int)draw.getY() - 3, 6, 6);
    }

    private Point2D convert(Point2D point) {
        double userX = point.getX();
        double userY = -point.getY();
        userX *= this.scaleFactor;
        userY *= this.scaleFactor;
        return new Point2D(userX += (double)this.focusShiftX, userY += (double)this.focusShiftY);
    }

    public void resetView() {
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftX", this.getFocusShiftX(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftY", this.getFocusShiftY(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "zoomFactor", this.getZoomFactor(), 1.0).start();
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - this.offsetX;
        int y = e.getY() - this.offsetY;
        this.adjustFocusShiftX(x);
        this.adjustFocusShiftY(y);
        this.repaint();
        this.offsetX = e.getX();
        this.offsetY = e.getY();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.offsetX = e.getX();
        this.offsetY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            this.adjustZoom(e.getUnitsToScroll());
            this.repaint();
        }
    }
}

