/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.seamcat.model.engines.SimulationListener;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.simulationview.SimulationView;

public class SimulationControlPanel
extends JPanel
implements SimulationListener {
    private JButton pause;
    private JButton resume;
    private JButton stop;

    public SimulationControlPanel(final SimulationView view) {
        super(new FlowLayout(0));
        AbstractAction pauseAction = new AbstractAction(" Ctrl+P"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationControlPanel.this.paused();
                view.pause();
            }
        };
        pauseAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control P"));
        this.pause = ToolBar.button("SIMULATION_PAUSE", "MENU_ITEM_TEXT_STOP_EGE", pauseAction);
        this.pause.getActionMap().put("myAction", pauseAction);
        this.pause.getInputMap(2).put((KeyStroke)pauseAction.getValue("AcceleratorKey"), "myAction");
        AbstractAction resumeAction = new AbstractAction(" Ctrl+R"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationControlPanel.this.running();
                view.resume();
            }
        };
        resumeAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
        this.resume = ToolBar.button("SCENARIO_REPLAY", "SCENARIO_RESUME_SIMULATION", resumeAction);
        this.resume.getActionMap().put("myAction", resumeAction);
        this.resume.getInputMap(2).put((KeyStroke)resumeAction.getValue("AcceleratorKey"), "myAction");
        AbstractAction stopAction = new AbstractAction(" Ctrl+Q"){

            @Override
            public void actionPerformed(ActionEvent e) {
                view.stop();
            }
        };
        stopAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Q"));
        this.stop = ToolBar.button("SIMULATION_STOP", "SCENARIO_STOP_SIMULATION", stopAction);
        this.stop.getActionMap().put("myAction", stopAction);
        this.stop.getInputMap(2).put((KeyStroke)stopAction.getValue("AcceleratorKey"), "myAction");
        this.add(this.pause);
        this.add(this.resume);
        this.add(this.stop);
        if (view.getPartial() == null) {
            this.off();
        } else {
            this.paused();
        }
    }

    @Override
    public void simulationBegin(int totalEvents) {
        this.running();
    }

    @Override
    public void eventComplete(SingleResult result) {
    }

    @Override
    public void simulationEnd() {
        this.off();
    }

    private void off() {
        this.pause.setEnabled(false);
        this.resume.setEnabled(false);
        this.stop.setEnabled(false);
    }

    private void paused() {
        this.pause.setEnabled(false);
        this.resume.setEnabled(true);
        this.stop.setEnabled(true);
    }

    private void running() {
        this.pause.setEnabled(true);
        this.resume.setEnabled(false);
        this.stop.setEnabled(true);
    }
}

