/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.RSSEvent;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.SimulationListener;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LinkResultSamples;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.persistence.impl.LinkResultMarshaller;
import org.seamcat.presentation.Argument;
import org.seamcat.presentation.ExtendableXYSeries;
import org.seamcat.presentation.LightweightChartPanel;
import org.seamcat.presentation.ScenarioOutlineModel;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.simulationview.SimulationView;
import org.seamcat.presentation.simulationview.outline.SimulationControlPanel;
import org.seamcat.presentation.simulationview.outline.SimulationStatusPanel;
import org.seamcat.presentation.simulationview.outline.SimulationSummaryPanel;
import org.seamcat.presentation.simulationview.outline.VectorOutlinePanel;
import org.seamcat.presentation.simulationview.outline.VectorPanel;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.result.SimulationResultImpl;

public class OutlinePanel
extends JPanel
implements SimulationListener {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final DecimalFormat formatter;
    private final JFreeChart chart;
    private SimulationSummaryPanel eventStatsPanel;
    private SimulationStatusPanel simulationStatusPanel;
    private SimulationControlPanel simulationControl;
    private int eventsToBeCalculated;
    private JSplitPane labelsPanel;
    private int step100;
    private int progressStep;
    public static int maxProgressSteps = 1000;
    private VectorDef unw;
    private VectorDef blo;
    private VectorOutlinePanel rssPanel;
    private Workspace workspace;
    private ScenarioOutlineModel scenarioOutlineModel;
    private JSplitPane splitPaneH;
    private SimulationView view;

    public OutlinePanel(Workspace workspace, SimulationView view) {
        super(true);
        this.view = view;
        this.scenarioOutlineModel = new ScenarioOutlineModel(workspace.getInterferenceLinks().size());
        this.unw = Factory.results().value(VectorDefinitions.IRSSU, "dBm");
        this.blo = Factory.results().value(VectorDefinitions.IRSSB, "dBm");
        if (workspace.getVictimSystem() instanceof InterferenceNames) {
            InterferenceNames names = (InterferenceNames)((Object)workspace.getVictimSystem());
            this.unw = Factory.results().value(names.unwantedName(), "dBm");
            this.blo = Factory.results().value(names.blockingName(), "dBm");
        }
        this.rssPanel = new VectorOutlinePanel(workspace.getScenario(), this.unw.name(), this.blo.name());
        this.formatter = new DecimalFormat();
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        this.workspace = workspace;
        this.eventStatsPanel = new SimulationSummaryPanel(workspace.getScenario());
        this.initComponents();
        this.chart = ChartFactory.createScatterPlot(STRINGLIST.getString("SCENARIO_PLOT_TITLE"), STRINGLIST.getString("SCENARIO_PLOT_AXIX_TITLE_X"), STRINGLIST.getString("SCENARIO_PLOT_AXIX_TITLE_Y"), this.scenarioOutlineModel, PlotOrientation.VERTICAL, true, true, false);
        this.setToolTipGenerator();
        XYPlot xyPlot = (XYPlot)this.chart.getPlot();
        xyPlot.getRenderer().setSeriesPaint(3, new Color(255, 204, 51));
        xyPlot.setRangeCrosshairVisible(true);
        xyPlot.setDomainCrosshairVisible(true);
        NumberAxis domainAxis = (NumberAxis)this.chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRangeStickyZero(true);
        domainAxis.setAutoRangeIncludesZero(true);
        LightweightChartPanel chartPanel = new LightweightChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setVerticalAxisTrace(false);
        chartPanel.setHorizontalAxisTrace(false);
        Font f = new Font(this.getFont().getName(), this.getFont().getStyle(), 10);
        DiscreteFunctionGraph.applyStyles(chartPanel, f, true);
        JPanel charts = new JPanel(new BorderLayout());
        charts.add((Component)chartPanel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)new BorderPanel(charts, STRINGLIST.getString("SCENARIO_TITLE")), "Center");
        this.splitPaneH = new JSplitPane(1, true);
        this.splitPaneH.setLeftComponent(centerPanel);
        this.splitPaneH.setRightComponent(this.rssPanel);
        this.add((Component)this.labelsPanel, "North");
        this.add((Component)this.splitPaneH, "Center");
        this.splitPaneH.setDividerLocation(800);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OutlinePanel.this.splitPaneH.setDividerLocation(0.5);
            }
        });
        this.setModel();
        Subscriber.subscribe(this);
    }

    public void destroy() {
        this.simulationStatusPanel.destroy();
    }

    private void setModel() {
        LinkResultSamples samples = this.workspace.getSimulationResults().getSamples();
        if (samples != null) {
            this.addVictimResult(samples.getVictimSystemSamples());
            this.addInterfererResult(samples.getInterferingSystemSamples());
            this.chart.getXYPlot().setDataset(this.scenarioOutlineModel);
            if (this.workspace.isHasBeenCalculated()) {
                this.simulationStatusPanel.eventGenerationCompleted();
            }
        }
        this.setToolTipGenerator();
        this.setDataForRssCharts();
    }

    private void setToolTipGenerator() {
        final DecimalFormat formatter = new DecimalFormat();
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(3);
        formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        XYToolTipGenerator toolTipGenerator = new XYToolTipGenerator(){

            @Override
            public String generateToolTip(XYDataset xyDataset, int series, int item) {
                ExtendableXYSeries xySeries2;
                List<Argument> args;
                StringBuilder sb = new StringBuilder();
                String customText = "";
                String seriesString = xyDataset.getSeriesKey(series).toString();
                seriesString = seriesString.replaceAll("<", "&lt;");
                seriesString = seriesString.replaceAll(">", "&gt;");
                Number x = xyDataset.getX(series, item);
                Number y = xyDataset.getY(series, item);
                XYSeries xySeries = OutlinePanel.this.scenarioOutlineModel.getSeries(series);
                if (xySeries instanceof ExtendableXYSeries && (args = (xySeries2 = (ExtendableXYSeries)xySeries).getArgsForPoint(x, y)) != null) {
                    customText = OutlinePanel.this.argumentToHTMLTable(args);
                }
                sb.append("<html><body>").append(seriesString).append(" (");
                sb.append(formatter.format(x.doubleValue())).append(", ");
                sb.append(formatter.format(y.doubleValue()));
                sb.append(") ").append(customText).append("</body></html>");
                return sb.toString();
            }
        };
        this.chart.getXYPlot().getRenderer().setBaseToolTipGenerator(toolTipGenerator);
    }

    private String argumentToHTMLTable(List<Argument> args) {
        StringBuilder strb = new StringBuilder();
        strb.append("<table border=\"0\">");
        for (Argument argument : args) {
            if (argument == null) continue;
            strb.append(argument.toHTMLTableRow());
        }
        strb.append("</table>");
        return strb.toString();
    }

    public void clearAllElements() {
        this.scenarioOutlineModel.clearAllElements();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        if (this.workspace.getPartial() != null) {
            int numEvents = this.workspace.getScenario().numberOfEvents();
            int current = this.workspace.getPartial().getUnprocessed().get(0);
            this.initialize(numEvents);
            this.simulationStatusPanel = new SimulationStatusPanel(numEvents, current);
        } else {
            this.simulationStatusPanel = new SimulationStatusPanel();
        }
        this.simulationControl = new SimulationControlPanel(this.view);
        this.labelsPanel = new JSplitPane(1);
        this.labelsPanel.setResizeWeight(0.3);
        this.labelsPanel.add(new BorderPanel(this.eventStatsPanel, STRINGLIST.getString("SIMULATION_STATUS_TITLE")));
        JSplitPane right = new JSplitPane(1);
        right.setResizeWeight(0.8);
        right.add(new BorderPanel(this.simulationStatusPanel, STRINGLIST.getString("EVENTS_STATUS_TITLE")));
        right.add(new BorderPanel(this.simulationControl, "Simulation Control"));
        this.labelsPanel.add(right);
    }

    private void addValue(final int eventNumber, final int idx, final Double value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VectorPanel panel = OutlinePanel.this.rssPanel.getPanel(idx);
                if (panel != null) {
                    panel.appendValue(eventNumber, value);
                }
            }
        });
    }

    private void setDataForRssCharts() {
        SimulationResultImpl results = this.workspace.getSimulationResults();
        List<Results> seamcatResults = results.getSeamcatResults();
        if (seamcatResults.isEmpty()) {
            return;
        }
        List<VectorResultType> vectors = seamcatResults.get(0).getVectorResultTypes();
        double[] unw = vectors.get(0).getValue().asArray();
        double[] blo = vectors.get(1).getValue().asArray();
        VectorResultType vector = seamcatResults.get(0).findVector(GenericSystemPlugin.DRSS);
        double[] drss = null;
        if (vector != null) {
            drss = vector.getValue().asArray();
        }
        int total = this.workspace.getSimulationControl().numberOfEvents();
        this.initialize(total);
        for (int eventNb = 0; eventNb < total; ++eventNb) {
            if (!this.signalFilter(eventNb)) continue;
            if (drss != null) {
                this.rssPanel.getPanel(0).appendValue(eventNb, drss[eventNb]);
            }
            this.rssPanel.getPanel(1).appendValue(eventNb, unw[eventNb]);
            this.rssPanel.getPanel(2).appendValue(eventNb, blo[eventNb]);
        }
        if (drss != null) {
            this.panelStatistics(drss, 0);
        }
        this.panelStatistics(unw, 1);
        this.panelStatistics(blo, 2);
    }

    private void addVictimResult(List<LinkResult> samples) {
        for (LinkResult result : samples) {
            Point2D tx = result.txAntenna().getPosition();
            this.scenarioOutlineModel.addToVictimTransmitterSeries(tx, this.victimTransmitterArguments(result));
            Point2D rx = result.rxAntenna().getPosition();
            this.scenarioOutlineModel.addToVictimReceiverSeries(rx, this.victimReceiverArguments(result));
        }
    }

    private void addInterfererResult(List<LinkResult> samples) {
        for (LinkResult interfererResult : samples) {
            int index = 0;
            if (interfererResult.hasValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX)) {
                index = (Integer)interfererResult.getValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX);
            }
            Argument[] arrayIT = new Argument[8];
            arrayIT[0] = this.getEventNumber(interfererResult);
            arrayIT[1] = this.argument("Antenna height:", interfererResult.txAntenna().getHeight(), "m");
            arrayIT[2] = this.argument("Transmit power:", interfererResult.getTxPower(), "dBm");
            arrayIT[3] = this.argument("Frequency:", interfererResult.getFrequency(), "MHz");
            this.antennaGain(arrayIT, 4, "ILT to ILR", interfererResult.txAntenna().getGain(), interfererResult.txAntenna().getAzimuth(), interfererResult.txAntenna().getElevation());
            arrayIT[7] = this.argument("Pathloss to ILR :", interfererResult.getTxRxPathLoss(), "dB");
            Point2D tx = interfererResult.txAntenna().getPosition();
            this.scenarioOutlineModel.addToInterferingTransmitterSeries(index, tx, arrayIT);
            Argument[] arrayIR = new Argument[5];
            arrayIR[0] = this.getEventNumber(interfererResult);
            arrayIR[1] = this.argument("Antenna height:", interfererResult.rxAntenna().getHeight(), "m");
            this.antennaGain(arrayIR, 2, "ILR to ILT", interfererResult.rxAntenna().getGain(), interfererResult.rxAntenna().getAzimuth(), interfererResult.rxAntenna().getElevation());
            Point2D rx = interfererResult.rxAntenna().getPosition();
            this.scenarioOutlineModel.addToInterferingReceiverSeries(index, rx, arrayIR);
        }
    }

    private Argument[] victimReceiverArguments(LinkResult result) {
        Argument[] arrayVR = new Argument[6];
        arrayVR[0] = this.getEventNumber(result);
        arrayVR[1] = this.argument("Antenna height:", result.rxAntenna().getHeight(), "m");
        arrayVR[2] = this.argument("Frequency:", result.getFrequency(), "MHz");
        this.antennaGain(arrayVR, 3, "VLR to VLT", result.rxAntenna().getGain(), result.rxAntenna().getAzimuth(), result.rxAntenna().getElevation());
        return arrayVR;
    }

    private Argument[] victimTransmitterArguments(LinkResult result) {
        Argument[] arrayVT = new Argument[8];
        arrayVT[0] = this.getEventNumber(result);
        arrayVT[1] = this.argument("Antenna height:", result.txAntenna().getHeight(), "m");
        arrayVT[2] = this.argument("Transmit power:", result.getTxPower(), "dBm");
        arrayVT[3] = this.argument("Frequency:", result.getFrequency(), "MHz");
        this.antennaGain(arrayVT, 4, "VLT to VLR", result.txAntenna().getGain(), result.txAntenna().getAzimuth(), result.txAntenna().getElevation());
        arrayVT[7] = this.argument("Pathloss to VLR :", result.getTxRxPathLoss(), "dB");
        return arrayVT;
    }

    private Argument getEventNumber(LinkResult result) {
        String title = "";
        if (result.hasValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX)) {
            title = "Link " + (1 + (Integer)result.getValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX)) + " ";
        }
        if (result.hasValue(LinkResultMarshaller.EVENT_NUMBER)) {
            return new Argument(title + "Event number:", Integer.toString((Integer)result.getValue(LinkResultMarshaller.EVENT_NUMBER)), "");
        }
        return new Argument(title + "Event number:", "N/A", "");
    }

    private Argument argument(String title, Object value, String unit) {
        return new Argument(title, String.valueOf(this.formatter.format(value)), unit);
    }

    private void antennaGain(Argument[] target, int index, String prefix, double gain, double azimuth, double elevation) {
        target[index] = this.argument(prefix + " antenna gain:", gain, "dB");
        target[index + 1] = this.argument(prefix + " azimuth angle:", azimuth, "deg");
        target[index + 2] = this.argument(prefix + " elevation angle:", elevation, "deg");
    }

    public ScenarioOutlineModel getModel() {
        return this.scenarioOutlineModel;
    }

    private void initialize(int totalEvents) {
        this.step100 = totalEvents / 100;
        this.progressStep = totalEvents / maxProgressSteps;
        this.eventsToBeCalculated = totalEvents;
    }

    @Override
    public void simulationBegin(final int totalEvents) {
        this.view.show(this);
        this.initialize(totalEvents);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OutlinePanel.this.simulationControl.simulationBegin(totalEvents);
                OutlinePanel.this.clearAllElements();
                OutlinePanel.this.rssPanel.reset();
                ((XYPlot)OutlinePanel.this.chart.getPlot()).getRangeAxis().setRange(-1.0, 1.0);
                ((XYPlot)OutlinePanel.this.chart.getPlot()).getRangeAxis().setAutoRange(true);
                ((XYPlot)OutlinePanel.this.chart.getPlot()).getDomainAxis().setRange(-1.0, 1.0);
                ((XYPlot)OutlinePanel.this.chart.getPlot()).getDomainAxis().setAutoRange(true);
                OutlinePanel.this.simulationStatusPanel.startingEventGeneration(OutlinePanel.this.eventsToBeCalculated);
            }
        });
    }

    private boolean signalFilter(int eventNo) {
        return this.eventsToBeCalculated < 100 || eventNo % this.step100 == 0;
    }

    private boolean incrementFilter(int eventNo) {
        return this.eventsToBeCalculated < maxProgressSteps || eventNo % this.progressStep == 0;
    }

    @Override
    public void eventComplete(final SingleResult result) {
        final int eventNo = result.eventNo;
        if (result.hasSamples() || this.signalFilter(eventNo) || this.incrementFilter(eventNo)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutlinePanel.this.simulationControl.eventComplete(result);
                    if (OutlinePanel.this.incrementFilter(eventNo)) {
                        OutlinePanel.this.simulationStatusPanel.increment();
                    }
                    if (OutlinePanel.this.signalFilter(eventNo)) {
                        OutlinePanel.this.handleAddPoint(eventNo, result.vResults);
                    }
                    if (result.hasSamples()) {
                        for (LinkResult sample : result.victimSamples) {
                            sample.setValue(LinkResultMarshaller.EVENT_NUMBER, eventNo);
                        }
                        OutlinePanel.this.addVictimResult(result.victimSamples);
                        for (LinkResult sample : result.interfererSamples) {
                            sample.setValue(LinkResultMarshaller.EVENT_NUMBER, eventNo);
                        }
                        OutlinePanel.this.addInterfererResult(result.interfererSamples);
                    }
                }
            });
        }
    }

    private void handleAddPoint(int eventNo, VictimResultCollector vCollector) {
        Double value = vCollector.get(GenericSystemPlugin.DRSS);
        if (value != null) {
            this.addValue(eventNo, 0, value);
        }
        this.addValue(eventNo, 1, vCollector.get(this.unw));
        this.addValue(eventNo, 2, vCollector.get(this.blo));
    }

    private void updateStatistics() {
        SimulationResultImpl simulationResult = this.workspace.getSimulationResults();
        Results victimResults = simulationResult.getVictimResults();
        List<VectorResultType> vectors = victimResults.getVectorResultTypes();
        if (this.workspace.getVictimSystem() instanceof GenericSystemPlugin) {
            VectorResultType drss = victimResults.findVector(GenericSystemPlugin.DRSS);
            this.panelStatistics(drss.getValue().asArray(), 0);
        }
        this.panelStatistics(vectors.get(0).getValue().asArray(), 1);
        this.panelStatistics(vectors.get(1).getValue().asArray(), 2);
    }

    @Override
    public void simulationEnd() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RSSEvent rssEvent = new RSSEvent(OutlinePanel.this.workspace);
                SimulationResultImpl simulationResult = OutlinePanel.this.workspace.getSimulationResults();
                List<VectorResultType> vectors = simulationResult.getVictimResults().getVectorResultTypes();
                rssEvent.setIrssU(GenericSystemPlugin.calculate(vectors.get(0).getValue().asArray()));
                rssEvent.setIrssB(GenericSystemPlugin.calculate(vectors.get(1).getValue().asArray()));
                if (OutlinePanel.this.workspace.getVictimSystem() instanceof GenericSystemPlugin) {
                    rssEvent.setRss(GenericSystemPlugin.calculate(vectors.get(2).getValue().asArray()));
                }
                OutlinePanel.this.handle(rssEvent);
                OutlinePanel.this.simulationStatusPanel.eventGenerationCompleted();
                OutlinePanel.this.simulationControl.simulationEnd();
            }
        });
    }

    private void panelStatistics(double[] values, int group) {
        if (values == null) {
            return;
        }
        double mean = Mathematics.getAverage(values);
        double stdDev = Mathematics.getStdDev(values);
        this.rssPanel.getPanel(group).addStatistics(mean, stdDev);
    }

    @UIEventHandler
    public void handle(RSSEvent event) {
        if (event.getContext() == this.workspace) {
            this.eventStatsPanel.handle(event);
            this.updateStatistics();
        }
    }
}

