/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.CapacityStartingCapacityFinding;
import org.seamcat.events.ErrorDuringSimulation;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.RSSEvent;
import org.seamcat.events.SimulationCompleteEvent;
import org.seamcat.events.SimulationErrorEvent;
import org.seamcat.events.VectorValues;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.Scenario;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.LinkResultSamplesImpl;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.eventprocessing.PostProcessingUIPanels;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.factory.DataExporterImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.DataExporter;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Service;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.AsVictimPostProcessingTab;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.systems.cdma.SystemModelCDMADownLink;
import org.seamcat.model.systems.cdma.SystemModelCDMAUpLink;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.objectutils.WorkspaceCloneHelper;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.PostProcessingUIState;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.ReplayAction;
import org.seamcat.presentation.SimulationLogDialog;
import org.seamcat.presentation.SizeEstimator;
import org.seamcat.presentation.Utils;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.compare.WorkspaceVectors;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.display.MouseClickTypeHandler;
import org.seamcat.presentation.eventprocessing.ControlButton;
import org.seamcat.presentation.simulationview.outline.OutlinePanel;
import org.seamcat.presentation.simulationview.replay.SingleEventPanel;
import org.seamcat.presentation.simulationview.replay.SingleEventSimulationResult;
import org.seamcat.presentation.simulationview.results.EventResultDetailPanel;
import org.seamcat.presentation.simulationview.results.SimulationResultGroupTableModel;
import org.seamcat.presentation.simulationview.results.WorkspaceReadOnlyView;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.presentation.systems.cdma.CDMASystemPlotPanel;
import org.seamcat.presentation.systems.cdma.CapacityFindingStatusPanel;
import org.seamcat.scenario.WorkspaceScenario;
import org.seamcat.simulation.Simulation;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.ResultsImpl;
import org.seamcat.simulation.result.SimulationResultImpl;

public class SimulationView
extends JTabbedPane {
    private static final Logger LOG = Logger.getLogger(SimulationView.class);
    private Workspace workspace;
    private SimulationResult original;
    private PartialSimulationResults partial;
    private InterferenceSimulationEngine engine;
    private Map<JPanel, Object> preProcessingUI = new LinkedHashMap<JPanel, Object>();
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private OutlinePanel outline;
    private List<PostProcessingUIPanels> ppUIs = new ArrayList<PostProcessingUIPanels>();
    private List<SimulationResultGroupTableModel> results = new ArrayList<SimulationResultGroupTableModel>();
    private boolean isClose;
    private boolean dirty;

    public WorkspaceVectors getResultVectors() {
        return new WorkspaceVectors(this.workspace.getName(), this.workspace.getSimulationResults());
    }

    public SimulationView(Workspace workspace, PartialSimulationResults partial) {
        super(1);
        this.partial = partial;
        this.workspace = workspace;
        workspace.setSimulationResult(new SimulationResultImpl());
        LinkResultSamplesImpl samples = new LinkResultSamplesImpl(partial.getVictimSamples(), partial.getInterfererSamples());
        workspace.getSimulationResults().setLinkResultSamples(samples);
        this.original = WorkspaceCloneHelper.clone(workspace.getSimulationResults());
        Subscriber.subscribe(this);
        this.showOutlinePanel();
        this.showPreProcessingPanels();
    }

    public SimulationView(Workspace workspace, boolean aboutToSimulate) {
        super(1);
        this.workspace = workspace;
        this.original = WorkspaceCloneHelper.clone(workspace.getSimulationResults());
        Subscriber.subscribe(this);
        this.showOutlinePanel();
        this.showPreProcessingPanels();
    }

    public void show(Component tab) {
        this.setSelectedComponent(tab);
    }

    public SimulationView(Workspace workspace) {
        super(1);
        this.workspace = workspace;
        this.original = WorkspaceCloneHelper.clone(workspace.getSimulationResults());
        Subscriber.subscribe(this);
        this.showOutlinePanel();
        this.showSimulationCompletePanels();
        RSSEvent rssEvent = new RSSEvent(workspace);
        rssEvent.setRss(this.get(workspace.getSimulationResults(), GenericSystemPlugin.DRSS.name()));
        SystemPlugin victim = workspace.getScenario().getVictim().getSystemPlugin();
        if (victim instanceof InterferenceNames) {
            InterferenceNames names = (InterferenceNames)((Object)victim);
            rssEvent.setIrssU(this.get(workspace.getSimulationResults(), names.unwantedName()));
            rssEvent.setIrssB(this.get(workspace.getSimulationResults(), names.blockingName()));
        } else {
            rssEvent.setIrssU(this.get(workspace.getSimulationResults(), VectorDefinitions.IRSSU));
            rssEvent.setIrssB(this.get(workspace.getSimulationResults(), VectorDefinitions.IRSSB));
        }
        EventBusFactory.getEventBus().publish(rssEvent);
        EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("OPEN_WORKSPACE_HAS_RESULTS")));
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void simulate() {
        Simulation simulation = new Simulation(this.workspace, this.workspace.getScenario(), this.outline);
        InterferenceSimulationEngine engine = new InterferenceSimulationEngine(simulation);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimulationView.this.show(SimulationView.this.outline);
            }
        });
        this.simulate(simulation, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulate(Simulation simulation, InterferenceSimulationEngine engine) {
        this.engine = engine;
        try {
            this.partial = null;
            File logFile = this.workspace.simulate(simulation, engine);
            this.showSimulationCompletePanels();
            this.simulationComplete(this.workspace.getSimulationControl().numberOfEvents() - 1, this.workspace);
            EventBusFactory.getEventBus().publish(new SimulationCompleteEvent());
            this.updateModel();
            if (this.workspace.getSimulationControl().debugMode()) {
                new SimulationLogDialog(logFile).display();
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format(STRINGLIST.getString("EGE_LOGGING"), logFile.getAbsolutePath())));
            }
        }
        finally {
            MainWindow.getInstance().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void stop() {
        this.engine.stop();
        this.engine = null;
        EventBusFactory.getEventBus().publish(new SimulationErrorEvent(this, new SimulationInvalidException("Stopped", null)));
    }

    public void pause() {
        this.partial = this.engine.stop();
        EventBusFactory.getEventBus().publish(new SimulationCompleteEvent());
    }

    public PartialSimulationResults getPartial() {
        return this.partial;
    }

    public void resume() {
        if (this.partial != null) {
            Runnable partialSimulation = new Runnable(){

                @Override
                public void run() {
                    Simulation simulation = new Simulation(SimulationView.this.workspace, SimulationView.this.workspace.getScenario(), SimulationView.this.outline);
                    SimulationView.this.simulate(simulation, new InterferenceSimulationEngine(simulation, SimulationView.this.partial));
                }
            };
            MainWindow.singleThreadPool.submit(partialSimulation);
        }
    }

    private VectorValues get(SimulationResultImpl simulationResult, String vectorName) {
        Results victimGroup = simulationResult.getSeamcatResults().get(0);
        for (VectorResultType vector : victimGroup.getVectorResultTypes()) {
            if (!vector.getName().equals(vectorName)) continue;
            return GenericSystemPlugin.calculate(vector.getValue().asArray());
        }
        return new VectorValues("N/A", "N/A", "N/A");
    }

    private void destroy() {
        Subscriber.unSubscribeDeep(this);
        this.outline.destroy();
        this.outline = null;
        this.removeAll();
        this.workspace = null;
    }

    private void showPreProcessingPanels() {
        if (this.workspace.hasDMASubSystem()) {
            LinkedHashSet<SystemPlugin> ss = new LinkedHashSet<SystemPlugin>();
            WorkspaceScenario scenario = this.workspace.getScenario();
            ss.add(scenario.getVictim().getSystemPlugin());
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                ss.add(link.getInterferer().getSystemPlugin());
            }
            for (SystemPlugin s : ss) {
                CapacityFindingStatusPanel capacityPanel;
                SystemModel ui;
                if (s instanceof HybridCDMAUpLinkPlugin) {
                    ui = (SystemModelCDMAUpLink)s.getUI();
                    if (!ui.generalSettings().cdmaCapacity().simulateNonInterferedCapacity()) continue;
                    capacityPanel = new CapacityFindingStatusPanel(ui, this);
                    this.add("CDMA Capacity Finding (" + ui.description().name() + ")", capacityPanel);
                    this.preProcessingUI.put(capacityPanel, ui);
                    continue;
                }
                if (!(s instanceof HybridCDMADownLinkPlugin) || !(ui = (SystemModelCDMADownLink)s.getUI()).generalSettings().cdmaCapacity().simulateNonInterferedCapacity()) continue;
                capacityPanel = new CapacityFindingStatusPanel(ui, this);
                this.add("CDMA Capacity Finding (" + ui.description().name() + ")", capacityPanel);
                this.preProcessingUI.put(capacityPanel, ui);
            }
        }
    }

    private void appendTable(SimulationResultGroupTableModel model, JPanel resultsPanel) {
        JTable table = new JTable(model);
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseClickTypeHandler(table));
        int width = table.getPreferredSize().width;
        int height = Math.min(5, (1 + model.getRowCount()) * table.getRowHeight());
        table.setPreferredScrollableViewportSize(new Dimension(width, height));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)table.getTableHeader(), "North");
        jPanel.add((Component)table, "Center");
        if (model.getHelpContents() != null) {
            resultsPanel.add(new BorderPanel(jPanel, model.toString(), "See SEAMCAT manual", model.getHelpContents()));
        } else {
            resultsPanel.add(new BorderPanel(jPanel, model.toString()));
        }
    }

    public void updateResults() {
        for (SimulationResultGroupTableModel result : this.results) {
            result.update();
        }
    }

    private void showSimulationCompletePanels() {
        JSplitPane resultsTab = new JSplitPane(1);
        resultsTab.setDividerLocation(700);
        resultsTab.add(new WorkspaceReadOnlyView(this.workspace, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Workspace clone = WorkspaceCloneHelper.clone(SimulationView.this.workspace);
                clone.setName("Exported " + clone.getName());
                MainWindow.getInstance().addWorkspaceViewToPanel(new WorkspaceView(clone), clone.getName());
            }
        }, new ReplayAction(){

            @Override
            public void replay(final long simulationSeed, final int eventNumber) {
                int max = SimulationView.this.workspace.getSimulationControl().numberOfEvents() - 1;
                if (eventNumber < 0 || eventNumber > max) {
                    DialogHelper.replayEventError(max, eventNumber);
                    return;
                }
                MainWindow.singleThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.getInstance().setCursorBusy();
                        try {
                            SingleEventSimulationResult result = SimulationView.this.workspace.simulateSingle(simulationSeed, eventNumber);
                            result.getSimulatedWorkspace().cellularVictimSimulation = ((SimulationView)SimulationView.this).workspace.cellularVictimSimulation;
                            SimulationView.this.simulationComplete(eventNumber, result.getSimulatedWorkspace());
                            EventBusFactory.getEventBus().publish(new InfoMessageEvent("Log file for trace saved in '" + result.getLogFile().getAbsolutePath() + "'"));
                            Utils.addClosableTab(new SingleEventPanel(result, SimulationView.this), "Replay [event=" + result.getEventResult().getEventNumber() + "]", SimulationView.this);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            MainWindow.getInstance().setCursorDefault();
                        }
                    }
                });
            }
        }));
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 1));
        resultsTab.add(new JScrollPane(resultsPanel));
        resultsPanel.removeAll();
        this.results.clear();
        if (this.workspace.getSimulationResults() != null) {
            this.writeGroup(this.workspace.getSimulationResults().getSeamcatResults(), false, resultsPanel);
            this.writeGroup(this.workspace.getSimulationResults().getEventProcessingResults(), true, resultsPanel);
        }
        this.add(STRINGLIST.getString("TAB_TEXT_SIMULATION_RESULTS"), resultsTab);
        this.addPostProcessingUIs();
    }

    private void showOutlinePanel() {
        this.outline = new OutlinePanel(this.workspace, this);
        this.add(STRINGLIST.getString("TAB_TEXT_SIMULATION_OUTLINE"), this.outline);
    }

    private void addPostProcessingUIs() {
        for (EventProcessing config : this.workspace.getScenario().getEventProcessingList()) {
            EventProcessingConfiguration conf = (EventProcessingConfiguration)config;
            Results currentGroup = null;
            for (Results group : this.workspace.getSimulationResults().getEventProcessingResults()) {
                if (!group.getId().equals(conf.getId())) continue;
                currentGroup = group;
            }
            if (currentGroup == null) continue;
            List<Class<PostProcessingUI>> tabs = conf.tabs();
            for (int index = 0; index < tabs.size(); ++index) {
                this.appendPPUIPanel(index, tabs.get(index), currentGroup, conf.getModelClass(), conf.getModel());
            }
        }
        List<Class<? extends PostProcessingUI>> victimPPUIs = null;
        SystemPlugin victimPlugin = this.workspace.getScenario().getVictim().getSystemPlugin();
        if (victimPlugin instanceof AsVictimPostProcessingTab) {
            victimPPUIs = ((AsVictimPostProcessingTab)((Object)victimPlugin)).tabs();
        }
        if (victimPPUIs != null) {
            Results victimGroup = this.workspace.getSimulationResults().getSeamcatResults().get(0);
            for (int i = 0; i < victimPPUIs.size(); ++i) {
                this.appendPPUIPanel(i, victimPPUIs.get(i), victimGroup, null, null);
            }
        }
    }

    private PostProcessingUIState ensure(int index, Results group, PostProcessingUI postProcessingUI) {
        ResultsImpl results = (ResultsImpl)group;
        if (results.getPostProcessingState().size() == index) {
            PostProcessingUIState state = new PostProcessingUIState(group.getId(), new LinkedHashMap());
            results.getPostProcessingState().add(state);
            for (PanelDefinition definition : postProcessingUI.panelDefinitions()) {
                state.get().put(definition, Factory.instance(definition.getModelClass()));
            }
        }
        return results.getPostProcessingState().get(index);
    }

    private void appendPPUIPanel(int index, Class<? extends PostProcessingUI> aClass, Results group, Class confClass, Object confModel) {
        try {
            PostProcessingUI postProcessingUI = aClass.newInstance();
            for (Field field : aClass.getDeclaredFields()) {
                if (field.getAnnotation(Service.class) == null || !field.getType().equals(DataExporter.class)) continue;
                field.setAccessible(true);
                field.set(postProcessingUI, new DataExporterImpl());
            }
            PostProcessingUIPanels tab = new PostProcessingUIPanels(postProcessingUI, this.ensure(index, group, postProcessingUI));
            this.ppUIs.add(tab);
            JPanel canvas = new JPanel(new BorderLayout());
            tab.buildUI(this.workspace.getScenario(), canvas, tab.getPanels());
            JPanel controlPanel = new JPanel(new FlowLayout());
            for (Map.Entry entry : Cache.ordered(PostProcessing.class, aClass, new Cache.Order<PostProcessing>(){

                @Override
                public int getOrder(PostProcessing postProcessing) {
                    return postProcessing.order();
                }
            }).entrySet()) {
                String name = ((PostProcessing)entry.getValue()).name();
                Class<?>[] parameterTypes = ((Method)entry.getKey()).getParameterTypes();
                if (parameterTypes.length >= 5) continue;
                Object[] arguments = new Object[parameterTypes.length];
                int indexOfResultTypes = -1;
                int indexOfSimulationResults = -1;
                boolean validControlButton = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> type = parameterTypes[i];
                    if (Scenario.class.isAssignableFrom(type)) {
                        arguments[i] = this.workspace.getScenario();
                        continue;
                    }
                    if (confClass != null && confClass.isAssignableFrom(type)) {
                        arguments[i] = confModel;
                        continue;
                    }
                    if (Results.class.isAssignableFrom(type)) {
                        indexOfResultTypes = i;
                        continue;
                    }
                    if (SimulationResult.class.isAssignableFrom(type)) {
                        indexOfSimulationResults = i;
                        continue;
                    }
                    validControlButton = false;
                    break;
                }
                if (!validControlButton) continue;
                ControlButton button = new ControlButton(this, name, (Method)entry.getKey(), tab.getDecorated(), arguments, indexOfResultTypes, indexOfSimulationResults);
                button.setSimulationResult(this.workspace.getSimulationResults());
                button.setResults(group);
                controlPanel.add(button);
            }
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)canvas, "Center");
            jPanel.add((Component)controlPanel, "South");
            this.add(tab.getTitle(), jPanel);
        }
        catch (Exception e) {
            LOG.error("Error creating post processing ui", e);
        }
    }

    private void simulationComplete(int lastEventIndex, Workspace simulatedWorkspace) {
        EventResult last;
        if (simulatedWorkspace.hasDMASubSystem()) {
            CDMASystemPlotPanel plot = new CDMASystemPlotPanel(this.createUIModel(simulatedWorkspace), lastEventIndex);
            plot.refresh();
            Utils.addClosableTab(plot, STRINGLIST.getString("TAB_TEXT_CELLULAR_STRUCTURE"), this);
        }
        if ((last = simulatedWorkspace.getLastEventResult()) != null) {
            Utils.addClosableTab(new EventResultDetailPanel(this.workspace.getScenario(), last), "Event Results [event #" + lastEventIndex + "]", this);
        }
    }

    private Map<String, CDMAPlotModel> createUIModel(Workspace workspace) {
        LinkedHashMap<String, CDMAPlotModel> map = new LinkedHashMap<String, CDMAPlotModel>();
        if (workspace.getVictimSystem() instanceof HybridSystemPlugin) {
            HybridSystemPlugin plugin = (HybridSystemPlugin)workspace.getVictimSystem();
            CDMAPlotModel model = this.create(true, workspace.cellularVictimSimulation, workspace.getLastEventResult(), plugin);
            model.name = workspace.getVictimSystem().getUI().description().name();
            map.put("Victim:" + model.name, model);
        }
        List<InterferenceLink> interferenceLinks = workspace.getInterferenceLinks();
        for (int i = 0; i < interferenceLinks.size(); ++i) {
            InterferenceLink link = interferenceLinks.get(i);
            if (!(link.getInterferer().getSystemPlugin() instanceof HybridSystemPlugin)) continue;
            HybridSystemPlugin plugin = (HybridSystemPlugin)link.getInterferer().getSystemPlugin();
            CDMAPlotModel model = this.create(false, workspace.cellularInterferingSystemSimulation.get(i + 1), workspace.getLastEventResult(), plugin);
            model.name = link.getInterferer().getSystemPlugin().getUI().description().name();
            model.victimSystem = false;
            map.put(i + ":" + model.name, model);
        }
        return map;
    }

    private CDMAPlotModel create(boolean isVictim, AbstractDmaSystem system, EventResult last, HybridSystemPlugin plugin) {
        CDMAPlotModel model = new CDMAPlotModel();
        model.eventResult = last;
        model.victimSystem = isVictim;
        model.cellularSystem = system.getRadioSystem();
        model.plugin = plugin;
        model.isUplink = system.isUplink();
        model.collector = system.getCollector();
        model.activeUsers = new ArrayList(system.getActiveUsers());
        if (system instanceof CDMASystem) {
            CDMASystem cs = (CDMASystem)system;
            model.droppedUsers = new ArrayList<CdmaUserTerminal>(cs.getDroppedUsers());
            model.inactiveUsers = new ArrayList<CdmaUserTerminal>(cs.getInactiveUsers());
        } else {
            model.droppedUsers = new ArrayList<AbstractDmaMobile>();
            model.inactiveUsers = new ArrayList<AbstractDmaMobile>();
        }
        model.baseStations = system.getBaseStationArray();
        if (isVictim) {
            model.externalInterferers = new ArrayList<Interferer>();
            for (InterfererResultCollector result : last.getAllInterferingSystemResults()) {
                model.externalInterferers.addAll(result.getInterferingElements());
            }
            model.victims = new ArrayList<Victim>();
            for (Victim victim : last.getVictimResult().getVictims()) {
                model.victims.add(victim);
            }
        } else {
            model.externalInterferers = Collections.emptyList();
        }
        model.location = system.getLocation();
        model.referenceCell = system.getReferenceCell();
        model.frequency = system.getFrequency();
        model.intercellDistance = system.getInterCellDistance();
        if (system instanceof OfdmaSystem) {
            model.processingGain = system.getProcessingGain();
        }
        if (system instanceof CDMASystem) {
            model.numberOfLLDFound = ((CDMASystem)system).getNumberOfNoLinkLevelDataUsers();
            if (system instanceof CDMADownlinkSystem) {
                model.maxTrafficChannelPower = Math.round(Mathematics.fromWatt2dBm(((CDMADownlinkSystem)system).getMaxTrafficChannelPowerInWatt()));
            }
        }
        return model;
    }

    private void writeGroup(List<Results> group, boolean allowEmpty, JPanel resultsPanel) {
        if (group == null || group.isEmpty()) {
            return;
        }
        for (Results gr : group) {
            if (!allowEmpty && gr.isEmpty()) continue;
            SimulationResultGroupTableModel simModel = new SimulationResultGroupTableModel(gr);
            this.appendTable(simModel, resultsPanel);
            this.results.add(simModel);
        }
    }

    public void updateModel() {
        for (PostProcessingUIPanels ppUI : this.ppUIs) {
            ppUI.updateModel();
        }
    }

    @UIEventHandler
    public void handleErrorDuringSimulation(ErrorDuringSimulation error) {
        if (error.getContext() == this.workspace) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html><b>Exception message:</b> " + error.getSimulationException().getMessage() + "\nUnexpected expected exception occurred during simulation. Simulation will stop", error.getMessage(), 0);
        }
    }

    @UIEventHandler
    public void startCapacityFinding(CapacityStartingCapacityFinding start) {
        WorkspaceScenario scenario = this.workspace.getScenario();
        for (Map.Entry<JPanel, Object> entry : this.preProcessingUI.entrySet()) {
            if (entry.getValue() != start.getContext()) continue;
            this.show(entry.getKey());
        }
    }

    public boolean dirty() {
        this.updateModel();
        return !WorkspaceCloneHelper.equals(this.workspace.getSimulationResults(), this.original);
    }

    private boolean hasResults() {
        return this.workspace.getSimulationResults() != null;
    }

    private boolean tooBig() {
        return this.hasResults() && SizeEstimator.resultsTooLargeForSaveOrLoad(this.workspace);
    }

    public boolean save() {
        this.isClose = false;
        this.dirty = this.dirty();
        return this.handleSpecialCasesSave();
    }

    public boolean close() {
        this.isClose = true;
        this.dirty = this.dirty();
        boolean result = !this.dirty ? true : this.handleSpecialCasesSave();
        if (result) {
            this.destroy();
        }
        return result;
    }

    private boolean handleSpecialCasesSave() {
        boolean tooBig = this.tooBig();
        if (this.isClose && tooBig) {
            return this.closeCleanAndUnmodifiedBig();
        }
        if (this.isClose) {
            return this.closeCleanAndUnmodified();
        }
        if (tooBig) {
            return this.saveCleanAndUnmodifiedBig();
        }
        return this.saveCleanAndUnmodified();
    }

    private boolean saveCleanAndUnmodified() {
        this.saveWorkspace(this.workspace);
        return true;
    }

    private boolean closeCleanAndUnmodified() {
        long eventSizeEstimate = SizeEstimator.eventFileSizeEstimate(this.workspace);
        int result = DialogHelper.saveResultsWhenClosing("Results[" + this.workspace.getName() + "]", eventSizeEstimate);
        switch (result) {
            case 0: {
                this.saveWorkspace(this.workspace);
                return true;
            }
            case 1: {
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("WORKSPACE_NOT_SAVED")));
                return true;
            }
        }
        EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("CANCEL_CLOSE_OPERATION")));
        return false;
    }

    private boolean closeCleanAndUnmodifiedBig() {
        int result = DialogHelper.closeCleanAndUnmodifiedBig(this.workspace.getName());
        switch (result) {
            case 0: {
                this.saveWorkspace(this.workspace);
                return true;
            }
            case 1: {
                EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("CLOSE_WORKSPACE_NOT_SAVED")));
                return true;
            }
        }
        EventBusFactory.getEventBus().publish(new InfoMessageEvent(STRINGLIST.getString("CANCEL_CLOSE_OPERATION")));
        return false;
    }

    private boolean saveCleanAndUnmodifiedBig() {
        int selection = DialogHelper.saveCleanAndUnmodifiedBig(this.workspace.getName());
        switch (selection) {
            case 0: {
                this.saveWorkspace(this.workspace);
                return true;
            }
        }
        return false;
    }

    public void saveWorkspaceAs(File file) {
        this.updateModel();
        this.workspace.setPath(file);
        String name = file.getName().substring(0, file.getName().lastIndexOf("."));
        this.workspace.setName(name);
        boolean tooBig = this.tooBig();
        if (tooBig) {
            this.saveCleanAndUnmodifiedBig();
        }
        this.saveCleanAndUnmodified();
    }

    private void saveWorkspace(Workspace workspace) {
        if (this.partial != null) {
            workspace.setPartial(this.partial);
        } else {
            this.original = WorkspaceCloneHelper.clone(workspace.getSimulationResults());
        }
        MainWindow.getInstance().saveWorkspace(workspace);
    }

    @Override
    public String toString() {
        if (this.workspace != null) {
            return this.workspace.getName();
        }
        return super.toString();
    }
}

