/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.report;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seamcat.events.VectorValues;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Library;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.CalculatedValue;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.presentation.report.ReportNode;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class ReportGenerator {
    public static List<ReportNode> generate(boolean withScenario, boolean withResults, boolean expand, Workspace workspace) {
        ArrayList<ReportNode> sections = new ArrayList<ReportNode>();
        if (withScenario) {
            for (SystemPlugin systemPlugin : workspace.getSystemPlugins()) {
                ReportNode sys = new ReportNode(systemPlugin.getUI().description().name());
                sections.add(sys);
                Class<? extends SystemModel> modClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
                ReportGenerator.compositeGroup(sys, modClass, systemPlugin.getUI());
            }
            ReportNode scenario = new ReportNode("Scenario");
            sections.add(scenario);
            scenario.addValue("Victim System", workspace.getVictimSystem().getUI().description().name());
            ReportGenerator.group(scenario, SimulationControl.class, workspace.getSimulationControl());
            for (InterferenceLinkElement element : workspace.getInterferenceLinkUIs()) {
                ReportNode iGroup = scenario.addNode(element.getName());
                ReportGenerator.compositeGroup(iGroup, InterferenceLinkUI.class, element.getSettings());
            }
            for (EventProcessingConfiguration epp : workspace.getEventProcessingList()) {
                ReportNode eGroup = scenario.addNode(epp.getPlugin().description().name());
                ReportGenerator.group(eGroup, epp.getModelClass(), epp.getModel());
            }
        }
        if (withResults) {
            ReportNode results = new ReportNode("Simulation Results");
            sections.add(results);
            ReportGenerator.results(expand, results, workspace.getSimulationResults().getSeamcatResults());
            List<Results> list = workspace.getSimulationResults().getEventProcessingResults();
            if (list != null && list.size() > 0) {
                ReportNode eppResults = new ReportNode("Event Processing Results");
                sections.add(eppResults);
                ReportGenerator.results(expand, eppResults, list);
            }
        }
        return sections;
    }

    private static void results(boolean expand, ReportNode node, List<Results> groups) {
        for (Results group : groups) {
            Iterator iterator;
            ReportNode g = node.addNode(group.getName());
            for (SingleValueTypes<?> singleValueTypes : group.getSingleValueTypes()) {
                g.addValue(singleValueTypes.def().name(), singleValueTypes.value(), singleValueTypes.def().unit());
            }
            for (VectorResultType vectorResultType : group.nonGrouped()) {
                ReportGenerator.vector(g, expand, vectorResultType);
            }
            for (Map.Entry entry : group.allGroups().entrySet()) {
                g.addValue((String)entry.getKey(), "Vector group[" + ((List)entry.getValue()).size() + "]", ((VectorResultType)((List)entry.getValue()).get(0)).getUnit());
                for (VectorResultType result : (List)entry.getValue()) {
                    ReportGenerator.vector(g, expand, result);
                }
            }
            for (BarChartResultType barChartResultType : group.getBarChartResultTypes()) {
                g.addValue(barChartResultType.def().name(), "Bar chart[" + barChartResultType.value().size() + "]", barChartResultType.def().unit() + "/" + barChartResultType.def().yUnit());
                if (!expand) continue;
                iterator = barChartResultType.value().iterator();
                while (iterator.hasNext()) {
                    BarChartValue value = (BarChartValue)iterator.next();
                    g.addValue("", value.getName(), "" + value.getValue());
                }
            }
            for (ScatterDiagramResultType scatterDiagramResultType : group.getScatterDiagramResultTypes()) {
                g.addValue(scatterDiagramResultType.def().name(), "Scatter[" + scatterDiagramResultType.value().size() + "]", scatterDiagramResultType.def().unit() + "/" + scatterDiagramResultType.def().yUnit());
                if (!expand) continue;
                iterator = scatterDiagramResultType.value().iterator();
                while (iterator.hasNext()) {
                    Point2D point = (Point2D)iterator.next();
                    g.addValue("", point.getX(), "" + point.getY());
                }
            }
        }
    }

    private static void vector(ReportNode g, boolean expandVectors, VectorResultType type) {
        VectorValues values = GenericSystemPlugin.calculate(type.getValue().asArray());
        if (values != null) {
            g.addValue(type.getName(), "Vector[" + type.getValue().size() + "]", type.getUnit());
            g.addValue("Average", values.getMean());
            g.addValue("Median", values.getMedian());
            g.addValue("Std.dev.", values.getStdDev());
            if (expandVectors) {
                g.addValue("Vector values", "");
                double[] asArray = type.getValue().asArray();
                for (int i = 0; i < asArray.length; ++i) {
                    g.addValue("", "" + i, "" + asArray[i]);
                }
            }
        }
    }

    private static void compositeGroup(ReportNode group, Class<?> composite, Object instance) {
        try {
            for (Method m : Cache.ordered(composite)) {
                UIPosition pos;
                UITab tab = m.getAnnotation(UITab.class);
                if (tab != null) {
                    ReportNode tabNode = group.addNode(tab.value());
                    ReportGenerator.compositeGroup(tabNode, m.getReturnType(), m.invoke(instance, new Object[0]));
                }
                if ((pos = m.getAnnotation(UIPosition.class)) == null) continue;
                Object invoke = m.invoke(instance, new Object[0]);
                if (invoke instanceof Configuration) {
                    Configuration conf = (Configuration)invoke;
                    group.addValue(pos.name(), conf.description().name());
                    ReportGenerator.group(group, conf.getModelClass(), conf.getModel());
                    continue;
                }
                ReportNode reportNode = group.addNode(pos.name());
                ReportGenerator.group(reportNode, m.getReturnType(), invoke);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ReportNode group(ReportNode group, Class<?> clazz, Object instance) {
        for (Method m : Cache.orderedConfig(clazz)) {
            try {
                Config config = m.getAnnotation(Config.class);
                Object invoke = m.invoke(instance, new Object[0]);
                if (invoke instanceof Configuration) {
                    Configuration conf = (Configuration)invoke;
                    ReportNode reportNode = group.addNode(Library.name(conf.getClass()));
                    reportNode.addValue("name", conf.description().name());
                    ReportGenerator.group(reportNode, conf.getModelClass(), conf.getModel());
                    continue;
                }
                ReportGenerator.handleValue(group, config.name(), config.unit(), invoke);
            }
            catch (Exception exception) {}
        }
        return group;
    }

    private static void handleValue(ReportNode group, String name, String unit, Object invoke) {
        if (invoke instanceof MaskFunction) {
            ReportNode node = group.addNode(name);
            MaskFunction m = (MaskFunction)invoke;
            if (m.isConstant()) {
                node.addValue("constant", m.getConstant());
            } else {
                for (Point2D point2D : m.getPoints()) {
                    node.addValue("point", point2D.toString() + "; " + m.getMask(point2D));
                }
            }
        } else if (invoke instanceof Function) {
            ReportNode node = group.addNode(name);
            Function f = (Function)invoke;
            if (f.isConstant()) {
                node.addValue("constant", f.getConstant());
            } else {
                for (Point2D point2D : f.getPoints()) {
                    node.addValue("point", point2D);
                }
            }
        } else if (!(invoke instanceof CalculatedValue)) {
            group.addValue(name, invoke, unit);
        }
    }
}

