/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.seamcat.batch.BatchJobList;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Model;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.report.ExcelReportGenerator;
import org.seamcat.presentation.report.HTMLReportGenerator;
import org.seamcat.presentation.report.ReportGenerator;
import org.seamcat.presentation.report.ReportNode;
import org.seamcat.presentation.report.XMLReportGenerator;
import org.seamcat.tabulardataio.TabularDataFactory;
import org.seamcat.tabulardataio.TabularDataSaver;

public class ReportDialog
extends EscapeDialog {
    private static final Logger LOG = Logger.getLogger(ReportDialog.class);
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private JCheckBox scenario = new JCheckBox(STRINGLIST.getString("REPORT_OPTION_SCENARIOS"), true);
    private JCheckBox results = new JCheckBox(STRINGLIST.getString("REPORT_OPTION_RESULTS"), true);
    private JCheckBox expandResults = new JCheckBox(STRINGLIST.getString("REPORT_OPTION_EXPAND_TAB"), false);
    private JRadioButton xMLFile = new JRadioButton("XML File", true);
    private JRadioButton hTMLFile = new JRadioButton("HTML File", false);
    private JRadioButton xlsFile = new JRadioButton("XLS File", false);
    private JRadioButton xlsxFile = new JRadioButton("XLSX File", false);
    private Workspace workspace;
    private BatchJobList batchJobList;
    private String name;

    public ReportDialog() {
        super(MainWindow.getInstance(), "SEAMCAT report generator", true);
        ButtonGroup buttonGroupOutputOptions = new ButtonGroup();
        buttonGroupOutputOptions.add(this.xMLFile);
        buttonGroupOutputOptions.add(this.hTMLFile);
        buttonGroupOutputOptions.add(this.xlsFile);
        buttonGroupOutputOptions.add(this.xlsxFile);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(this.scenario);
        optionsPanel.add(this.results);
        optionsPanel.add(this.expandResults);
        optionsPanel.setBorder(new TitledBorder(STRINGLIST.getString("REPORT_OPTION_CONTENT")));
        this.results.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.expandResults.setEnabled(ReportDialog.this.results.isSelected());
            }
        });
        JPanel outputOptionsPanel = new JPanel();
        outputOptionsPanel.setLayout(new BoxLayout(outputOptionsPanel, 1));
        outputOptionsPanel.setFocusable(false);
        outputOptionsPanel.setBorder(new TitledBorder(STRINGLIST.getString("REPORT_OPTION_FORMATS")));
        outputOptionsPanel.add(this.xMLFile);
        outputOptionsPanel.add(this.hTMLFile);
        outputOptionsPanel.add(this.xlsFile);
        outputOptionsPanel.add(this.xlsxFile);
        JPanel main = new JPanel(new GridLayout());
        main.add(optionsPanel);
        main.add(outputOptionsPanel);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)main, "Center");
        JPanel control = new JPanel(new FlowLayout(1));
        JButton generate = new JButton("Generate");
        control.add(generate);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.setVisible(false);
            }
        });
        control.add(close);
        generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                if (ReportDialog.this.hTMLFile.isSelected()) {
                    file = new File(Model.getReportDirectory().getAbsolutePath() + File.separator + ReportDialog.this.name + ".html");
                    try {
                        HTMLReportGenerator.generate(new FileWriter(file), ReportDialog.this.convertSource());
                    }
                    catch (IOException e) {
                        LOG.error("Error generating html report", e);
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent("Error generating report. See log for details"));
                    }
                } else if (ReportDialog.this.xMLFile.isSelected()) {
                    file = new File(Model.getReportDirectory().getAbsolutePath() + File.separator + ReportDialog.this.name + ".xml");
                    try {
                        XMLReportGenerator.generate(new FileWriter(file), ReportDialog.this.convertSource());
                    }
                    catch (IOException e) {
                        LOG.error("Error generating xtml report", e);
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent("Error generating report. See log for details"));
                    }
                } else if (ReportDialog.this.xlsFile.isSelected()) {
                    file = new File(Model.getReportDirectory().getAbsolutePath() + File.separator + ReportDialog.this.name + ".xls");
                    TabularDataSaver saver = TabularDataFactory.newSaverForFile(file);
                    ExcelReportGenerator.generate(saver, ReportDialog.this.convertSource());
                    saver.close();
                } else if (ReportDialog.this.xlsxFile.isSelected()) {
                    file = new File(Model.getReportDirectory().getAbsolutePath() + File.separator + ReportDialog.this.name + ".xlsx");
                    TabularDataSaver saver = TabularDataFactory.newSaverForFile(file);
                    ExcelReportGenerator.generate(saver, ReportDialog.this.convertSource());
                    saver.close();
                }
                if (file != null) {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent("Generated report: " + file.getAbsolutePath()));
                }
                ReportDialog.this.setVisible(false);
            }
        });
        container.add((Component)control, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)container, "Center");
        this.pack();
        this.setLocationRelativeTo(this.owner);
    }

    public void setReportSource(Workspace workspace) {
        this.workspace = workspace;
        this.name = workspace.isHasBeenCalculated() ? workspace.getName() + " Simulation Report" : workspace.getName() + " Report";
        if (!workspace.isHasBeenCalculated()) {
            this.results.setEnabled(false);
            this.expandResults.setEnabled(false);
        }
    }

    public void setReportSource(BatchJobList batchJobList) {
        this.batchJobList = batchJobList;
        this.name = batchJobList.hasBeenCalculated() ? batchJobList.getName() + " Simulation Report" : batchJobList.getName() + " Report";
        if (!batchJobList.hasBeenCalculated()) {
            this.results.setEnabled(false);
            this.expandResults.setEnabled(false);
        }
    }

    private boolean s(JCheckBox check) {
        return check.isEnabled() && check.isSelected();
    }

    private List<ReportNode> convertSource() {
        if (this.workspace != null) {
            return ReportGenerator.generate(this.s(this.scenario), this.s(this.results), this.s(this.expandResults), this.workspace);
        }
        if (this.batchJobList != null) {
            LinkedList<ReportNode> batch = new LinkedList<ReportNode>();
            for (Workspace ws : this.batchJobList.getBatchJobs()) {
                batch.addAll(ReportGenerator.generate(this.s(this.scenario), this.s(this.results), this.s(this.expandResults), ws));
            }
            ReportNode main = new ReportNode("Batch Report [" + this.batchJobList.getDescription() + "]");
            batch.addFirst(main);
            return batch;
        }
        throw new RuntimeException("No known report souce found!");
    }
}

