/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.propagationtest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.ConstantDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.simulation.consistency.PluginValidator;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Configuration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.compare.VectorGroupDialog;
import org.seamcat.presentation.compare.XYElement;
import org.seamcat.presentation.compare.XYGroupDialog;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.GenericListDetailDialog;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.display.NamedVectorResult;
import org.seamcat.presentation.display.VectorGroupResultType;
import org.seamcat.presentation.eventprocessing.ReadOnlyPanel;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.DistributionItem;
import org.seamcat.presentation.genericgui.item.IntegerItem;
import org.seamcat.presentation.genericgui.item.Item;
import org.seamcat.presentation.genericgui.item.ItemChanged;
import org.seamcat.presentation.genericgui.item.SelectionItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.propagationtest.AddRemovePanel;
import org.seamcat.presentation.propagationtest.LinkResultConfiguration;
import org.seamcat.presentation.propagationtest.PropagationTestConsistencyCheckContext;
import org.seamcat.presentation.propagationtest.PropagationTestDetailPanel;
import org.seamcat.presentation.propagationtest.PropagationTestModel;
import org.seamcat.presentation.propagationtest.PropagationTestSelectionPanel;
import org.seamcat.presentation.propagationtest.PropagationTestTransceiverSettings;
import org.seamcat.simulation.result.LinkResultImpl;

public class PropagationTestPanel
extends EscapeDialog {
    private PropagationTestSelectionPanel selectionPanel;
    private PropagationTestDetailPanel detailPanel;
    private JPanel modelPanel = new JPanel(new BorderLayout());
    private IntegerItem samples;
    private SelectionItem<Common> selection;
    private DistributionItem commonDist;
    private String[] distributionEnabledDistance = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_DISTANCE", "STAIR", "DISCRETE_UNIFORM"};
    private String[] distributionEnabled = new String[]{"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"};
    private JButton generate;
    private JButton generateSorted;

    public void updateRelevance(boolean forceDistribution) {
        PropagationTestModel model = this.detailPanel.getModel();
        LinkResultConfiguration link = model.getLinkResultConfiguration();
        switch (this.selection.getValue()) {
            case Frequency: {
                this.commonDist.setDistributionEnabled(this.distributionEnabled);
                if (forceDistribution) {
                    this.commonDist.setValue((AbstractDistribution)link.frequency());
                }
                this.commonDist.setUnitText("MHz").setLabelText("Frequency");
                this.off(1);
                break;
            }
            case Distance: {
                this.commonDist.setDistributionEnabled(this.distributionEnabledDistance);
                if (forceDistribution) {
                    this.commonDist.setValue((AbstractDistribution)link.distance());
                }
                this.commonDist.setUnitText("km").setLabelText("Distance");
                this.off(0);
                break;
            }
            case TX_Height: {
                this.commonDist.setDistributionEnabled(this.distributionEnabled);
                if (forceDistribution) {
                    this.commonDist.setValue((AbstractDistribution)link.txHeight());
                }
                this.commonDist.setUnitText("m").setLabelText("TX Height");
                this.off(2);
                break;
            }
            default: {
                this.commonDist.setDistributionEnabled(this.distributionEnabledDistance);
                if (forceDistribution) {
                    this.commonDist.setValue((AbstractDistribution)link.rxHeight());
                }
                this.commonDist.setUnitText("m").setLabelText("RX Height");
                this.off(3);
            }
        }
    }

    private void off(int index) {
        GenericPanelEditor<LinkResultConfiguration> link = this.detailPanel.getLink();
        List<Item> items = link.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Item item = items.get(i);
            item.setRelevant(true);
            if (i != index) continue;
            item.setRelevant(false);
        }
    }

    public PropagationTestPanel(Frame owner) {
        super(owner, "SEAMCAT Propagation Model Test");
        JPanel controlPanel = new JPanel(new FlowLayout(0));
        this.samples = new IntegerItem().label("Number of samples");
        this.samples.initialize();
        this.samples.setValue(1000);
        controlPanel.add(this.single(this.samples));
        this.selection = new SelectionItem<Common>().values(Arrays.asList(Common.values())).label("Plot parameter");
        this.selection.initialize();
        this.selection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropagationTestPanel.this.updateRelevance(true);
                PropagationTestPanel.this.handleButtonEnablement();
            }
        });
        controlPanel.add(this.single(this.selection));
        this.commonDist = new DistributionItem(MainWindow.getInstance(), this.distributionEnabledDistance).label("Distance").unit("km");
        this.commonDist.initialize();
        this.commonDist.setValue((AbstractDistribution)((Object)Factory.distributionFactory().getConstantDistribution(1.0)));
        controlPanel.add(this.single(this.commonDist));
        this.commonDist.addItemChangedHandler(new ItemChanged<AbstractDistribution>(){

            @Override
            public void itemChanged(AbstractDistribution value) {
                PropagationTestPanel.this.handleButtonEnablement();
            }
        });
        this.generate = new JButton("Generate samples");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PropagationTestPanel.this.consistencyCheck()) {
                    PropagationTestPanel.this.generateAndShow();
                }
            }
        });
        this.generateSorted = new JButton("Generate sorted samples");
        this.generateSorted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PropagationTestPanel.this.consistencyCheck()) {
                    PropagationTestPanel.this.generateAndShowSampleInXY();
                }
            }
        });
        controlPanel.add(this.generate);
        controlPanel.add(this.generateSorted);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PropagationTestPanel.this.setVisible(false);
            }
        });
        controlPanel.add(close);
        PropagationTestModel model = new PropagationTestModel();
        this.selectionPanel = new PropagationTestSelectionPanel(new PropagationTestSelectionPanel.SelectedModel(){

            @Override
            public void selected(PropagationTestModel model) {
                if (PropagationTestPanel.this.detailPanel != null) {
                    PropagationTestPanel.this.detailPanel.getModel();
                }
                PropagationTestPanel.this.setDetailView(model);
            }
        });
        this.selectionPanel.addModel(model);
        this.selectionPanel.addAddRemoveListener(new AddRemovePanel.AddRemoveListener(){

            @Override
            public void add() {
                List<Configuration> plugins = Model.getInstance().getLibrary().getPluginConfigurations(PropagationModelConfiguration.class);
                GenericListDetailDialog<Configuration> dialog = new GenericListDetailDialog<Configuration>((JFrame)MainWindow.getInstance(), "Select Propagation Model", plugins){

                    @Override
                    public void selectedElement(Configuration model) {
                        JPanel jPanel = new JPanel(new LabeledPairLayout());
                        jPanel.add((Component)new JLabel("Name"), "label");
                        jPanel.add((Component)new JLabel(model.description().name()), "field");
                        jPanel.add((Component)new JLabel("Description"), "label");
                        jPanel.add((Component)new JLabel(model.description().description()), "field");
                        ReadOnlyPanel.addReadOnly(jPanel, model);
                        this.setDetail(new BorderPanel(jPanel, "Plugin Configuration"));
                    }
                };
                if (dialog.display()) {
                    PropagationModelConfiguration configuration = (PropagationModelConfiguration)dialog.getSelectedValue();
                    PropagationTestModel model = new PropagationTestModel();
                    model.setPropagationModelConfiguration(configuration);
                    PropagationTestPanel.this.selectionPanel.addModel(model);
                }
            }

            @Override
            public void remove() {
                PropagationTestPanel.this.selectionPanel.removeSelectedItem();
            }

            @Override
            public void help() {
                SeamcatHelpResolver.showHelp("http://confluence.seamcat.org/display/SH/2.16+Testing+propagation+models");
            }
        });
        JSplitPane splitter = new JSplitPane(1);
        splitter.add(this.selectionPanel);
        splitter.add(this.modelPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitter, "Center");
        this.getContentPane().add((Component)new ScrollingBorderPanel(controlPanel, "Control panel"), "South");
        this.handleButtonEnablement();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setSize(1200, 800);
        EventBusFactory.getEventBus().subscribe(this);
    }

    private GenericPanel single(Item item) {
        GenericPanel gp = new GenericPanel();
        gp.addItem(item);
        gp.initializeWidgets();
        return gp;
    }

    private void setDetailView(PropagationTestModel model) {
        this.detailPanel = new PropagationTestDetailPanel(MainWindow.getInstance(), model);
        this.updateRelevance(false);
        this.modelPanel.removeAll();
        this.modelPanel.add(this.detailPanel);
        this.modelPanel.revalidate();
        this.modelPanel.repaint();
    }

    @UIEventHandler
    public void handle(TextWidgetValueUpdatedEvent event) {
        if (this.detailPanel.matchEvent(event)) {
            this.detailPanel.getModel();
            this.selectionPanel.refreshFromModel();
        }
    }

    private void handleButtonEnablement() {
        AbstractDistribution distribution = this.commonDist.getValue();
        this.generateSorted.setEnabled(!(distribution instanceof ConstantDistribution));
    }

    private boolean consistencyCheck() {
        this.detailPanel.getModel();
        ArrayList<ConsistencyError> results = new ArrayList<ConsistencyError>();
        for (PropagationTestModel model : this.selectionPanel.getModels()) {
            LinkResultConfiguration link = model.getLinkResultConfiguration();
            PropagationTestTransceiverSettings rx = new PropagationTestTransceiverSettings(link.rxHeight().getBounds(), Factory.results().convert(model.getLocalEnvironments().receiverEnvironments()));
            PropagationTestTransceiverSettings tx = new PropagationTestTransceiverSettings(link.txHeight().getBounds(), Factory.results().convert(model.getLocalEnvironments().transmitterEnvironments()));
            RadioSystem system = new RadioSystem(null, null, model.getPropagationModel());
            PropagationTestConsistencyCheckContext context = new PropagationTestConsistencyCheckContext(link.frequency(), system, link.distance(), tx, rx);
            switch (this.selection.getValue()) {
                case Distance: {
                    context.setDistance(this.commonDist.getValue());
                    break;
                }
                case Frequency: {
                    context.setFrequency(this.commonDist.getValue());
                    break;
                }
                case RX_Height: {
                    rx.setHeight(this.commonDist.getValue().getBounds());
                    break;
                }
                case TX_Height: {
                    tx.setHeight(this.commonDist.getValue().getBounds());
                }
            }
            PluginValidator.plugin(context, results, model.getPropagationModel(), model.toString());
        }
        return MainWindow.displayScenarioCheckResults(results, false, true, MainWindow.getInstance());
    }

    private void generateAndShow() {
        if (this.detailPanel == null) {
            return;
        }
        int events = this.samples.getValue();
        VectorGroupResultType group = new VectorGroupResultType(events + " samples from " + this.selectionPanel.getModels().size() + " models", "dB");
        HashMap<PropagationTestModel, double[]> resultMap = new HashMap<PropagationTestModel, double[]>();
        for (PropagationTestModel model : this.selectionPanel.getModels()) {
            double[] value = new double[events];
            resultMap.put(model, value);
            group.addVector(new NamedVectorResult(model.toString(), value));
        }
        try {
            for (int i = 0; i < events; ++i) {
                double common = this.commonDist.getValue().trial();
                for (PropagationTestModel model : this.selectionPanel.getModels()) {
                    ((double[])resultMap.get((Object)model))[i] = this.evaluate(i, common, model);
                }
            }
            new VectorGroupDialog(group);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private double evaluate(int i, double common, PropagationTestModel model) {
        LinkResult result = this.generateLinkResult(common, model);
        PropagationModelConfiguration conf = model.getPropagationModel();
        try {
            return conf.evaluate(result);
        }
        catch (SimulationInvalidException e) {
            Throwable e1 = e.getOrigin();
            int ExceptionResponse = JOptionPane.showConfirmDialog(MainWindow.getInstance(), "<html><b>Exception message:</b><br>\"" + e1.getMessage() + "\"<br>It is recommended that you check your input parameters.<br>Do you want to abort propagation model test?</html>", "Exception occurred in propagation model test at sample #" + i, 0, 0);
            if (ExceptionResponse == 0) {
                throw new RuntimeException("Stop");
            }
            return -1.0;
        }
    }

    private String unit() {
        switch (this.selection.getValue()) {
            case Distance: {
                return "km";
            }
            case Frequency: {
                return "MHz";
            }
        }
        return "m";
    }

    private void generateAndShowSampleInXY() {
        if (this.detailPanel == null) {
            return;
        }
        int events = this.samples.getValue();
        LinkedHashMap resultMap = new LinkedHashMap();
        for (PropagationTestModel model : this.selectionPanel.getModels()) {
            resultMap.put(model, new ArrayList());
        }
        try {
            for (int i = 0; i < events; ++i) {
                double common = this.commonDist.getValue().trial();
                for (PropagationTestModel model : this.selectionPanel.getModels()) {
                    double evaluate = this.evaluate(i, common, model);
                    ((List)resultMap.get(model)).add(new Point2D(common, evaluate));
                }
            }
            String label = this.selection.getValue().toString() + " (" + this.unit() + ")";
            ArrayList<XYElement> results = new ArrayList<XYElement>();
            for (Map.Entry entry : resultMap.entrySet()) {
                Collections.sort((List)entry.getValue(), Point2D.X_COMPARATOR);
                results.add(new XYElement(((PropagationTestModel)entry.getKey()).toString(), (List)entry.getValue()));
            }
            new XYGroupDialog(events + " samples from " + results.size() + " models", label, results);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private LinkResult generateLinkResult(double common, PropagationTestModel model) {
        LinkResultImpl result = new LinkResultImpl();
        double frequency = model.getLinkResultConfiguration().frequency().trial();
        result.setFrequency(frequency);
        result.setTxRxDistance(model.getLinkResultConfiguration().distance().trial());
        result.txAntenna().setHeight(model.getLinkResultConfiguration().txHeight().trial());
        result.rxAntenna().setPosition(new Point2D(result.getTxRxDistance(), 0.0));
        result.rxAntenna().setHeight(model.getLinkResultConfiguration().rxHeight().trial());
        result.assignLocalEnvironment(Factory.results().convert(model.getLocalEnvironments().transmitterEnvironments()), Direction.To_TX);
        result.assignLocalEnvironment(Factory.results().convert(model.getLocalEnvironments().receiverEnvironments()), Direction.To_RX);
        switch (this.selection.getValue()) {
            case Distance: {
                result.setTxRxDistance(common);
                result.rxAntenna().setPosition(new Point2D(common, 0.0));
                break;
            }
            case Frequency: {
                result.setFrequency(common);
                break;
            }
            case TX_Height: {
                result.txAntenna().setHeight(common);
                break;
            }
            case RX_Height: {
                result.rxAntenna().setHeight(common);
            }
        }
        return result;
    }

    private static enum Common {
        Distance,
        Frequency,
        TX_Height,
        RX_Height;

    }
}

