/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.propagationtest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.seamcat.presentation.menu.ToolBar;

public class AddRemovePanel
extends JPanel
implements ActionListener {
    private JToolBar toolBar;
    private JLabel label;
    private JButton add;
    private JButton remove;
    private JButton help;
    private AddRemoveListener addRemoveListener;
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public AddRemovePanel() {
        this.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.setupToolbar();
        this.label = new JLabel(STRINGLIST.getString("LBL_ADD_REMOVE"));
        this.add((Component)this.label, "North");
        this.add((Component)this.toolBar, "Center");
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.help.addActionListener(this);
        this.add.setToolTipText(STRINGLIST.getString("BTN_ADD_TOOL_TIP"));
        this.remove.setToolTipText(STRINGLIST.getString("BTN_REMOVE_TOOL_TIP"));
    }

    private void setupToolbar() {
        this.add = ToolBar.button("SEAMCAT_ICON_ADD", "BTN_ADD_TOOL_TIP");
        this.remove = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "BTN_REMOVE_TOOL_TIP");
        this.help = ToolBar.button("SEAMCAT_ICON_HELP", null);
        this.toolBar.add(this.add);
        this.toolBar.add(this.remove);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.addSeparator();
        this.toolBar.add(this.help);
    }

    public void setAddToolTip(String toolTip) {
        this.add.setToolTipText(toolTip);
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    public void addAddRemoveListener(AddRemoveListener addRemoveListener) {
        this.addRemoveListener = addRemoveListener;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.addRemoveListener != null) {
            Object src = evt.getSource();
            if (src == this.add) {
                this.addRemoveListener.add();
            } else if (src == this.remove) {
                this.addRemoveListener.remove();
            } else if (src == this.help) {
                this.addRemoveListener.help();
            }
        }
    }

    public void enableRemove(boolean enable) {
        this.remove.setEnabled(enable);
    }

    public static interface AddRemoveListener {
        public void add();

        public void remove();

        public void help();
    }
}

