/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.menu;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.seamcat.commands.DisplayCompareVectorCommand;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.commands.DisplayReportErrorCommand;
import org.seamcat.commands.DisplayTestCalculatorCommand;
import org.seamcat.commands.ExportLibraryCommand;
import org.seamcat.commands.ImportLibraryCommand;
import org.seamcat.commands.NewBatchCommand;
import org.seamcat.commands.NewWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceCommand;
import org.seamcat.commands.SaveWorkspaceCommand;
import org.seamcat.commands.ShowToolBarCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.SimulationCompleteEvent;
import org.seamcat.events.SimulationStartedEvent;
import org.seamcat.events.WorkspacesPaneEmptyEvent;
import org.seamcat.events.WorkspacesPaneNonEmptyEvent;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.builder.PanelBuilder;
import org.seamcat.presentation.menu.Menus;

public class ToolBar {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private JToolBar toolBar;
    private JButton newWorkspace;
    private JButton openWorkspace;
    private JButton saveWorkspace;
    private JButton importLibrary;
    private JButton exportLibrary;
    private JButton newBatchJob;
    private JButton compareVectors;

    public ToolBar() {
        EventBusFactory.getEventBus().subscribe(this);
    }

    public void createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setName(STRINGLIST.getString("TOOLBAR_TITLE_TEXT"));
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.createButtonNewWorkspace();
        this.createButtonBatchOperation();
        this.createButtonOpenWorkspace();
        this.createButtonSaveWorkspace();
        this.toolBar.addSeparator();
        this.createButtonImportLibrary();
        this.createButtonExportLibrary();
        this.toolBar.addSeparator();
        this.createMenuCompareVectors();
        this.createButtonCalculator();
        this.toolBar.addSeparator();
        this.createButtonHelp();
        this.createButtonBug();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    private void enable(boolean enable) {
        this.newWorkspace.setEnabled(enable);
        this.newBatchJob.setEnabled(enable);
        this.openWorkspace.setEnabled(enable);
        this.saveWorkspace.setEnabled(enable);
        this.importLibrary.setEnabled(enable);
        this.exportLibrary.setEnabled(enable);
        this.compareVectors.setEnabled(enable);
    }

    @UIEventHandler
    public void handleShowToolBar(ShowToolBarCommand command) {
        this.toolBar.setVisible(command.isVisible());
    }

    @UIEventHandler
    public void handleSimulationComplete(SimulationCompleteEvent event) {
        if (this.newWorkspace == null) {
            return;
        }
        this.enable(true);
    }

    @UIEventHandler
    public void handleSimulationStarted(SimulationStartedEvent event) {
        if (this.newWorkspace == null) {
            return;
        }
        this.enable(false);
    }

    @UIEventHandler
    public void handleEmptyRootPanel(WorkspacesPaneEmptyEvent event) {
        this.openWorkspace.setEnabled(true);
        this.newWorkspace.setEnabled(true);
        this.newBatchJob.setEnabled(true);
        this.importLibrary.setEnabled(true);
        this.exportLibrary.setEnabled(true);
        this.saveWorkspace.setEnabled(false);
    }

    @UIEventHandler
    public void handleNonEmptyRootPanel(WorkspacesPaneNonEmptyEvent event) {
        this.importLibrary.setEnabled(true);
        this.exportLibrary.setEnabled(true);
        this.newWorkspace.setEnabled(true);
        this.openWorkspace.setEnabled(true);
        this.saveWorkspace.setEnabled(true);
        this.newBatchJob.setEnabled(true);
        this.compareVectors.setEnabled(true);
    }

    private void createButtonNewWorkspace() {
        this.newWorkspace = ToolBar.button("SEAMCAT_ICON_WORKSPACE_NEW", "MENU_ITEM_TEXT_NEW_WORKSPACE", new NewWorkspaceCommand());
        this.toolBar.add(this.newWorkspace);
    }

    private void createButtonOpenWorkspace() {
        this.openWorkspace = ToolBar.button("SEAMCAT_ICON_WORKSPACE_OPEN", "MENU_ITEM_TEXT_OPEN_WORKSPACE", new OpenWorkspaceCommand());
        this.toolBar.add(this.openWorkspace);
    }

    private void createButtonSaveWorkspace() {
        this.saveWorkspace = ToolBar.button("SEAMCAT_ICON_WORKSPACE_SAVE", "MENU_ITEM_TEXT_SAVE_WORKSPACE", new SaveWorkspaceCommand());
        this.toolBar.add(this.saveWorkspace);
    }

    private void createButtonImportLibrary() {
        this.importLibrary = ToolBar.button("SEAMCAT_ICON_IMPORT_LIBRARY", "MENU_ITEM_TEXT_IMPORT_LIBRARY", new ImportLibraryCommand());
        this.toolBar.add(this.importLibrary);
    }

    private void createButtonExportLibrary() {
        this.exportLibrary = ToolBar.button("SEAMCAT_ICON_EXPORT_LIBRARY", "MENU_ITEM_TEXT_EXPORT_LIBRARY", new ExportLibraryCommand());
        this.toolBar.add(this.exportLibrary);
    }

    private void createButtonBatchOperation() {
        this.newBatchJob = ToolBar.button("SEAMCAT_ICON_NEW_BATCH", "MENU_ITEM_TEXT_NEW_BATCH_OPERATION", new NewBatchCommand());
        this.toolBar.add(this.newBatchJob);
    }

    private void createButtonHelp() {
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand("http://confluence.seamcat.org/display/SH/SEAMCAT+Handbook")));
    }

    private void createButtonBug() {
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_BUG_ERROR", "ERROR_REPORT_MENU_ITEM_TOOLTIP", new DisplayReportErrorCommand()));
    }

    private void createButtonCalculator() {
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_CALCULATOR", "TEST_CALCULATOR_MENU_ITEM_TEXT", new DisplayTestCalculatorCommand()));
    }

    private void createMenuCompareVectors() {
        this.compareVectors = ToolBar.button("SEAMCAT_ICON_INTERFERENCE_CALCULATIONS", "TEST_COMPARE_VECTORS_MENU_ITEM_TOOLTIP", new DisplayCompareVectorCommand());
        this.toolBar.add(this.compareVectors);
    }

    public static JButton button(String icon, String toolTip, Object instance, String method) {
        return PanelBuilder.addAction(ToolBar.button(icon, toolTip, null), instance, method);
    }

    public static JButton button(String icon, String toolTip) {
        return ToolBar.button(icon, toolTip, null);
    }

    public static JButton button(String icon, String toolTip, Action action) {
        JButton button = action != null ? new JButton(action) : new JButton();
        button.setIcon(SeamcatIcons.getImageIcon(icon, 0));
        if (toolTip != null) {
            button.setToolTipText(STRINGLIST.getString(toolTip));
        }
        button.setFocusable(false);
        return button;
    }

    public static JButton button(String icon, String toolTip, Object command) {
        JButton button = new JButton();
        button.setIcon(SeamcatIcons.getImageIcon(icon, 0));
        if (toolTip != null) {
            button.setToolTipText(STRINGLIST.getString(toolTip));
        }
        if (command != null) {
            button.addActionListener(Menus.action(command));
        }
        button.setFocusable(false);
        return button;
    }
}

