/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.seamcat.commands.OpenWorkspaceFileCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.RecentlyUsedChangedEvent;

public class HistoryItemsMenu {
    private JMenu menu;
    private List<JMenuItem> items;
    private boolean inserted = false;
    private int position;
    private JSeparator separator = new JSeparator();
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private ActionListener itemHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            String filename = item.getToolTipText();
            EventBusFactory.getEventBus().publish(new OpenWorkspaceFileCommand(new File(filename)));
        }
    };

    public HistoryItemsMenu(JMenu menu) {
        this.menu = menu;
        this.position = menu.getItemCount();
        this.items = new ArrayList<JMenuItem>(5);
        for (int i = 0; i < 5; ++i) {
            JMenuItem item = new JMenuItem();
            item.addActionListener(this.itemHandler);
            this.items.add(item);
        }
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handleRecentlyUsedChanged(RecentlyUsedChangedEvent event) {
        this.updateHistory(event.getHistory());
    }

    private void updateHistory(List<String> history) {
        int i;
        for (i = 0; i < history.size(); ++i) {
            this.updateHistoryItem(this.items.get(i), history.get(i), i + 1);
        }
        if (history.size() < 5) {
            for (i = history.size(); i < 5; ++i) {
                this.menu.remove(this.items.get(i));
            }
        }
        if (history.size() == 0) {
            this.menu.remove(this.separator);
            this.inserted = false;
        }
    }

    private void updateHistoryItem(JMenuItem item, String name, int number) {
        item.setText(this.fixName(name, number));
        item.setToolTipText(name);
        if (!this.contains(item)) {
            this.menu.add((Component)item, this.position + number - 1);
            if (!this.inserted) {
                this.inserted = true;
                this.menu.add((Component)this.separator, this.position + number);
            }
        }
    }

    private String fixName(String name, int number) {
        String shortDirectoryName = name.substring(0, 3);
        if (name.length() > 22) {
            return number + " " + shortDirectoryName + "..." + name.substring(name.length() - 21);
        }
        return number + " " + shortDirectoryName + " ..." + name;
    }

    private boolean contains(JMenuItem item) {
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            if (this.menu.getItem(i) != item) continue;
            return true;
        }
        return false;
    }
}

