/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.localenvironments;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.LocalEnvironmentUI;
import org.seamcat.model.plugin.system.LocalEnvironments;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsPanel;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsTxRxModel;

public class LocalEnvironmentsTxRxPanel
extends JPanel
implements PanelModelEditor<LocalEnvironments> {
    private final LocalEnvironmentsPanel receiverEnv;
    private final LocalEnvironmentsPanel transmitterEnv;

    public LocalEnvironmentsTxRxPanel(JFrame owner, LocalEnvironmentsTxRxModel model) {
        super(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(2, 1));
        this.receiverEnv = new LocalEnvironmentsPanel(owner, "Receiver");
        panel.add(this.receiverEnv);
        this.transmitterEnv = new LocalEnvironmentsPanel(owner, "Transmitter");
        panel.add(this.transmitterEnv);
        this.add((Component)panel, "Center");
        this.setModel(model.getReceiverEnvs(), model.getTransmitterEnvs());
    }

    public void dispose() {
        this.receiverEnv.dispose();
        this.transmitterEnv.dispose();
    }

    public void setModel(List<LocalEnvironmentUI> receiver, List<LocalEnvironmentUI> transmitter) {
        this.receiverEnv.setModel(receiver);
        this.transmitterEnv.setModel(transmitter);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public LocalEnvironments getModel() {
        this.receiverEnv.updateModel();
        this.transmitterEnv.updateModel();
        LocalEnvironments prototype = Factory.prototype(LocalEnvironments.class);
        Factory.when(prototype.receiverEnvironments()).thenReturn(this.receiverEnv.getModel());
        Factory.when(prototype.transmitterEnvironments()).thenReturn(this.transmitterEnv.getModel());
        return Factory.build(prototype);
    }
}

