/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.localenvironments;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.LocalEnvironmentUI;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.presentation.localenvironments.AddIndoorLocalEnvironmentUI;
import org.seamcat.presentation.localenvironments.IndoorEnvironmentDialog;
import org.seamcat.presentation.localenvironments.ListItemLocalEnvironment;
import org.seamcat.presentation.localenvironments.OutdoorEarthToSpaceUI;
import org.seamcat.presentation.localenvironments.OutdoorEnvironmentDialog;
import org.seamcat.presentation.localenvironments.OutdoorGeneralUI;
import org.seamcat.presentation.localenvironments.OutdoorModel;
import org.seamcat.presentation.localenvironments.OutdoorSpecificUI;
import org.seamcat.presentation.menu.ToolBar;

public class LocalEnvironmentsPanel
extends JPanel {
    private final JButton add;
    private final JButton delete;
    private JList list = new JList();
    private DefaultListModel listModel = new DefaultListModel();
    private JToolBar toolBar;
    private List<ListItemLocalEnvironment> localEnvironments;

    public LocalEnvironmentsPanel(final JFrame owner, String title) {
        this.list.setModel(this.listModel);
        this.toolBar = new JToolBar();
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.toolBar.add(new JLabel(title));
        this.add = ToolBar.button("SEAMCAT_ICON_ADD", "TOOLBAR_LOCALENVIRONMENT_ADD");
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocalEnvironmentsPanel.this.handleAdd();
            }
        });
        this.toolBar.add(this.add);
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_LOCALENVIRONMENT_REMOVE");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LocalEnvironmentsPanel.this.handleDelete();
            }
        });
        this.toolBar.add(this.delete);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.toolBar, "North");
        JScrollPane pane = new JScrollPane(this.list);
        pane.setPreferredSize(new Dimension(350, 75));
        panel.add((Component)pane, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    // empty if block
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ListItemLocalEnvironment value = (ListItemLocalEnvironment)LocalEnvironmentsPanel.this.list.getSelectedValue();
                    LocalEnvironmentUI ui = value.getLocalEnvironmentUI();
                    if (ui.environment() == LocalEnvironment.Environment.Outdoor) {
                        OutdoorModel model = new OutdoorModel();
                        model.setMode(ui.outdoorModel());
                        model.setApplyOutdoorClutter(ui.applyOutdoorClutter());
                        switch (model.getMode()) {
                            case GENERAL: {
                                OutdoorGeneralUI protoGeneral = Factory.prototype(OutdoorGeneralUI.class);
                                Factory.when(protoGeneral.percentage()).thenReturn(ui.percentageOfLocations());
                                model.setGeneral(Factory.build(protoGeneral));
                                break;
                            }
                            case EARTH_TO_SPACE: {
                                OutdoorEarthToSpaceUI protoEarth = Factory.prototype(OutdoorEarthToSpaceUI.class);
                                Factory.when(protoEarth.percentage()).thenReturn(ui.percentageOfLocations());
                                model.setEarthToSpace(Factory.build(protoEarth));
                                break;
                            }
                            default: {
                                OutdoorSpecificUI protoSpecific = Factory.prototype(OutdoorSpecificUI.class);
                                Factory.when(protoSpecific.localClutter()).thenReturn(ui.localClutter());
                                Factory.when(protoSpecific.userDefined()).thenReturn(ui.userDefined());
                                Factory.when(protoSpecific.height()).thenReturn(ui.height());
                                Factory.when(protoSpecific.streetWidth()).thenReturn(ui.width());
                                model.setSpecific(Factory.build(protoSpecific));
                            }
                        }
                        OutdoorEnvironmentDialog dialog = new OutdoorEnvironmentDialog(owner, model);
                        if (dialog.display()) {
                            model = dialog.getModel();
                            LocalEnvironmentUI le = Factory.prototype(LocalEnvironmentUI.class, ui);
                            Factory.when(le.outdoorModel()).thenReturn(model.getMode());
                            Factory.when(le.applyOutdoorClutter()).thenReturn(model.isApplyOutdoorClutter());
                            Object current = model.getCurrentUI();
                            if (current instanceof OutdoorGeneralUI) {
                                OutdoorGeneralUI g_ui = (OutdoorGeneralUI)current;
                                Factory.when(le.percentageOfLocations()).thenReturn(g_ui.percentage());
                            } else if (current instanceof OutdoorSpecificUI) {
                                OutdoorSpecificUI s_ui = (OutdoorSpecificUI)current;
                                Factory.when(le.userDefined()).thenReturn(s_ui.userDefined());
                                Factory.when(le.localClutter()).thenReturn(s_ui.localClutter());
                                Factory.when(le.height()).thenReturn(s_ui.height());
                                Factory.when(le.width()).thenReturn(s_ui.streetWidth());
                            } else {
                                OutdoorEarthToSpaceUI e_ui = (OutdoorEarthToSpaceUI)current;
                                Factory.when(le.percentageOfLocations()).thenReturn(e_ui.percentage());
                            }
                            value.setLocalEnvironmentUI(Factory.build(le));
                        }
                    } else {
                        AddIndoorLocalEnvironmentUI proto = Factory.prototype(AddIndoorLocalEnvironmentUI.class);
                        Factory.when(proto.probability()).thenReturn(ui.prop() * 100.0);
                        Factory.when(proto.wallLoss()).thenReturn(ui.wallLoss());
                        Factory.when(proto.stdDev()).thenReturn(ui.stdDev());
                        Factory.when(proto.useBEL()).thenReturn(ui.useBEL());
                        Factory.when(proto.probExceeding()).thenReturn(ui.probExceeding());
                        Factory.when(proto.traditionalBuildings()).thenReturn(ui.traditionalBuildings());
                        IndoorEnvironmentDialog dialog = new IndoorEnvironmentDialog(owner, Factory.build(proto));
                        if (dialog.display()) {
                            AddIndoorLocalEnvironmentUI model = dialog.getModel();
                            LocalEnvironmentUI le = Factory.prototype(LocalEnvironmentUI.class);
                            Factory.when(le.environment()).thenReturn(LocalEnvironment.Environment.Indoor);
                            Factory.when(le.wallLoss()).thenReturn(model.wallLoss());
                            Factory.when(le.stdDev()).thenReturn(model.stdDev());
                            Factory.when(le.prop()).thenReturn(model.probability() / 100.0);
                            Factory.when(le.useBEL()).thenReturn(model.useBEL());
                            Factory.when(le.probExceeding()).thenReturn(model.probExceeding());
                            Factory.when(le.traditionalBuildings()).thenReturn(model.traditionalBuildings());
                            value.setLocalEnvironmentUI(Factory.build(le));
                            LocalEnvironmentsPanel.this.calculatePercentages(value);
                            LocalEnvironmentsPanel.this.refreshFromModel();
                        }
                    }
                }
            }
        });
        this.add(panel);
    }

    public void dispose() {
        for (ListSelectionListener listSelectionListener : this.list.getListSelectionListeners()) {
            this.list.removeListSelectionListener(listSelectionListener);
        }
        for (EventListener eventListener : this.list.getMouseListeners()) {
            this.list.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.add.getActionListeners()) {
            this.add.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.delete.getActionListeners()) {
            this.delete.removeActionListener((ActionListener)eventListener);
        }
        this.toolBar.removeAll();
        this.removeAll();
    }

    private void handleAdd() {
        LocalEnvironmentUI prototype = Factory.prototype(LocalEnvironmentUI.class);
        Factory.when(prototype.prop()).thenReturn(0.0);
        Factory.when(prototype.environment()).thenReturn(LocalEnvironment.Environment.Indoor);
        ListItemLocalEnvironment environment = new ListItemLocalEnvironment(Factory.build(prototype));
        this.localEnvironments.add(environment);
        this.refreshFromModel();
    }

    private void handleDelete() {
        ListItemLocalEnvironment env = (ListItemLocalEnvironment)this.list.getSelectedValue();
        if (env != null && env.getLocalEnvironmentUI().environment() != LocalEnvironment.Environment.Outdoor) {
            this.localEnvironments.remove(env);
            this.calculatePercentages(null);
            this.refreshFromModel();
        }
    }

    public void setModel(List<LocalEnvironmentUI> localEnvironments) {
        this.localEnvironments = new ArrayList<ListItemLocalEnvironment>();
        for (LocalEnvironmentUI localEnvironment : localEnvironments) {
            this.localEnvironments.add(new ListItemLocalEnvironment(localEnvironment));
        }
        this.refreshFromModel();
    }

    public List<LocalEnvironmentUI> getModel() {
        ArrayList<LocalEnvironmentUI> result = new ArrayList<LocalEnvironmentUI>();
        for (ListItemLocalEnvironment localEnvironment : this.localEnvironments) {
            result.add(localEnvironment.getLocalEnvironmentUI());
        }
        return result;
    }

    public void refreshFromModel() {
        this.listModel.clear();
        ListItemLocalEnvironment outdoor = null;
        for (ListItemLocalEnvironment item : this.localEnvironments) {
            if (item.getLocalEnvironmentUI().environment() == LocalEnvironment.Environment.Outdoor) {
                outdoor = item;
                continue;
            }
            this.listModel.addElement(item);
        }
        if (outdoor != null) {
            this.listModel.addElement(outdoor);
        }
        this.list.updateUI();
    }

    private void calculatePercentages(ListItemLocalEnvironment selected) {
        double cumulative = 0.0;
        double reserved = selected == null ? 0.0 : selected.getLocalEnvironmentUI().prop();
        ListItemLocalEnvironment outDoor = null;
        for (ListItemLocalEnvironment item : this.localEnvironments) {
            if (item.getLocalEnvironmentUI().environment() == LocalEnvironment.Environment.Outdoor) {
                outDoor = item;
                continue;
            }
            if (item == selected) {
                cumulative += reserved;
                continue;
            }
            if (cumulative + item.getLocalEnvironmentUI().prop() + reserved > 1.0) {
                this.setProbability(item, 1.0 - (cumulative + reserved));
                cumulative = 1.0 - reserved;
                continue;
            }
            cumulative += item.getLocalEnvironmentUI().prop();
        }
        if (outDoor != null) {
            this.setProbability(outDoor, 1.0 - cumulative);
        }
    }

    private void setProbability(ListItemLocalEnvironment item, double prop) {
        LocalEnvironmentUI prototype = Factory.prototype(LocalEnvironmentUI.class, item.getLocalEnvironmentUI());
        Factory.when(prototype.prop()).thenReturn(prop);
        item.setLocalEnvironmentUI(Factory.build(prototype));
    }

    public void updateModel() {
        this.localEnvironments.clear();
        for (int i = 0; i < this.listModel.size(); ++i) {
            this.localEnvironments.add((ListItemLocalEnvironment)this.listModel.get(i));
        }
    }
}

