/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jfree.util.Log;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Model;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.JarFiles;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.GenericSelectionDialog;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.components.SystemTree;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.library.LibraryDetailPanel;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.systems.SystemListItem;

public class SystemLibraryItemListPanel
extends EscapeDialog {
    private static final Logger LOG = Logger.getLogger(SystemLibraryItemListPanel.class);
    private final JFrame dialog;
    private LibraryDetailPanel<SystemListItem> detailPanel;
    private SystemTree systemTree;
    private JButton delete;
    private JButton duplicate;
    private JToolBar toolBar = new JToolBar();
    private JFrame ownerFrame;
    private ChangeNotifier notifier;

    public SystemLibraryItemListPanel(JFrame owner, String title, String helpURL, int width, int height) {
        super((Frame)owner, true);
        Class<?> lafClass;
        this.setTitle(title);
        this.ownerFrame = owner;
        this.dialog = owner;
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.notifier = new ChangeNotifier(){

            @Override
            public void changed() {
                SystemLibraryItemListPanel.this.updateModel();
                SystemLibraryItemListPanel.this.systemTree.updateUI();
            }
        };
        this.setupToolbar(helpURL);
        this.systemTree = new SystemTree();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.systemTree);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)jScrollPane, "Center");
        leftPanel.add((Component)new NavigateButtonPanel(this, false){

            @Override
            public void btnOkActionPerformed() {
                super.btnOkActionPerformed();
                SystemLibraryItemListPanel.this.closing();
                SystemLibraryItemListPanel.this.destroy();
            }

            @Override
            public void btnCancelActionPerformed() {
                super.btnCancelActionPerformed();
                SystemLibraryItemListPanel.this.destroy();
            }
        }, "South");
        final JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(leftPanel);
        splitPane.add(new JPanel());
        splitPane.setDividerLocation(180);
        this.systemTree.setSelectionListener(new SystemTree.SelectionListener(){

            @Override
            public void selectionChanged(SystemListItem selectedSystem) {
                if (selectedSystem == null) {
                    SystemLibraryItemListPanel.this.detailPanel = null;
                    splitPane.setRightComponent(new JPanel());
                } else {
                    SystemLibraryItemListPanel.this.updateModel();
                    SystemLibraryItemListPanel.this.detailPanel = new LibraryDetailPanel<SystemListItem>(SystemLibraryItemListPanel.this.ownerFrame, SystemListItem.class, new LibraryItemWrapper<SystemListItem>(selectedSystem), SystemLibraryItemListPanel.this.notifier, true);
                    splitPane.setRightComponent(SystemLibraryItemListPanel.this.detailPanel);
                }
                SystemLibraryItemListPanel.this.updateToolbarButtons();
            }
        });
        this.systemTree.setContextMenuProvider(new SystemTree.ContextMenuProvider(){

            @Override
            public List<JMenuItem> contextMenuItems(final SystemListItem system) {
                ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
                if (system.getSystemPlugin() instanceof AggregateSystemPlugin) {
                    JMenuItem addComponentMenuItem = new JMenuItem("Add component to aggregate");
                    addComponentMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SystemLibraryItemListPanel.this.handleAddComponentToAggregate(system);
                        }
                    });
                    menuItems.add(addComponentMenuItem);
                }
                menuItems.addAll(SystemLibraryItemListPanel.this.systemTree.aggregateComponentMoveContextMenuItems(system));
                return menuItems;
            }
        });
        this.setModel(Model.getInstance().getLibrary().getGroup(SystemListItem.class));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitPane, "Center");
        this.setSize(width, height);
        this.setLocationRelativeTo(owner);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && (lafClass = laf.getClass()) != null && lafClass.toString().contains("MetalLookAndFeel")) {
            this.setResizable(false);
            if (Log.isDebugEnabled()) {
                Log.debug("Metal LAF detected. Resizing of interfering link dialog disabled");
            }
        }
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handle(TextWidgetValueUpdatedEvent event) {
        if (this.detailPanel != null && this.detailPanel.match(event.getContext())) {
            this.updateModel();
        }
    }

    private void setupToolbar(String helpClass) {
        this.duplicate = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "TOOLBAR_LIBRARY_DUPLICATE_TOOLTIP");
        this.duplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemLibraryItemListPanel.this.handleDuplicate();
            }
        });
        this.toolBar.add(this.duplicate);
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_LIBRARY_DELETE_TOOLTIP");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemLibraryItemListPanel.this.handleDelete();
            }
        });
        this.toolBar.add(this.delete);
        JButton restore = ToolBar.button("SEAMCAT_ICON_RESTORE_DEFAULTS", "TOOLBAR_LIBRARY_RESTORE_DEFAULTS_TOOLTIP");
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogHelper.restoreLibrary(SystemLibraryItemListPanel.this.dialog)) {
                    SystemLibraryItemListPanel.this.resetToDefaults();
                }
            }
        });
        this.toolBar.add(restore);
        this.toolBar.addSeparator();
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand(helpClass)));
    }

    private void updateToolbarButtons() {
        boolean someSelected = this.systemTree.getSelectedSystem() != null;
        this.delete.setEnabled(someSelected);
        if (this.duplicate != null) {
            this.duplicate.setEnabled(someSelected);
        }
    }

    private void setModel(Collection<SystemListItem> elements) {
        this.systemTree.setSystems(elements);
        this.updateToolbarButtons();
    }

    public void resetToDefaults() {
        this.detailPanel = null;
        List<SystemListItem> defaults = Model.getDefaultsForType(SystemListItem.class);
        this.setModel(defaults);
    }

    private void handleDuplicate() {
        this.updateModel();
        SystemListItem selectedSystem = this.systemTree.getSelectedSystem();
        if (selectedSystem != null) {
            this.systemTree.duplicateSystem(selectedSystem);
        }
        this.updateToolbarButtons();
    }

    private void handleDelete() {
        SystemListItem selectedSystem = this.systemTree.getSelectedSystem();
        if (this.systemTree.isComponentSystem(selectedSystem) || this.confirmDelete(selectedSystem)) {
            this.detailPanel = null;
            this.systemTree.deleteSystem(selectedSystem);
            this.updateToolbarButtons();
        }
    }

    public boolean confirmDelete(SystemListItem selected) {
        SystemPlugin plugin = selected.getSystemPlugin();
        Class<? extends SystemModel> aClass = GenericTypeMarshaller.getPluginUIClass(plugin);
        int hits = 0;
        for (SystemListItem m : this.getModel()) {
            Class<? extends SystemModel> existing = GenericTypeMarshaller.getPluginUIClass(m.getSystemPlugin());
            if (!aClass.isAssignableFrom(existing)) continue;
            ++hits;
        }
        if (hits < 2) {
            int result = JOptionPane.showConfirmDialog(this, "You are about to delete the last system of this type.\nSEAMCAT will automatically create a default instance when closing the library.", "Removing last of it kind", 2, 2);
            return result == 0;
        }
        return true;
    }

    private void handleAddComponentToAggregate(SystemListItem aggregateListItem) {
        SystemPluginConfiguration selectedConfiguration;
        SystemPlugin component;
        List<SystemPluginConfiguration> systemConfigurations = Model.getInstance().getLibrary().getGroup(SystemPluginConfiguration.class);
        ArrayList<SystemModel> systemModels = new ArrayList<SystemModel>();
        for (SystemPluginConfiguration c : systemConfigurations) {
            if (AggregateSystemPlugin.class.isAssignableFrom(JarFiles.getClassForConfiguration(c))) continue;
            systemModels.add(c.configuration());
        }
        GenericSelectionDialog dialog = new GenericSelectionDialog(MainWindow.getInstance(), "Select library system", systemModels, false);
        if (dialog.display() && (component = JarFiles.instance(selectedConfiguration = systemConfigurations.get(dialog.getSelectedIndex()))) != null) {
            this.systemTree.addComponentToAggregate(aggregateListItem, new SystemListItem(component));
        }
    }

    protected void updateModel() {
        if (this.detailPanel != null) {
            SystemListItem model = this.detailPanel.getModel();
            this.systemTree.replaceSystemById(model);
        }
    }

    void closing() {
        this.updateModel();
        Library library = Model.getInstance().getLibrary();
        library.writeAll(SystemListItem.class, this.getModel());
        library.ensureConsistentLibrary();
    }

    void destroy() {
        EventBusFactory.getEventBus().unsubscribe(this);
    }

    public List<SystemListItem> getModel() {
        return this.systemTree.getSystems();
    }
}

