/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.types.Description;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.DiscreteFunction2Panel;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.TextItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.library.ChangeNotifier;

public class SpectrumEmissionMaskPanel
extends JPanel {
    private DiscreteFunction2Panel panel;
    private GenericPanelEditor<Description> idPanel;

    public SpectrumEmissionMaskPanel(EmissionMaskImpl model, ChangeNotifier notifier) {
        this.setLayout(new BorderLayout());
        this.panel = new DiscreteFunction2Panel();
        this.panel.setVictimCharacteristics(-1.0, -1.0, false, 0.0);
        this.panel.setFunctionable((MaskFunctionImpl)model.getEmissionMask(), null, null);
        this.idPanel = new GenericPanelEditor<Description>(MainWindow.getInstance(), Description.class, model.description());
        List<AbstractItem> allItems = this.idPanel.getAllItems();
        for (AbstractItem item : allItems) {
            if (!(item instanceof TextItem) || !item.getLabel().equals("Name")) continue;
            ((TextItem)item).addChangeNotifier(notifier);
        }
        this.idPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add(this.idPanel, "North");
        this.add((Component)this.panel, "Center");
    }

    public EmissionMaskImpl getModel() {
        MaskFunctionImpl functionable = this.panel.getFunctionable();
        return (EmissionMaskImpl)Factory.functionFactory().emissionMask(functionable, this.idPanel.getModel());
    }
}

