/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.presentation.systems.SystemListItem;

public class LibraryItemWrapper<T extends LibraryItem> {
    private final int index;
    private final T item;

    public LibraryItemWrapper(int index, T item) {
        this.index = index;
        this.item = item;
    }

    public LibraryItemWrapper(T item) {
        this.index = -1;
        this.item = item;
    }

    public T getItem() {
        return this.item;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return LibraryItemWrapper.toString(this.item);
    }

    public static String toString(LibraryItem item) {
        if (item instanceof CDMALLD) {
            CDMALLD lld = (CDMALLD)item;
            return (lld.system() != null ? lld.system() : "") + ": " + lld.frequency() + " MHz";
        }
        if (item instanceof SystemPluginConfiguration) {
            SystemPluginConfiguration conf = (SystemPluginConfiguration)item;
            return conf.configuration().description().name();
        }
        if (item instanceof SystemListItem) {
            return item.toString();
        }
        return item.description().name();
    }
}

