/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.JarFiles;
import org.seamcat.presentation.builder.PanelBuilder;
import org.seamcat.presentation.builder.SelectableTablePanel;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.util.StringHelper;

public class LibraryImportGroup
extends SelectableTablePanel {
    public LibraryImportGroup(List<? extends LibraryItem> imports, List<? extends LibraryItem> existing) {
        super(2);
        this.setLayout(new BorderLayout());
        JTable table = new JTable();
        table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return Boolean.class;
                }
                if (columnIndex == 3) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 3) {
                    return LibraryImportGroup.this.enabled(this, row, 2);
                }
                if (column == 4) {
                    return LibraryImportGroup.this.enabled(this, row, 2) && !LibraryImportGroup.this.enabled(this, row, 3);
                }
                return column != 0 && column != 1;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Name";
                }
                if (column == 1) {
                    return "Type";
                }
                if (column == 2) {
                    return "Import";
                }
                if (column == 3) {
                    return "Override";
                }
                return "Rename (only editable when override deselected)";
            }
        };
        table.setModel(model);
        this.model = model;
        model.setColumnCount(5);
        table.getColumnModel().getColumn(0).setPreferredWidth(300);
        table.getColumnModel().getColumn(1).setPreferredWidth(70);
        table.getColumnModel().getColumn(2).setPreferredWidth(60);
        table.getColumnModel().getColumn(3).setPreferredWidth(70);
        table.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.addLibraryList(imports, existing, model);
        JPanel control = PanelBuilder.panel(new FlowLayout(0)).button("Select All", this, "select").button("Deselect All", this, "deselect").get();
        Dimension d = table.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(d.width - 15, table.getRowHeight() * (imports.size() + 2)));
        this.add((Component)scrollPane, "Center");
        this.add((Component)control, "South");
    }

    private boolean enabled(DefaultTableModel model, int row, int column) {
        return (Boolean)model.getValueAt(row, column);
    }

    private void addLibraryList(List<? extends LibraryItem> list, List<? extends LibraryItem> library, DefaultTableModel model) {
        ArrayList<String> existing = new ArrayList<String>();
        for (LibraryItem libraryItem : library) {
            existing.add(LibraryItemWrapper.toString(libraryItem));
        }
        for (LibraryItem libraryItem : list) {
            String suggestName = "";
            if (existing.contains(LibraryItemWrapper.toString(libraryItem))) {
                suggestName = StringHelper.getDuplicatedName(LibraryItemWrapper.toString(libraryItem), existing);
            }
            model.addRow(new Object[]{new LibraryItemWrapper<LibraryItem>(0, libraryItem), Model.getInstance().getLibrary().typeName(libraryItem), true, false, suggestName});
        }
    }

    @Override
    public List<LibraryItem> selectedItems() {
        ArrayList<LibraryItem> list = new ArrayList<LibraryItem>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String reference;
            if (!this.selected(i)) continue;
            Object id = ((LibraryItemWrapper)this.model.getValueAt(i, 0)).getItem();
            if (!((Boolean)this.model.getValueAt(i, 3)).booleanValue() && (reference = this.model.getValueAt(i, 4).toString()) != null && !reference.isEmpty()) {
                if (id instanceof SystemPluginConfiguration) {
                    SystemPluginConfiguration prototype = Factory.prototype(SystemPluginConfiguration.class, (SystemPluginConfiguration)id);
                    DescriptionImpl description = new DescriptionImpl(reference, ((SystemPluginConfiguration)id).configuration().description().description());
                    SystemPlugin plugin = JarFiles.instance((SystemPluginConfiguration)id);
                    SystemPlugin renamed = ProxyHelper.cloneSystemPlugin(plugin, description);
                    Factory.when(prototype.configuration()).thenReturn((SystemModel)renamed.getUI());
                    id = Factory.build(prototype);
                } else if (id instanceof TransmitterModel) {
                    id = ProxyHelper.deepCloneComposite(TransmitterModel.class, (TransmitterModel)id, new DescriptionImpl(reference, id.description().description()));
                } else if (id instanceof ReceiverModel) {
                    id = ProxyHelper.deepCloneComposite(ReceiverModel.class, (ReceiverModel)id, new DescriptionImpl(reference, id.description().description()));
                } else if (id instanceof MutableLibraryItem) {
                    ((MutableLibraryItem)id).setDescription(new DescriptionImpl(reference, id.description().description()));
                } else if (id instanceof CDMALLD) {
                    CDMALinkLevelData link = new CDMALinkLevelData((CDMALLD)id);
                    link.setSystem(reference);
                    id = link.getModel();
                }
            }
            list.add((LibraryItem)id);
        }
        return list;
    }
}

