/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.builder.PanelBuilder;
import org.seamcat.presentation.builder.SelectableTablePanel;
import org.seamcat.presentation.library.LibraryItemWrapper;

public class LibraryExportGroup
extends SelectableTablePanel {
    public LibraryExportGroup(List<? extends LibraryItem> group) {
        super(2);
        this.setLayout(new BorderLayout());
        JTable table = new JTable();
        table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                return Boolean.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && column != 1;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Name";
                }
                if (column == 1) {
                    return "Type";
                }
                return "Export";
            }
        };
        table.setModel(model);
        this.model = model;
        model.setColumnCount(3);
        table.getColumnModel().getColumn(0).setPreferredWidth(500);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(100);
        JPanel control = PanelBuilder.panel(new FlowLayout(0)).button("Select All", this, "select").button("Deselect", this, "deselect").get();
        this.addLibraryList(group, model);
        Dimension d = table.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(d.width - 15, table.getRowHeight() * (group.size() + 2)));
        this.add((Component)scrollPane, "Center");
        this.add((Component)control, "South");
    }

    private void addLibraryList(List<? extends LibraryItem> list, DefaultTableModel model) {
        for (LibraryItem libraryItem : list) {
            model.addRow(new Object[]{new LibraryItemWrapper<LibraryItem>(0, libraryItem), Model.getInstance().getLibrary().typeName(libraryItem), true});
        }
    }
}

