/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalSubPanelLayoutManager
implements LayoutManager {
    private int componentSpacing = 0;

    public VerticalSubPanelLayoutManager() {
    }

    public VerticalSubPanelLayoutManager(int componentSpacing) {
        this.componentSpacing = componentSpacing;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int largestComponentPreferredWidth = 0;
        int accumulatedComponentPreferredHeight = 0;
        for (Component c : parent.getComponents()) {
            Dimension ps = c.getPreferredSize();
            accumulatedComponentPreferredHeight += ps.height;
            if (ps.width <= largestComponentPreferredWidth) continue;
            largestComponentPreferredWidth = ps.width;
        }
        Insets insets = parent.getInsets();
        return new Dimension(largestComponentPreferredWidth + insets.left + insets.right, accumulatedComponentPreferredHeight + insets.top + insets.bottom + this.totalComponentSpacing(parent.getComponents()));
    }

    private int totalComponentSpacing(Component[] components) {
        if (components.length > 0) {
            return (components.length - 1) * this.componentSpacing;
        }
        return 0;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int largestComponentMinimumWidth = 0;
        int accumulatedComponentMinimumHeight = 0;
        for (Component c : parent.getComponents()) {
            Dimension ms = c.getMinimumSize();
            accumulatedComponentMinimumHeight += ms.height;
            if (ms.width <= largestComponentMinimumWidth) continue;
            largestComponentMinimumWidth = ms.width;
        }
        Insets insets = parent.getInsets();
        return new Dimension(largestComponentMinimumWidth + insets.left + insets.right, accumulatedComponentMinimumHeight + insets.top + insets.bottom + this.totalComponentSpacing(parent.getComponents()));
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int top = 0;
        for (Component c : parent.getComponents()) {
            Dimension ps = c.getPreferredSize();
            c.setBounds(insets.left, top + insets.top, parent.getWidth() - insets.left - insets.right, (int)ps.getHeight());
            top = (int)((double)top + (ps.getHeight() + (double)this.componentSpacing));
        }
    }
}

