/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class ComponentSplitLayout {
    public static JPanel splitLayout(List<List<Component>> components, LinkedList<LinkedList<Integer>> positions) {
        int cols = components.size();
        if (cols == 1) {
            return ComponentSplitLayout.split(components.get(0), 0, positions.get(0));
        }
        LinkedList<Integer> colPos = positions.removeLast();
        ArrayList<Component> columns = new ArrayList<Component>();
        for (List<Component> component : components) {
            columns.add(ComponentSplitLayout.split(component, 0, positions.isEmpty() || component.size() == 1 ? new LinkedList<Integer>() : positions.removeFirst()));
        }
        return ComponentSplitLayout.split(columns, 1, colPos);
    }

    private static JPanel split(List<Component> components, int splitOrientation, LinkedList<Integer> position) {
        Object size;
        if (components.size() < 1) {
            throw new IllegalArgumentException("cannot layout empty component list");
        }
        JPanel col = new JPanel(new BorderLayout());
        int totalSize = 0;
        for (Component component : components) {
            size = component.getPreferredSize();
            totalSize = (int)((double)totalSize + ((Dimension)size).getHeight());
        }
        ArrayList<JSplitPane> splits = new ArrayList<JSplitPane>();
        Component last = null;
        size = components.iterator();
        while (size.hasNext()) {
            Component component;
            last = component = (Component)size.next();
            JSplitPane jSplitPane = new JSplitPane(splitOrientation);
            if (!position.isEmpty()) {
                jSplitPane.setDividerLocation(position.removeFirst());
            }
            jSplitPane.add(component);
            splits.add(jSplitPane);
        }
        if (splits.size() == 1) {
            col.add(components.get(0), "Center");
        } else {
            Container previous = null;
            for (int i = 0; i < splits.size() - 1; ++i) {
                if (previous != null) {
                    previous.add((Component)splits.get(i));
                }
                previous = (JSplitPane)splits.get(i);
            }
            assert (previous != null);
            previous.add(last);
            col.add((Component)splits.get(0), "Center");
        }
        return col;
    }

    public static <T> LinkedList<T> linkedList(T ... ts) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, ts);
        return list;
    }

    public static List<Component> clist(Component ... components) {
        ArrayList<Component> list = new ArrayList<Component>();
        Collections.addAll(list, components);
        return list;
    }
}

