/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.panelbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.seamcat.eventbus.Subscriber;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.GenericModelEditorPanel;
import org.seamcat.presentation.genericgui.ItemChangedEvent;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;
import org.seamcat.presentation.genericgui.panelbuilder.ConfigItem;

public class GenericPanelEditor<T>
extends GenericModelEditorPanel<T> {
    private List<AbstractItem> allItems = new ArrayList<AbstractItem>();
    private List<ChangeListener<T>> changeListeners = new ArrayList<ChangeListener<T>>();
    private Map<AbstractItem, List<GroupItem>> groups = new HashMap<AbstractItem, List<GroupItem>>();
    private Class<T> modelClass;
    private Map<Method, AbstractItem> parameters = new HashMap<Method, AbstractItem>();
    private PluginConfigurationPanel embeddedEditor;
    private Method embeddedMethod;
    private List<CalculatedValueItem> calculatedValues = new ArrayList<CalculatedValueItem>();

    public List<CalculatedValueItem> getCalculatedValues() {
        return this.calculatedValues;
    }

    public GenericPanelEditor(JFrame owner, Configuration configuration) {
        this(owner, configuration.getModelClass(), configuration.getModel());
    }

    public GenericPanelEditor(JFrame owner, Class<T> modelClass, T model) {
        this.modelClass = modelClass;
        for (Field field : modelClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (!ChangeListener.class.isAssignableFrom(field.getType())) continue;
                this.changeListeners.add((ChangeListener)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        LinkedHashMap<Method, Object> defaultValues = ProxyHelper.defaultValues(modelClass);
        if (defaultValues.size() == 1) {
            Map.Entry<Method, Object> only = defaultValues.entrySet().iterator().next();
            Class<?> type = only.getKey().getReturnType();
            if (AntennaGain.class.isAssignableFrom(type)) {
                this.embeddedEditor = new PluginConfigurationPanel(owner, (Configuration)only.getValue(), false, AntennaGainConfiguration.class);
            } else if (PropagationModel.class.isAssignableFrom(type)) {
                this.embeddedEditor = new PluginConfigurationPanel(owner, (Configuration)only.getValue(), false, PropagationModelConfiguration.class);
            }
            if (this.embeddedEditor != null) {
                this.embeddedMethod = only.getKey();
                if (model != null) {
                    try {
                        this.embeddedEditor.setModel((Configuration)only.getKey().invoke(model, new Object[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setLayout(new BorderLayout());
                this.add((Component)this.embeddedEditor, "Center");
                return;
            }
        }
        HashMap<String, AbstractItem> groupDefinition = new HashMap<String, AbstractItem>();
        HashMap<String, List<GroupItem>> members = new HashMap<String, List<GroupItem>>();
        for (Map.Entry<Method, Object> entry : defaultValues.entrySet()) {
            ConfigItem config = new ConfigItem(owner, entry.getKey(), model, entry.getValue());
            Method method = entry.getKey();
            Config con = method.getAnnotation(Config.class);
            AbstractItem item = config.getItem();
            if (config.isCalculated()) {
                this.calculatedValues.add(config.getCalculated());
            }
            if (!con.group().isEmpty()) {
                this.add(members, new GroupItem(item), con.group());
            }
            if (!con.invertedGroup().isEmpty()) {
                this.add(members, new GroupItem(item, true), con.invertedGroup());
            }
            if (!con.defineGroup().isEmpty()) {
                groupDefinition.put(con.defineGroup(), item);
            }
            this.parameters.put(method, item);
            this.addItem(item);
            this.allItems.add(item);
        }
        for (Map.Entry<Method, Object> entry : groupDefinition.entrySet()) {
            this.groups.put((AbstractItem)entry.getValue(), new ArrayList((Collection)members.get(entry.getKey())));
        }
        this.initializeWidgets();
        Subscriber.subscribe(this);
        this.changed(null);
        for (AbstractItem abstractItem : groupDefinition.values()) {
            this.handleGroupEnablement(this.groups.get(abstractItem), this.getGroupEnabled(abstractItem));
        }
    }

    private void add(Map<String, List<GroupItem>> members, GroupItem member, String name) {
        List<GroupItem> groupItems = members.get(name);
        if (groupItems == null) {
            groupItems = new ArrayList<GroupItem>();
            members.put(name, groupItems);
        }
        groupItems.add(member);
    }

    public List<AbstractItem> getAllItems() {
        return this.allItems;
    }

    @UIEventHandler
    public void handle(ItemChangedEvent event) {
        if (this.allItems.contains(event.getItem())) {
            this.changed((AbstractItem)event.getItem());
        }
    }

    @Override
    public void setGlobalRelevance(boolean relevance) {
        super.setGlobalRelevance(relevance);
        if (relevance) {
            for (AbstractItem item : this.allItems) {
                if (!this.groups.containsKey(item)) continue;
                this.handleGroupEnablement(this.groups.get(item), this.getGroupEnabled(item));
            }
        }
    }

    private void changed(AbstractItem changedItem) {
        if (this.groups.containsKey(changedItem)) {
            this.handleGroupEnablement(this.groups.get(changedItem), this.getGroupEnabled(changedItem));
        }
        for (ChangeListener<T> changeListener : this.changeListeners) {
            changeListener.handle(this.getModel(), this.allItems, changedItem);
        }
    }

    private boolean getGroupEnabled(AbstractItem group) {
        if (group instanceof BooleanItem) {
            return (Boolean)group.getValue();
        }
        Object value = group.getValue();
        if (value instanceof ValueWithUsageFlag) {
            return ((ValueWithUsageFlag)value).useValue;
        }
        return false;
    }

    private void handleGroupEnablement(List<GroupItem> group, boolean enable) {
        for (GroupItem member : group) {
            boolean value;
            member.item.setRelevant(member.inverted ? !enable : enable);
            if (!this.groups.containsKey(member.item)) continue;
            boolean bl = member.inverted ? !enable : (value = enable);
            if (value) {
                value = this.getGroupEnabled(member.item);
            }
            this.handleGroupEnablement(this.groups.get(member.item), value);
        }
    }

    @Override
    public T getModel() {
        return ProxyHelper.newInstance(this.modelClass, this.values());
    }

    public T getMutableMapListsModel() {
        return ProxyHelper.newInstanceMutableMapLists(this.modelClass, this.values());
    }

    public void setModel(T model) {
        if (this.embeddedEditor != null) {
            this.embeddedEditor.setModel((Configuration)model);
        } else {
            for (Method method : Cache.orderedConfig(this.modelClass)) {
                AbstractItem item = this.parameters.get(method);
                if (item == null) continue;
                try {
                    Object invoke = method.invoke(model, new Object[0]);
                    if (invoke instanceof OptionalValue) {
                        OptionalValue ov = (OptionalValue)invoke;
                        item.setValue(new ValueWithUsageFlag(ov.isRelevant(), ov.getValue()));
                        continue;
                    }
                    item.setValue(invoke);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    private LinkedHashMap<Method, Object> values() {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        if (this.embeddedEditor != null) {
            values.put(this.embeddedMethod, this.embeddedEditor.getModel());
        } else {
            for (Method method : Cache.orderedConfig(this.modelClass)) {
                AbstractItem item = this.parameters.get(method);
                if (item == null) continue;
                Object value = item.getValue();
                if (value instanceof ValueWithUsageFlag) {
                    ValueWithUsageFlag usage = (ValueWithUsageFlag)value;
                    value = Factory.results().optional(usage.useValue, usage.value);
                }
                values.put(method, value);
            }
        }
        return values;
    }

    public void addChangeListener(ChangeListener<T> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public String toString() {
        return "GenericPanelEditor(" + this.modelClass + ")";
    }

    public class GroupItem {
        private AbstractItem item;
        private boolean inverted;

        GroupItem(AbstractItem item, boolean inverted) {
            this.item = item;
            this.inverted = inverted;
        }

        GroupItem(AbstractItem item) {
            this.item = item;
        }
    }
}

