/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.panelbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.LocalEnvironmentUI;
import org.seamcat.model.plugin.system.LocalEnvironments;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.components.BorderPanelBuilder;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.GenericModelEditorPanel;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.TextItem;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeState;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.genericgui.panelbuilder.LibraryItemDescriptionPanel;
import org.seamcat.presentation.layout.ComponentSplitLayout;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsTxRxModel;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsTxRxPanel;
import org.seamcat.presentation.resources.ImageLoader;

public class CompositeEditor<T>
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private Class<T> compositeClass;
    private Map<Method, Object> widgetModelMap = new HashMap<Method, Object>();
    private boolean hasTabs;
    private JTabbedPane jTabbedPane;
    private CompositeState state;

    public void enableItem(Class<?> clazz, int number, boolean enable) {
        for (Map.Entry<Method, Object> entry : this.widgetModelMap.entrySet()) {
            Object widget = entry.getValue();
            if (clazz.isAssignableFrom(entry.getKey().getReturnType()) && widget instanceof GenericPanelEditor) {
                List<AbstractItem> items = ((GenericPanelEditor)widget).getAllItems();
                items.get(number - 1).setRelevant(enable);
            }
            if (!(widget instanceof CompositeEditor)) continue;
            ((CompositeEditor)widget).enableItem(clazz, number, enable);
        }
    }

    public void enableWidget(Class<?> clazz, boolean enable) {
        for (Map.Entry<Method, Object> entry : this.widgetModelMap.entrySet()) {
            Object widget = entry.getValue();
            if (clazz.isAssignableFrom(entry.getKey().getReturnType())) {
                int i;
                if (widget instanceof GenericPanelEditor) {
                    ((GenericPanelEditor)widget).setGlobalRelevance(enable);
                } else if (widget instanceof PluginConfigurationPanel) {
                    ((PluginConfigurationPanel)widget).setGlobalRelevance(enable);
                } else if (widget instanceof CompositeEditor && this.hasTabs && (i = this.jTabbedPane.indexOfComponent((Component)widget)) > 0) {
                    this.jTabbedPane.setEnabledAt(i, enable);
                }
            }
            if (!(widget instanceof CompositeEditor)) continue;
            ((CompositeEditor)widget).enableWidget(clazz, enable);
        }
    }

    public void setModel(T model) {
        this.removeAll();
        this.initialize(model);
        this.revalidate();
        this.repaint();
    }

    public CompositeEditor(JFrame owner, SystemPlugin systemPlugin, boolean libraryMode, ChangeNotifier notifier) {
        Object ui = systemPlugin.getUI();
        Class<? extends SystemModel> pluginUIClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
        this.state = new CompositeState(owner, libraryMode, notifier, new ModelEditor<T>(){

            @Override
            public Class<T> getModelClass() {
                return CompositeEditor.this.compositeClass;
            }

            @Override
            public T getModel() {
                return CompositeEditor.this.getModel();
            }

            @Override
            public void setModel(T model) {
                CompositeEditor.this.setModel(model);
            }
        });
        this.compositeClass = pluginUIClass;
        this.initialize(ui);
    }

    public CompositeEditor(JFrame owner, final Class<T> compositeClass, T compositeModel, boolean libraryMode, ChangeNotifier notifier) {
        this.state = new CompositeState(owner, libraryMode, notifier, new ModelEditor<T>(){

            @Override
            public Class<T> getModelClass() {
                return compositeClass;
            }

            @Override
            public T getModel() {
                return CompositeEditor.this.getModel();
            }

            @Override
            public void setModel(T model) {
                CompositeEditor.this.setModel(model);
            }
        });
        this.compositeClass = compositeClass;
        this.initialize(compositeModel);
    }

    private CompositeEditor(CompositeState state, Class<T> compositeClass, T compositeModel) {
        this.state = state;
        this.compositeClass = compositeClass;
        this.initialize(compositeModel);
    }

    private void initialize(T compositeModel) {
        JPanel[] tabs = new JPanel[5];
        String[] tabNames = new String[5];
        String[] tabToolTips = new String[5];
        int[][] heights = new int[6][6];
        int[] widths = new int[6];
        this.widgetModelMap.clear();
        ArrayList<SortedMap<Integer, JPanel>> columns = new ArrayList<SortedMap<Integer, JPanel>>();
        for (int i = 0; i < 5; ++i) {
            columns.add(new TreeMap());
        }
        for (Method method : this.compositeClass.getDeclaredMethods()) {
            CompositeEditor<Object> editor;
            UIPosition panel = method.getAnnotation(UIPosition.class);
            UITab tab = method.getAnnotation(UITab.class);
            Object invoke = null;
            try {
                invoke = method.invoke(compositeModel, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (panel != null) {
                GenericModelEditorPanel comp;
                heights[panel.col()][panel.row()] = panel.height();
                widths[panel.col()] = Math.max(widths[panel.col()], panel.width());
                Class<?> panelClass = method.getReturnType();
                PanelModelEditor custom = this.handleCustom(panel, invoke);
                if (custom != null) {
                    comp = custom.getPanel();
                    this.widgetModelMap.put(method, custom);
                } else {
                    if (AntennaGain.class.isAssignableFrom(panelClass)) {
                        comp = new PluginConfigurationPanel(this.state.owner, (Configuration)invoke, false, AntennaGainConfiguration.class);
                    } else if (PropagationModel.class.isAssignableFrom(panelClass)) {
                        comp = new PluginConfigurationPanel(this.state.owner, (Configuration)invoke, false, PropagationModelConfiguration.class);
                    } else if (CoverageRadius.class.isAssignableFrom(panelClass)) {
                        comp = new PluginConfigurationPanel(this.state.owner, (Configuration)invoke, false, CoverageRadiusConfiguration.class);
                    } else if (Description.class.isAssignableFrom(panelClass) && !this.state.libraryMode && LibraryItem.class.isAssignableFrom(this.compositeClass)) {
                        comp = new LibraryItemDescriptionPanel<T>(this.state.owner, this.state.notifier, this.compositeClass, this, (Description)invoke);
                    } else {
                        GenericPanelEditor<Object> editor2 = new GenericPanelEditor<Object>(this.state.owner, panelClass, invoke);
                        if (Description.class.isAssignableFrom(panelClass) && this.state.libraryMode) {
                            List<AbstractItem> allItems = editor2.getAllItems();
                            for (AbstractItem item : allItems) {
                                if (!(item instanceof TextItem) || !item.getLabel().equals("Name")) continue;
                                ((TextItem)item).addChangeNotifier(this.state.notifier);
                            }
                        }
                        comp = editor2;
                    }
                    this.widgetModelMap.put(method, comp);
                }
                SortedMap column = (SortedMap)columns.get(panel.col());
                if (panel.name().isEmpty()) {
                    column.put(panel.row(), comp);
                    continue;
                }
                BorderPanelBuilder builder = new BorderPanelBuilder(new JScrollPane(comp), panel.name());
                if (STRINGLIST.containsKey(panelClass.getName())) {
                    builder.help("See SEAMCAT manual", STRINGLIST.getString(panelClass.getName()));
                }
                if (STRINGLIST.containsKey(panelClass.getName() + ".info")) {
                    builder.info(CompositeEditor.replaceIMG(STRINGLIST.getString(panelClass.getName() + ".info")));
                }
                column.put(panel.row(), builder.build());
                continue;
            }
            if (tab == null) continue;
            tabs[tab.order()] = editor = new CompositeEditor<Object>(this.state, method.getReturnType(), invoke);
            this.widgetModelMap.put(method, tabs[tab.order()]);
            tabNames[tab.order()] = tab.value();
            if (!STRINGLIST.containsKey(method.getReturnType().getName() + ".tip")) continue;
            tabToolTips[tab.order()] = CompositeEditor.replaceIMG(STRINGLIST.getString(method.getReturnType().getName() + ".tip"));
        }
        this.setLayout(new BorderLayout());
        this.hasTabs = false;
        for (JPanel jPanel : tabs) {
            if (jPanel == null) continue;
            this.hasTabs = true;
            break;
        }
        if (this.hasTabs) {
            this.add((Component)this.createAboveTabsPanel(columns), "North");
            this.jTabbedPane = new JTabbedPane();
            for (int i = 0; i < tabs.length; ++i) {
                if (tabs[i] == null) continue;
                if (tabToolTips[i] != null) {
                    this.jTabbedPane.addTab(tabNames[i], null, tabs[i], tabToolTips[i]);
                    continue;
                }
                this.jTabbedPane.add(tabNames[i], tabs[i]);
            }
            this.add((Component)this.jTabbedPane, "Center");
        } else {
            LinkedList<LinkedList<Integer>> layout = new LinkedList<LinkedList<Integer>>();
            ArrayList<List<Component>> components = new ArrayList<List<Component>>();
            for (SortedMap sortedMap : columns) {
                ArrayList<JPanel> col = new ArrayList<JPanel>();
                for (JPanel jPanel : sortedMap.values()) {
                    col.add(jPanel);
                }
                if (col.isEmpty()) continue;
                components.add(col);
            }
            for (Object height : (Object)heights) {
                LinkedList<Integer> rowSplit = new LinkedList<Integer>();
                for (Object h : height) {
                    if (h == false) continue;
                    rowSplit.add((int)h);
                }
                if (rowSplit.isEmpty()) continue;
                layout.add(rowSplit);
            }
            LinkedList<Integer> colSplit = new LinkedList<Integer>();
            for (int width : widths) {
                if (width == 0) continue;
                colSplit.add(width);
            }
            if (!colSplit.isEmpty()) {
                layout.add(colSplit);
            }
            this.add((Component)ComponentSplitLayout.splitLayout(components, layout), "Center");
        }
    }

    private PanelModelEditor handleCustom(UIPosition panel, Object invoke) {
        if (invoke instanceof LocalEnvironments) {
            LocalEnvironments model = (LocalEnvironments)invoke;
            ArrayList<LocalEnvironmentUI> recs = new ArrayList<LocalEnvironmentUI>(model.receiverEnvironments());
            ArrayList<LocalEnvironmentUI> trans = new ArrayList<LocalEnvironmentUI>(model.transmitterEnvironments());
            LocalEnvironmentsTxRxModel uiModel = new LocalEnvironmentsTxRxModel(recs, trans);
            return new LocalEnvironmentsTxRxPanel(this.state.owner, uiModel);
        }
        if (panel.customUIBuilder() != CustomPanelBuilder.class) {
            Class<? extends CustomPanelBuilder> aClass = panel.customUIBuilder();
            try {
                CustomPanelBuilder builder = aClass.newInstance();
                return builder.build(invoke, this.state.modelEditor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String replaceIMG(String raw) {
        if (raw.contains("{$IMG")) {
            int begin = raw.indexOf("{$IMG");
            int end = raw.indexOf("}", begin);
            return raw.substring(0, begin) + "<img src=\"" + ImageLoader.class.getResource(raw.substring(begin + 6, end)) + "\"></body></html>";
        }
        return raw;
    }

    private JComponent createAboveTabsPanel(List<SortedMap<Integer, JPanel>> columns) {
        ArrayList<JPanel> allComponents = new ArrayList<JPanel>();
        for (SortedMap<Integer, JPanel> columnMap : columns) {
            for (JPanel panel : columnMap.values()) {
                if (panel == null) continue;
                allComponents.add(panel);
            }
        }
        if (allComponents.size() == 0) {
            return new JPanel();
        }
        if (allComponents.size() == 1) {
            return (JComponent)allComponents.get(0);
        }
        JSplitPane accumulator = new JSplitPane(1);
        accumulator.setResizeWeight(0.5);
        accumulator.add((Component)allComponents.get(0));
        for (int i = 1; i < allComponents.size() - 1; ++i) {
            accumulator.add((Component)allComponents.get(i));
            JSplitPane nextSplit = new JSplitPane(1);
            nextSplit.add(accumulator);
            accumulator = nextSplit;
        }
        accumulator.add((Component)allComponents.get(allComponents.size() - 1));
        return accumulator;
    }

    public T getModel() {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : Cache.ordered(this.compositeClass)) {
            Object model;
            Object modelHolder = this.widgetModelMap.get(method);
            if (modelHolder instanceof PluginConfigurationPanel) {
                model = ((PluginConfigurationPanel)modelHolder).getModel();
            } else if (modelHolder instanceof PanelModelEditor) {
                model = ((PanelModelEditor)modelHolder).getModel();
            } else if (modelHolder instanceof GenericPanelEditor) {
                model = ((GenericPanelEditor)modelHolder).getModel();
            } else if (modelHolder instanceof CompositeEditor) {
                model = ((CompositeEditor)modelHolder).getModel();
            } else if (modelHolder instanceof LibraryItemDescriptionPanel) {
                LibraryItemDescriptionPanel panel = (LibraryItemDescriptionPanel)modelHolder;
                model = panel.getDescription();
            } else {
                throw new RuntimeException("unknown instance of model widget: " + modelHolder);
            }
            values.put(method, model);
        }
        return ProxyHelper.newInstance(this.compositeClass, values);
    }

    public void activeTab(Integer integer) {
        if (this.jTabbedPane != null) {
            this.jTabbedPane.setSelectedIndex(integer);
        }
    }

    public Integer getActiveTab() {
        if (this.jTabbedPane != null) {
            return this.jTabbedPane.getSelectedIndex();
        }
        return 0;
    }

    public JTabbedPane getTabPane() {
        return this.jTabbedPane;
    }
}

