/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.library.ChangeNotifier;

public class TextItem
extends AbstractItem<String, Object> {
    private JComponent valueWidget;
    private int linesToDisplay = 1;
    private TextWidgetValueUpdatedEvent event;
    private boolean readOnly;

    @Override
    public TextItem label(String label) {
        super.label(label);
        return this;
    }

    public TextItem linesToDisplay(int linesToDisplay) {
        this.linesToDisplay = linesToDisplay;
        return this;
    }

    public TextItem valueUpdatedEvent(TextWidgetValueUpdatedEvent event) {
        this.event = event;
        return this;
    }

    public TextItem readOnly() {
        this.readOnly = true;
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        if (this.readOnly) {
            JLabel jLabel = new JLabel();
            jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.valueWidget = jLabel;
            widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        } else if (this.linesToDisplay == 1) {
            this.valueWidget = new JTextField();
            this.valueWidget.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("value")) {
                        TextItem.this.fireItemChanged();
                    }
                }
            });
            widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        } else {
            JTextArea textArea = new JTextArea(3, 1);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            JScrollPane pScroll = new JScrollPane(textArea);
            widgets.add(new WidgetAndKind(pScroll, WidgetKind.VALUE));
            this.valueWidget = textArea;
        }
        if (this.event != null) {
            this.valueWidget.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    TextItem.this.event.setValue(TextItem.this.getValue());
                    EventBusFactory.getEventBus().publish(TextItem.this.event);
                }
            });
        }
        return widgets;
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        this.valueWidget.setEnabled(relevant);
    }

    public void addChangeNotifier(final ChangeNotifier notifier) {
        this.valueWidget.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                notifier.changed();
            }
        });
    }

    @Override
    public String getValue() {
        if (this.valueWidget instanceof JTextComponent) {
            return ((JTextComponent)this.valueWidget).getText();
        }
        if (this.valueWidget instanceof JLabel) {
            return ((JLabel)this.valueWidget).getText();
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        if (this.valueWidget instanceof JTextComponent) {
            ((JTextComponent)this.valueWidget).setText(value);
        } else if (this.valueWidget instanceof JLabel) {
            if (!value.startsWith("<html>")) {
                ((JLabel)this.valueWidget).setText("<html><body style='width: 200px'>" + value + "</body></html>");
            } else {
                ((JLabel)this.valueWidget).setText(value);
            }
        }
    }
}

