/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;

public class OptionalSelectionItem<ValueType>
extends AbstractItem<ValueWithUsageFlag<ValueType>, Object> {
    private List<ComboBoxElement<ValueType>> values = new ArrayList<ComboBoxElement<ValueType>>();
    private JComboBox valueWidget;
    private JCheckBox conditionCheckBox;

    @Override
    public OptionalSelectionItem<ValueType> label(String label) {
        super.label(label);
        return this;
    }

    public OptionalSelectionItem<ValueType> values(Iterable<ValueType> values) {
        for (ValueType value : values) {
            this.values.add(new ComboBoxElement<ValueType>(value));
        }
        return this;
    }

    public OptionalSelectionItem<ValueType> value(ValueType value, String selectionString) {
        this.values.add(new ComboBoxElement<ValueType>(value, selectionString));
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.conditionCheckBox = new JCheckBox();
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalSelectionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.valueWidget = new JComboBox();
        this.valueWidget.setModel(new DefaultComboBoxModel<Object>(this.values.toArray()));
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalSelectionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        return widgets;
    }

    private ComboBoxElement<ValueType> findElementForValue(ValueType value) {
        for (ComboBoxElement<ValueType> element : this.values) {
            if (!element.value.equals(value)) continue;
            return element;
        }
        return null;
    }

    @Override
    public ValueWithUsageFlag<ValueType> getValue() {
        Object value = ((ComboBoxElement)this.valueWidget.getSelectedItem()).value;
        return new ValueWithUsageFlag(this.conditionCheckBox.isSelected(), value);
    }

    @Override
    public void setValue(ValueWithUsageFlag<ValueType> value) {
        if (value == null) {
            this.valueWidget.setSelectedItem(value);
            return;
        }
        this.conditionCheckBox.setSelected(value.useValue);
        ComboBoxElement element = this.findElementForValue(value.value);
        if (element == null) {
            throw new RuntimeException("Value " + value + " is not valid for object selection");
        }
        this.valueWidget.setSelectedItem(element);
    }

    public void addActionListener(ActionListener listener) {
        this.valueWidget.addActionListener(listener);
    }

    private static class ComboBoxElement<ValueType> {
        ValueType value;
        String selectionString;

        ComboBoxElement(ValueType value, String selectionString) {
            this.value = value;
            this.selectionString = selectionString;
        }

        ComboBoxElement(ValueType value) {
            this(value, value.toString());
        }

        public String toString() {
            return this.selectionString;
        }
    }
}

