/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.seamcat.function.FunctionType;
import org.seamcat.model.functions.Function;
import org.seamcat.presentation.DialogFunctionDefine;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunctionAdapter;

public class OptionalFunctionItem
extends AbstractItem<ValueWithUsageFlag<Function>, Object> {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private String functionDialogTitle;
    private Function function;
    private FunctionType functionType = FunctionType.none();
    private JFrame parent;
    private JCheckBox conditionCheckBox;
    private ButtonWithValuePreviewTip functionButton;
    private LabelWithValuePreviewTip valuePreviewLabel;
    private String xAxis;
    private String yAxis;

    public OptionalFunctionItem(JFrame parent, String title, String xAxis, String yAxis) {
        this.parent = parent;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.functionDialogTitle = title;
    }

    public OptionalFunctionItem functionType(FunctionType functionType) {
        this.functionType = functionType;
        return this;
    }

    @Override
    public ValueWithUsageFlag<Function> getValue() {
        return new ValueWithUsageFlag<Function>(this.conditionCheckBox.isSelected(), this.function);
    }

    @Override
    public void setValue(ValueWithUsageFlag<Function> value) {
        this.conditionCheckBox.setSelected(value.useValue);
        this.function = (Function)value.value;
        if (!this.functionType.isNone()) {
            this.functionButton.setText("Pattern");
        }
        this.updateValuePreview(this.function);
        this.updateWidgetRelevance();
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.conditionCheckBox = new JCheckBox(this.getLabel());
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalFunctionItem.this.updateWidgetRelevance();
                OptionalFunctionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.functionButton = new ButtonWithValuePreviewTip(STRINGLIST.getString("BTN_CAPTION_FUNCTION"));
        this.functionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalFunctionItem.this.showFunctionDialog();
            }
        });
        widgets.add(new WidgetAndKind(this.functionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        widgets.add(new WidgetAndKind(new JLabel(this.getUnit()), WidgetKind.UNIT));
        return widgets;
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        this.updateWidgetRelevance();
    }

    private void showFunctionDialog() {
        DialogFunctionDefine dialog = new DialogFunctionDefine(this.parent, this.function, this.functionType, this.xAxis, this.yAxis);
        if (dialog.show(this.function, this.functionDialogTitle)) {
            this.function = dialog.getFunction();
            this.updateValuePreview(this.function);
            this.fireItemChanged();
        }
        dialog.destroy();
    }

    private void updateValuePreview(Function function) {
        ValuePreviewableFunctionAdapter previewable = new ValuePreviewableFunctionAdapter(function).axisNames(this.xAxis, this.yAxis);
        if (this.functionType.isNone()) {
            this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(function.toString()));
            this.valuePreviewLabel.setPreviewable(previewable);
        } else {
            this.valuePreviewLabel.setText("");
        }
        this.functionButton.setPreviewable(previewable);
    }

    private void updateWidgetRelevance() {
        this.functionButton.setEnabled(this.isRelevant() && this.conditionCheckBox.isSelected());
        this.valuePreviewLabel.setEnabled(this.isRelevant() && this.conditionCheckBox.isSelected());
    }
}

