/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.presentation.genericgui.IdentityMapper;
import org.seamcat.presentation.genericgui.ValueMapper;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.genericgui.util.Assert;

public class OptionalDoubleItem
extends AbstractItem<ValueWithUsageFlag<Double>, Object> {
    private CalculatorInputField valueWidget;
    private JCheckBox conditionCheckBox;
    private ValueMapper<Double, Double> valueMapper = new IdentityMapper<Double>();

    @Override
    public OptionalDoubleItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public OptionalDoubleItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.conditionCheckBox = new JCheckBox(this.getLabel());
        if (this.getToolTipText() != null) {
            this.conditionCheckBox.setToolTipText(this.getToolTipText());
        }
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalDoubleItem.this.updateWidgetRelevance();
                OptionalDoubleItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.valueWidget = new CalculatorInputField();
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalDoubleItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        widgets.add(new WidgetAndKind(new JLabel(this.getUnit()), WidgetKind.UNIT));
        return widgets;
    }

    @Override
    public ValueWithUsageFlag<Double> getValue() {
        return new ValueWithUsageFlag<Double>(this.conditionCheckBox.isSelected(), this.valueMapper.mapToModelValue(this.valueWidget.getValueAsDouble()));
    }

    @Override
    public void setValue(ValueWithUsageFlag<Double> value) {
        Assert.notNull("Value is null", value);
        this.valueWidget.setValue(this.valueMapper.mapToWidgetValue((Double)value.value));
        this.conditionCheckBox.setSelected(value.useValue);
        this.updateWidgetRelevance();
    }

    private void updateWidgetRelevance() {
        this.valueWidget.setEnabled(this.conditionCheckBox.isSelected());
    }
}

