/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.presentation.genericgui.IdentityMapper;
import org.seamcat.presentation.genericgui.ValueMapper;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.util.Assert;

public class DoubleItem
extends AbstractItem<Double, Object> {
    private CalculatorInputField valueWidget;
    private ValueMapper<Double, Double> valueMapper = new IdentityMapper<Double>();
    private FocusAdapter listener;

    @Override
    public DoubleItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public DoubleItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    public DoubleItem mapper(ValueMapper<Double, Double> mapper) {
        this.valueMapper = mapper;
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.valueWidget = new CalculatorInputField();
        this.listener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DoubleItem.this.fireItemChanged();
            }
        };
        this.valueWidget.addFocusListener(this.listener);
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        return widgets;
    }

    @Override
    public Double getValue() {
        return this.valueMapper.mapToModelValue(this.valueWidget.getValueAsDouble());
    }

    @Override
    public void setValue(Double value) {
        Assert.notNull("Value is null", value);
        this.valueWidget.setValue(this.valueMapper.mapToWidgetValue(value));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.valueWidget.removeFocusListener(this.listener);
        this.valueWidget.dispose();
    }
}

