/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.genericgui.ItemChangedEvent;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.Item;

public abstract class AbstractItem<ValueType, ModelType>
implements Item<ValueType> {
    private List<WidgetAndKind> widgets;
    private String label;
    private String unit;
    private boolean relevant = true;
    private ModelType model;
    private String tooltip;
    private String information;
    private JLabel jLabel;
    private JLabel jUnit;
    private JLabel info;

    public AbstractItem tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public AbstractItem information(String information) {
        this.information = information;
        return this;
    }

    public AbstractItem label(String label) {
        this.label = label;
        return this;
    }

    public AbstractItem unit(String unit) {
        this.unit = unit;
        return this;
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    public ModelType getModel() {
        return this.model;
    }

    @Override
    public List<WidgetAndKind> getWidgets() {
        if (this.widgets == null) {
            this.widgets = this.createWidgets();
        }
        return this.widgets;
    }

    public void initialize() {
        this.getWidgets();
    }

    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        if (this.label != null) {
            this.jLabel = new JLabel(this.label);
            widgets.add(new WidgetAndKind(this.jLabel, WidgetKind.LABEL));
            if (this.tooltip != null) {
                this.jLabel.setToolTipText(this.tooltip);
            }
        }
        this.jUnit = this.unit == null ? new JLabel("") : new JLabel(this.unit);
        widgets.add(new WidgetAndKind(this.jUnit, WidgetKind.UNIT));
        if (this.information != null) {
            this.info = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_INFORMATION", 0));
            this.info.setToolTipText(this.information);
            widgets.add(new WidgetAndKind(this.info, WidgetKind.UNIT));
        }
        return widgets;
    }

    protected String getInformation() {
        return this.information;
    }

    public AbstractItem setLabelText(String text) {
        if (this.jLabel != null) {
            this.jLabel.setText(text);
        }
        return this;
    }

    public AbstractItem setUnitText(String text) {
        if (this.jUnit != null) {
            this.jUnit.setText(text);
        }
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setInformation(String information) {
        this.info.setVisible(true);
        this.info.setToolTipText(information);
    }

    @Override
    public void setRelevant(boolean relevant) {
        this.relevant = relevant;
        for (WidgetAndKind wik : this.widgets) {
            wik.getWidget().setEnabled(relevant);
        }
    }

    @Override
    public boolean isRelevant() {
        return this.relevant;
    }

    protected void fireItemChanged() {
        EventBusFactory.getEventBus().publish(new ItemChangedEvent(this));
    }

    public void dispose() {
        for (WidgetAndKind widget : this.widgets) {
            widget.dispose();
        }
    }

    public void updateLabel(String label) {
        this.label = label;
        if (this.jLabel != null) {
            this.jLabel.setText(label);
        }
    }
}

