/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui;

import java.awt.Cursor;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.seamcat.model.plugin.eventprocessing.CanFail;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.genericgui.CompletionUITask;
import org.seamcat.presentation.genericgui.LongTaskFailable;

public class LongTaskSwingExecutor {
    private static final Logger LOG = Logger.getLogger(LongTaskSwingExecutor.class);

    public static void execute(LongTask task) {
        LongTaskSwingExecutor.execute(task, null);
    }

    public static void execute(final LongTask task, final CompletionUITask complete) {
        final Window owner = task instanceof LongTaskFailable ? ((LongTaskFailable)task).getOwner() : MainWindow.getInstance();
        owner.setCursor(Cursor.getPredefinedCursor(3));
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                return task.process();
            }

            @Override
            protected void done() {
                try {
                    task.done(this.get());
                    if (complete != null) {
                        complete.complete();
                    }
                }
                catch (ExecutionException e) {
                    if (task instanceof CanFail) {
                        ((CanFail)((Object)task)).failed((Exception)e.getCause());
                    } else {
                        LOG.error("Exception caught during long task execution", e);
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception caught during long task execution", e);
                }
                finally {
                    owner.setCursor(Cursor.getDefaultCursor());
                }
            }
        }.execute();
    }
}

