/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.builder.AsActionListener;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.GenericListDetailDialog;
import org.seamcat.presentation.eventprocessing.EventProcessingPanel;
import org.seamcat.presentation.eventprocessing.ReadOnlyPanel;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.util.StringHelper;

public class EventProcessingSelectionPanel
extends JPanel {
    private EventProcessingPanel container;
    private Workspace model;
    private JList list;
    private DefaultListModel listModel;
    private JToolBar toolBar;
    private JButton duplicate;
    private JButton delete;
    private JButton export;
    private boolean mute = false;

    public EventProcessingSelectionPanel(EventProcessingPanel container, Workspace model) {
        this.container = container;
        this.model = model;
        this.list = new JList();
        this.listModel = new DefaultListModel();
        for (EventProcessingConfiguration configuration : model.getEventProcessingList()) {
            this.listModel.addElement(configuration);
        }
        this.initialize();
    }

    private void initialize() {
        this.toolBar = new JToolBar();
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.setupToolbar();
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.list);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)jScrollPane, "Center");
        this.list.setModel(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (EventProcessingSelectionPanel.this.mute || e.getValueIsAdjusting()) {
                    return;
                }
                EventProcessingSelectionPanel.this.container.updateCurrentEditor();
                if (!EventProcessingSelectionPanel.this.listModel.isEmpty() && EventProcessingSelectionPanel.this.list.getSelectedIndex() != -1) {
                    if (!(EventProcessingSelectionPanel.this.list.getSelectedValue() instanceof EventProcessingConfiguration)) {
                        return;
                    }
                    EventProcessingSelectionPanel.this.container.selected(EventProcessingSelectionPanel.this.list.getSelectedIndex());
                } else {
                    EventProcessingSelectionPanel.this.container.deSelect();
                }
                EventProcessingSelectionPanel.this.update();
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    EventProcessingSelectionPanel.this.delete();
                }
            }
        });
        if (!this.listModel.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)leftPanel, "Center");
        this.update();
    }

    private void setupToolbar() {
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_ADD", "TOOLBAR_EPP_ADD", this, "add"));
        this.duplicate = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "TOOLBAR_EPP_DUPLICATE", this, "duplicate");
        this.toolBar.add(this.duplicate);
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_EPP_REMOVE", this, "delete");
        this.toolBar.add(this.delete);
        this.export = ToolBar.button("SEAMCAT_ICON_EXPORT_LIBRARY", "TOOLBAR_EPP_EXPORT", this, "export");
        this.toolBar.add(this.export);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.addSeparator();
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand("http://confluence.seamcat.org/display/SH/11.2+Event+processing+GUI")));
    }

    @AsActionListener(value="add")
    public void addDialog() {
        this.container.updateCurrentEditor();
        ArrayList<Configuration> plugins = new ArrayList<Configuration>(Model.getInstance().getLibrary().getPluginConfigurations(EventProcessingConfiguration.class));
        GenericListDetailDialog<Configuration> dialog = new GenericListDetailDialog<Configuration>((JFrame)MainWindow.getInstance(), "Event processing plugin", plugins){

            @Override
            public void selectedElement(Configuration model) {
                JPanel jPanel = new JPanel(new LabeledPairLayout());
                jPanel.add((Component)new JLabel("Name"), "label");
                jPanel.add((Component)new JLabel(model.description().name()), "field");
                jPanel.add((Component)new JLabel("Description"), "label");
                jPanel.add((Component)new JLabel(model.description().description()), "field");
                ReadOnlyPanel.addReadOnly(jPanel, model);
                this.setDetail(new BorderPanel(jPanel, "Event Processing Plugin"));
            }
        };
        if (dialog.display()) {
            this.add((EventProcessingConfiguration)dialog.getSelectedValue());
            this.update();
        }
    }

    private void add(EventProcessingConfiguration add) {
        this.model.getEventProcessingList().add(add);
        this.listModel.addElement(add);
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
    }

    @AsActionListener(value="duplicate")
    public void duplicate() {
        this.container.updateCurrentEditor();
        EventProcessingConfiguration original = (EventProcessingConfiguration)this.list.getSelectedValue();
        Configuration clone = original.copy();
        String duplicatedName = StringHelper.getDuplicatedName(((MutableLibraryItem)((Object)clone)).description().name(), this.listModel);
        ((MutableLibraryItem)((Object)clone)).setDescription(new DescriptionImpl(duplicatedName, original.description().description()));
        this.add((EventProcessingConfiguration)clone);
        this.update();
    }

    @AsActionListener(value="delete")
    public void delete() {
        this.mute = true;
        int index = this.list.getSelectedIndex();
        this.listModel.removeElement(this.list.getSelectedValue());
        this.model.getEventProcessingList().remove(index);
        this.container.deSelect();
        this.mute = false;
        if (index > 0) {
            this.list.setSelectedIndex(index - 1);
        } else if (this.listModel.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    @AsActionListener(value="export")
    public void export() {
        this.container.updateCurrentEditor();
        EventProcessingConfiguration configuration = (EventProcessingConfiguration)this.list.getSelectedValue();
        if (configuration != null) {
            Configuration clone = configuration.copy();
            if (Model.getInstance().getLibrary().addPluginConfiguration(clone)) {
                Model.getInstance().persist();
                EventBusFactory.getEventBus().publish(new InfoMessageEvent("Configuration exported to library"));
            } else {
                EventBusFactory.getEventBus().publish(new InfoMessageEvent("Name already exists in library. Could not export"));
            }
        }
    }

    public EventProcessingConfiguration get(int index) {
        return (EventProcessingConfiguration)this.listModel.get(index);
    }

    public void update() {
        boolean enable = !this.listModel.isEmpty() && this.list.getSelectedIndex() != -1;
        this.delete.setEnabled(enable);
        this.duplicate.setEnabled(enable);
        this.export.setEnabled(enable);
        this.revalidate();
        this.repaint();
    }

    public void set(int index, EventProcessingConfiguration configuration) {
        this.listModel.set(index, configuration);
    }
}

