/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.eventprocessing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.types.result.Results;
import org.seamcat.presentation.genericgui.CompletionUITask;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.simulationview.SimulationView;

public class ControlButton
extends JButton {
    private static final Logger LOG = Logger.getLogger(ControlButton.class);
    private Results results;
    private SimulationResult simulationResult;

    public ControlButton(final SimulationView view, String name, final Method method, final PostProcessingUI postProcessingUI, final Object[] arguments, final int indexOfResultTypes, final int indexOfSimulationResults) {
        super(name);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object result;
                    if (indexOfResultTypes != -1) {
                        arguments[indexOfResultTypes] = ControlButton.this.results;
                    }
                    if (indexOfSimulationResults != -1) {
                        arguments[indexOfSimulationResults] = ControlButton.this.simulationResult;
                    }
                    if ((result = method.invoke((Object)postProcessingUI, arguments)) instanceof LongTask) {
                        LongTaskSwingExecutor.execute((LongTask)result, new CompletionUITask(){

                            @Override
                            public void complete() {
                                view.updateResults();
                            }
                        });
                    } else {
                        view.updateResults();
                    }
                }
                catch (Exception e) {
                    LOG.error("", e);
                }
            }
        });
    }

    public void setResults(Results results) {
        this.results = results;
    }

    public void setSimulationResult(SimulationResult simulationResult) {
        this.simulationResult = simulationResult;
    }
}

