/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.display.IdentificationPanel;
import org.seamcat.presentation.display.SignalChartFactory;
import org.seamcat.presentation.display.VectorDisplaySelector;
import org.seamcat.presentation.display.VectorHelper;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.presentation.propagationtest.VectorHolder;
import org.seamcat.tabulardataio.DataResultType;
import org.seamcat.tabulardataio.FileDataIO;

public class VectorPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final int EVENT_LIMIT = 20000;
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel graphPanel = new JPanel(this.cardLayout);
    private IdentificationPanel idPanel = new IdentificationPanel();
    private final VectorDisplaySelector selector = new VectorDisplaySelector(this);
    private ChartPanel vectorChart;
    private ChartPanel vectorLogChart;
    private ChartPanel densityChart;
    private ChartPanel cumulativeChart;
    private List<VectorHolder> propagations;
    private boolean signalIsConstant = false;
    private double minDataValue = Double.MAX_VALUE;
    private double maxDataValue = Double.MIN_VALUE;
    private String label;
    private String unit;
    private String mtitle;
    private Component owner;
    private boolean hasSortedDistributions;
    private boolean showLimit = false;
    private String limitTitle;
    private double limitValue;

    public VectorPanel(Component owner) {
        this.setLayout(new BorderLayout());
        this.owner = owner;
    }

    public void show(double[] data, String title, String unit, String label, String limitTitle, double limitValue) {
        this.showLimit = true;
        this.limitTitle = limitTitle;
        this.limitValue = limitValue;
        this.show(data, title, unit, label);
    }

    public void show(double[] _data, String title, String unit, String label) {
        this.show(this.createList(_data, title, unit), title, unit, label);
    }

    public void showL(List<VectorHolder> propagations, String title, String unit, String label) {
        int maxSize = VectorHelper.getLongestDisplayData(propagations);
        if (maxSize > 20000) {
            label = label + " (samples of out of " + maxSize + ")";
        }
        this.show(propagations, title, unit, label);
    }

    private void show(List<VectorHolder> propagations, String title, String unit, String label) {
        this.propagations = propagations;
        this.label = label;
        this.unit = unit;
        this.mtitle = title;
        this.initPropagations();
        this.createCharts();
        this.addControls(this.owner);
        this.setListeners();
        this.setRanges();
        this.selector.getCdf().doClick();
        if (propagations != null && propagations.size() == 1) {
            this.setIdentificationPanel(propagations.get(0));
        } else {
            this.setIdentificationPanel(null);
        }
    }

    private List<VectorHolder> createList(double[] _data, String title, String unit) {
        ArrayList<VectorHolder> propagations = new ArrayList<VectorHolder>();
        if (_data != null) {
            VectorHolder propagationHolder = new VectorHolder();
            propagationHolder.setData(_data);
            propagationHolder.setTitle(title);
            propagationHolder.setUnit(unit);
            propagations.add(propagationHolder);
        }
        return propagations;
    }

    private void addControls(Component parent) {
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(200, right.getPreferredSize().height));
        right.add(this.selector);
        right.add(this.idPanel);
        right.add(new ControlButtonPanel(parent, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(VectorPanel.this.getParent());
                if (fileIO != null) {
                    DataResultType type = DataResultType.vector;
                    if (VectorPanel.this.selector.getVector().isSelected() && VectorPanel.this.hasSortedDistributions) {
                        type = DataResultType.graph;
                    } else if (VectorPanel.this.selector.getCdf().isSelected()) {
                        type = DataResultType.cdf;
                    } else if (VectorPanel.this.selector.getDensity().isSelected()) {
                        type = DataResultType.pdf;
                        for (VectorHolder holder : VectorPanel.this.getPropagationHolders()) {
                            holder.binCount = VectorPanel.this.selector.getBinSize();
                        }
                    }
                    fileIO.savePropogationHolders(type, VectorPanel.this.getPropagationHolders());
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VectorPanel.this.selector.getVector().isSelected()) {
                    ChartSaver.saveChart(VectorPanel.this.vectorChart);
                } else if (VectorPanel.this.selector.getCdf().isSelected()) {
                    ChartSaver.saveChart(VectorPanel.this.cumulativeChart);
                } else if (VectorPanel.this.selector.getDensity().isSelected()) {
                    ChartSaver.saveChart(VectorPanel.this.densityChart);
                }
            }
        }));
        this.add((Component)right, "East");
    }

    private void createCharts() {
        this.removeAll();
        XYSeriesCollection collection = VectorHelper.getVectorSeriesCollection(this.propagations);
        XYSeriesCollection cumulativeCollection = VectorHelper.getCumulativeSeriesCollection(this.propagations);
        boolean legend = true;
        if (this.propagations.size() > 6) {
            legend = false;
        }
        this.vectorChart = SignalChartFactory.createVectorChart(this.propagations, this.getFont(), collection, legend, this.label);
        if (this.showLimit) {
            this.addCriteria(this.vectorChart, true, 0.0, this.propagations.get(0).getData().length);
        }
        this.vectorLogChart = SignalChartFactory.createVectorLogChart("", "", collection, 20000.0, this.getFont());
        this.cumulativeChart = SignalChartFactory.createCumulativeChart("", "", cumulativeCollection, this.getFont(), this.signalIsConstant, this.mtitle, this.unit);
        if (this.showLimit) {
            this.addCriteria(this.cumulativeChart, false, 0.0, 1.0);
        }
        if (cumulativeCollection.getSeries().size() > 3) {
            this.cumulativeChart.getChart().getXYPlot().setBackgroundPaint(this.getBackground());
            this.vectorChart.getChart().getXYPlot().setBackgroundPaint(this.getBackground());
            this.vectorLogChart.getChart().getXYPlot().setBackgroundPaint(this.getBackground());
        }
        if (!this.signalIsConstant) {
            HistogramDataset histogramDataset = VectorHelper.getDensityHistogram(this.propagations);
            if (this.propagations.isEmpty()) {
                this.selector.setBinSize(10);
            } else {
                this.selector.setBinSize(this.propagations.get((int)0).getDensityDataSeries().bin);
            }
            this.densityChart = SignalChartFactory.createDensityGraph("", this.unit, this.getFont(), histogramDataset);
            this.densityChart.getChart().setTitle(this.mtitle);
            if (this.propagations.size() > 3) {
                this.densityChart.getChart().getXYPlot().setBackgroundPaint(this.getBackground());
            }
            if (this.showLimit) {
                double max = 0.0;
                for (int i = 0; i < histogramDataset.getItemCount(0); ++i) {
                    double value = histogramDataset.getY(0, i).doubleValue();
                    if (!(value > max)) continue;
                    max = value;
                }
                this.addCriteria(this.densityChart, false, 0.0, max);
            }
            this.graphPanel.add((Component)this.densityChart, "pdf");
        }
        this.graphPanel.add((Component)this.vectorChart, "vector");
        this.graphPanel.add((Component)this.vectorLogChart, "vectorLog");
        this.graphPanel.add((Component)this.cumulativeChart, "cumulative");
        this.add((Component)this.graphPanel, "Center");
        this.setUpGraphLabels();
        this.setVisible(true);
        this.showVectorButtons(this.hasSortedDistributions);
    }

    private void addCriteria(ChartPanel panel, boolean horizontal, double min, double max) {
        XYSeriesCollection criteriaLimit = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)this.limitTitle));
        if (horizontal) {
            series.add(min, this.limitValue);
            series.add(max, this.limitValue);
        } else {
            series.add(this.limitValue, min);
            series.add(this.limitValue, max);
        }
        criteriaLimit.addSeries(series);
        int count = panel.getChart().getXYPlot().getDatasetCount();
        panel.getChart().getXYPlot().setDataset(count, criteriaLimit);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        panel.getChart().getXYPlot().setRenderer(count, renderer);
    }

    public void showVectorButtons(boolean flag) {
        this.selector.getVectorLinear().setVisible(flag);
        this.selector.getVectorLog().setVisible(flag);
    }

    private void setUpGraphLabels() {
        DecimalFormat format = new DecimalFormat("0.000");
        DecimalFormatSymbols decimalSymbol = new DecimalFormatSymbols(Locale.getDefault());
        decimalSymbol.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(decimalSymbol);
        ((LogAxis)this.vectorLogChart.getChart().getXYPlot().getDomainAxis()).setNumberFormatOverride(format);
        this.vectorChart.getChart().setTitle(this.mtitle);
        this.vectorLogChart.getChart().setTitle(this.mtitle);
        this.vectorChart.getChart().getXYPlot().getRangeAxis().setLabel(this.unit);
        this.vectorLogChart.getChart().getXYPlot().getRangeAxis().setLabel(this.unit);
        if (this.label != null) {
            this.vectorChart.getChart().getXYPlot().getDomainAxis().setLabel(this.label);
            this.vectorLogChart.getChart().getXYPlot().getDomainAxis().setLabel(this.label);
        } else {
            this.vectorChart.getChart().getXYPlot().getDomainAxis().setLabel("Events");
            this.vectorLogChart.getChart().getXYPlot().getDomainAxis().setLabel("Events");
        }
    }

    private void setIdentificationPanel(VectorHolder model) {
        this.idPanel.setModel(model);
    }

    private void initPropagations() {
        this.hasSortedDistributions = !this.propagations.isEmpty() && this.propagations.get(0).getSortedDistributions() != null;
        for (VectorHolder propagation : this.propagations) {
            propagation.init();
            if (this.minDataValue > propagation.getMin()) {
                this.minDataValue = propagation.getMin();
            }
            if (!(this.maxDataValue < propagation.getMax())) continue;
            this.maxDataValue = propagation.getMax();
        }
        this.signalIsConstant = this.allConstant();
    }

    private boolean allConstant() {
        if (!this.propagations.isEmpty()) {
            for (VectorHolder propagation : this.propagations) {
                if (propagation.isConstant()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setRanges() {
        if (!this.propagations.isEmpty()) {
            VectorHelper.setVectorDataRange(this.propagations, this.signalIsConstant, this.vectorChart);
            VectorHelper.setLogDataRange(this.propagations, this.minDataValue != this.maxDataValue, this.minDataValue, this.maxDataValue, this.vectorLogChart, this.hasSortedDistributions);
        }
    }

    public List<VectorHolder> getPropagationHolders() {
        return this.propagations;
    }

    private void setListeners() {
        this.selector.getVector().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VectorPanel.this.hasSortedDistributions) {
                    VectorPanel.this.selector.getVectorLinear().setEnabled(true);
                    VectorPanel.this.selector.getVectorLog().setEnabled(true);
                }
                if (VectorPanel.this.selector.getVectorLog().isVisible() && VectorPanel.this.selector.getVectorLog().isEnabled() && VectorPanel.this.selector.getVectorLog().isSelected()) {
                    VectorPanel.this.cardLayout.show(VectorPanel.this.graphPanel, "vectorLog");
                } else {
                    if (VectorPanel.this.selector.getVectorLinear().isEnabled()) {
                        VectorPanel.this.selector.getVectorLinear().setSelected(true);
                    }
                    VectorPanel.this.cardLayout.show(VectorPanel.this.graphPanel, "vector");
                }
            }
        });
        this.selector.getVectorLinear().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VectorPanel.this.selector.getVector().isSelected()) {
                    VectorPanel.this.selector.getVector().setSelected(true);
                }
                VectorPanel.this.cardLayout.show(VectorPanel.this.graphPanel, "vector");
            }
        });
        this.selector.getVectorLog().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VectorPanel.this.selector.getVector().isSelected()) {
                    VectorPanel.this.selector.getVector().setSelected(true);
                }
                VectorPanel.this.cardLayout.show(VectorPanel.this.graphPanel, "vectorLog");
            }
        });
        this.selector.getCdf().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VectorPanel.this.selector.getVectorLinear().isEnabled()) {
                    VectorPanel.this.selector.getVectorLinear().setEnabled(false);
                    VectorPanel.this.selector.getVectorLog().setEnabled(false);
                }
                VectorPanel.this.cardLayout.show(VectorPanel.this.graphPanel, "cumulative");
            }
        });
        this.selector.getDensity().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorPanel.this.density();
            }
        });
    }

    public void density() {
        if (this.selector.getVectorLinear().isEnabled()) {
            this.selector.getVectorLinear().setEnabled(false);
            this.selector.getVectorLog().setEnabled(false);
        }
        if (this.selector.getDensity().isSelected()) {
            if (this.signalIsConstant) {
                JOptionPane.showMessageDialog(this, STRINGLIST.getString("HISTOGRAM_CONSTANTSIGNAL_WARNING"));
                this.selector.getVector().setSelected(true);
                this.cardLayout.show(this.graphPanel, "vector");
            } else {
                int bin = this.selector.getBinSize();
                HistogramDataset data = VectorHelper.getDensityHistogram(this.propagations, bin);
                if (this.densityChart != null) {
                    this.densityChart.getChart().getXYPlot().setDataset(data);
                }
                this.cardLayout.show(this.graphPanel, "pdf");
            }
        }
    }

    public void reset() {
        this.vectorChart.getChart().getXYPlot().setDataset(null);
        this.vectorLogChart.getChart().getXYPlot().setDataset(null);
        this.cumulativeChart.getChart().getXYPlot().setDataset(null);
        this.densityChart.getChart().getXYPlot().setDataset(null);
    }
}

