/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.presentation.display.VectorPanel;

public class VectorDisplaySelector
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final ButtonGroup buttons = new ButtonGroup();
    private final ButtonGroup vectorButtons = new ButtonGroup();
    private final JRadioButton cdf = new JRadioButton(STRINGLIST.getString("RESULTS_VECTOR_GRAPH_CDF_BUTTON_TITLE"));
    private final JRadioButton density = new JRadioButton(STRINGLIST.getString("RESULTS_VECTOR_GRAPH_DENSITY_BUTTON_TITLE"));
    private final JRadioButton vector = new JRadioButton(STRINGLIST.getString("RESULTS_VECTOR_GRAPH_VECTOR_BUTTON_TITLE"));
    private final JRadioButton vectorLinear = new JRadioButton(STRINGLIST.getString("RESULTS_VECTOR_GRAPH_VECTOR_LINEAR_BUTTON_TITLE"));
    private final JRadioButton vectorLog = new JRadioButton(STRINGLIST.getString("RESULTS_VECTOR_GRAPH_VECTOR_LOG_BUTTON_TITLE"));
    private final CalculatorInputField binCount = new CalculatorInputField();

    public VectorDisplaySelector(final VectorPanel parent) {
        JPanel bCount = new JPanel(new GridLayout(1, 2));
        final JLabel size = new JLabel("Bin number: ");
        bCount.add(size);
        bCount.add(this.binCount);
        this.binCount.setIntegerMode(true);
        this.binCount.setAllowNegatives(false);
        this.binCount.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object val = event.getNewValue();
                if (val != null) {
                    parent.density();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.vector.setSelected(true);
        gc.anchor = 17;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.insets = new Insets(0, 0, 0, 50);
        this.add((Component)this.vector, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 2;
        gc.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.vectorLinear, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 2;
        gc.insets = new Insets(0, 80, 0, 0);
        this.add((Component)this.vectorLog, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridheight = 1;
        gc.insets = new Insets(0, 0, 0, 50);
        this.add((Component)this.cdf, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridheight = 1;
        gc.insets = new Insets(0, 0, 0, 50);
        this.add((Component)this.density, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridheight = 1;
        gc.insets = new Insets(0, 10, 0, 0);
        this.add((Component)bCount, gc);
        this.buttons.add(this.vector);
        this.buttons.add(this.cdf);
        this.buttons.add(this.density);
        this.vectorButtons.add(this.vectorLinear);
        this.vectorButtons.add(this.vectorLog);
        this.setBorder(new TitledBorder(STRINGLIST.getString("RESULTS_VECTOR_BUTTONS_TITLE")));
        size.setEnabled(false);
        this.binCount.setEnabled(false);
        this.density.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean selected = VectorDisplaySelector.this.density.isSelected();
                size.setEnabled(selected);
                VectorDisplaySelector.this.binCount.setEnabled(selected);
            }
        });
    }

    public JRadioButton getVectorLinear() {
        return this.vectorLinear;
    }

    public JRadioButton getVectorLog() {
        return this.vectorLog;
    }

    public JRadioButton getVector() {
        return this.vector;
    }

    public JRadioButton getCdf() {
        return this.cdf;
    }

    public JRadioButton getDensity() {
        return this.density;
    }

    public int getBinSize() {
        return this.binCount.getValueAsInteger();
    }

    public void setBinSize(int binSize) {
        this.binCount.setValue(binSize);
    }
}

