/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.presentation.propagationtest.VectorHolder;

public class SignalChartFactory {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static float[][] pattern = new float[][]{{10.0f}, {10.0f, 10.0f}, {10.0f, 10.0f, 2.0f, 10.0f}, {1.0f, 20.0f}};

    public static synchronized ChartPanel createVectorChart(List<VectorHolder> propagations, Font font, XYSeriesCollection xySeriesCollection, boolean legend, String label) {
        String unit = "";
        if (propagations.size() > 0) {
            unit = propagations.get(0).getUnit();
        }
        JFreeChart scatter = ChartFactory.createScatterPlot("", "Events", unit, xySeriesCollection);
        for (int i = 0; i < xySeriesCollection.getSeriesCount(); ++i) {
            XYItemRenderer renderer = scatter.getXYPlot().getRenderer(0);
            Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, 2.0, 2.0);
            renderer.setBaseShape(shape);
            renderer.setSeriesShape(i, shape);
        }
        ChartPanel vectorChart = new ChartPanel(scatter);
        SignalChartFactory.applyStyles(vectorChart, font, legend);
        vectorChart.getChart().getXYPlot().setDataset(xySeriesCollection);
        if (propagations.size() == 1) {
            VectorHolder holder = propagations.get(0);
            if (label == null || label.isEmpty() || label.startsWith("Event")) {
                SignalChartFactory.addStatistics(vectorChart, holder.getAverage(), holder.getStandardDeviation(), holder.getData().length);
            }
        }
        return vectorChart;
    }

    private static void addStatistics(ChartPanel vectorChart, double mean, double stdDev, int length) {
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(SignalChartFactory.create("mean - std. dev", mean - stdDev, length));
        collection.addSeries(SignalChartFactory.create("mean", mean, length));
        collection.addSeries(SignalChartFactory.create("mean + std. dev", mean + stdDev, length));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setSeriesPaint(0, Color.BLACK);
        renderer.setSeriesPaint(1, Color.GREEN);
        renderer.setSeriesPaint(2, Color.BLACK);
        renderer.setSeriesStroke(0, SignalChartFactory.getOdynStroke(3.0f, 1));
        renderer.setSeriesStroke(1, SignalChartFactory.getOdynStroke(3.0f, 0));
        renderer.setSeriesStroke(2, SignalChartFactory.getOdynStroke(3.0f, 1));
        vectorChart.getChart().getXYPlot().setRenderer(1, renderer);
        vectorChart.getChart().getXYPlot().setDataset(1, collection);
    }

    private static Stroke[] strokes(float width) {
        Stroke[] strokes = new Stroke[]{new BasicStroke(width, 0, 0, 10.0f), new BasicStroke(width, 0, 0, 10.0f, pattern[1], 0.0f)};
        return strokes;
    }

    private static Stroke getOdynStroke(float width, int type) {
        return SignalChartFactory.strokes(width)[type];
    }

    private static XYSeries create(String title, double value, int length) {
        XYSeries series = new XYSeries((Comparable)((Object)title));
        series.add(0.0, value);
        series.add((double)length, value);
        return series;
    }

    protected static synchronized ChartPanel createVectorLogChart(String xTitle, String yTitle, XYSeriesCollection collection, double EVENT_LIMIT, Font font) {
        JFreeChart chart = ChartFactory.createXYLineChart(STRINGLIST.getString("VECTOR_GRAPH_TITLE"), xTitle, yTitle, collection, PlotOrientation.VERTICAL, true, true, false);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesShapesFilled(0, false);
        LogAxis xAxis = new LogAxis(xTitle);
        xAxis.setRange(new Range(0.0, EVENT_LIMIT));
        chart.getXYPlot().setDomainAxis(xAxis);
        ChartPanel vectorLogChart = new ChartPanel(chart);
        vectorLogChart.setMouseZoomable(true, false);
        SignalChartFactory.applyStyles(vectorLogChart, font, true);
        return vectorLogChart;
    }

    protected static synchronized ChartPanel createDensityGraph(String xTitle, String yTitle, Font font, HistogramDataset collection) {
        JFreeChart chart = ChartFactory.createHistogram(STRINGLIST.getString("HISTOGRAM_TITLE"), yTitle, STRINGLIST.getString("HISTOGRAM_AXIX_TITLE_Y"), collection, PlotOrientation.VERTICAL, true, false, false);
        ChartPanel densityChart = new ChartPanel(chart);
        SignalChartFactory.applyStyles(densityChart, font, true);
        return densityChart;
    }

    protected static synchronized ChartPanel createCumulativeChart(String xTitle, String yTitle, XYSeriesCollection cumulativeSeries, Font font, boolean signalIsConstant, String title, String unit) {
        JFreeChart chart = ChartFactory.createXYLineChart(STRINGLIST.getString("CUMULATIVE_DISTRIBUTION_TITLE"), yTitle, STRINGLIST.getString("CUMULATIVE_DISTRIBUTION_AXIX_TITLE_Y"), cumulativeSeries, PlotOrientation.VERTICAL, true, true, false);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        if (signalIsConstant) {
            ((NumberAxis)chart.getXYPlot().getRangeAxis()).setRange(new Range(0.0, 1.0));
        }
        chart.setTitle(title);
        chart.getXYPlot().getDomainAxis().setLabel(unit);
        renderer.setSeriesShapesVisible(0, false);
        ChartPanel cumulativeChart = new ChartPanel(chart);
        cumulativeChart.setMouseZoomable(true, false);
        SignalChartFactory.applyStyles(cumulativeChart, font, true);
        return cumulativeChart;
    }

    public static void applyStyles(ChartPanel chartPanel, Font font, boolean legend) {
        JFreeChart xyChart = chartPanel.getChart();
        if (!legend) {
            xyChart.removeLegend();
        }
        xyChart.setBackgroundPaint(chartPanel.getBackground());
        XYPlot p = chartPanel.getChart().getXYPlot();
        p.setBackgroundPaint(Color.WHITE);
        p.setRangeGridlinePaint(chartPanel.getForeground());
        p.setDomainGridlinePaint(chartPanel.getForeground());
        p.getDomainAxis().setTickLabelFont(font);
        p.getDomainAxis().setTickLabelPaint(chartPanel.getForeground());
        p.getDomainAxis().setLabelFont(font);
        p.getDomainAxis().setLabelPaint(chartPanel.getForeground());
        p.getRangeAxis().setTickLabelFont(font);
        p.getRangeAxis().setTickLabelPaint(chartPanel.getForeground());
        p.getRangeAxis().setLabelFont(font);
        p.getRangeAxis().setLabelPaint(chartPanel.getForeground());
    }
}

